/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.util;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.util.CompactStringObjectMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;

public class EnumResolver
implements Serializable {
    protected final Class<Enum<?>> _enumClass;
    protected final Enum<?>[] _enums;
    protected final HashMap<String, Enum<?>> _enumsById;
    protected final Enum<?> _defaultValue;

    protected EnumResolver(Class<Enum<?>> enumClass, Enum<?>[] enums, HashMap<String, Enum<?>> map, Enum<?> defaultValue) {
        this._enumClass = enumClass;
        this._enums = enums;
        this._enumsById = map;
        this._defaultValue = defaultValue;
    }

    public static EnumResolver constructFor(Class<Enum<?>> enumCls, AnnotationIntrospector ai) {
        Enum<?>[] enumValues = enumCls.getEnumConstants();
        if (enumValues == null) {
            throw new IllegalArgumentException("No enum constants for class " + enumCls.getName());
        }
        String[] names = ai.findEnumValues(enumCls, enumValues, new String[enumValues.length]);
        String[][] allAliases = new String[names.length][];
        ai.findEnumAliases(enumCls, enumValues, allAliases);
        HashMap map = new HashMap();
        int len = enumValues.length;
        for (int i2 = 0; i2 < len; ++i2) {
            Enum<?> enumValue = enumValues[i2];
            String name = names[i2];
            if (name == null) {
                name = enumValue.name();
            }
            map.put(name, enumValue);
            String[] aliases = allAliases[i2];
            if (aliases == null) continue;
            for (String alias : aliases) {
                if (map.containsKey(alias)) continue;
                map.put(alias, enumValue);
            }
        }
        return new EnumResolver(enumCls, enumValues, map, ai.findDefaultEnumValue(enumCls));
    }

    public static EnumResolver constructUsingToString(Class<Enum<?>> enumCls, AnnotationIntrospector ai) {
        Enum<?>[] enumConstants = enumCls.getEnumConstants();
        HashMap map = new HashMap();
        String[][] allAliases = new String[enumConstants.length][];
        ai.findEnumAliases(enumCls, enumConstants, allAliases);
        int i2 = enumConstants.length;
        while (--i2 >= 0) {
            Enum<?> enumValue = enumConstants[i2];
            map.put(enumValue.toString(), enumValue);
            String[] aliases = allAliases[i2];
            if (aliases == null) continue;
            for (String alias : aliases) {
                if (map.containsKey(alias)) continue;
                map.put(alias, enumValue);
            }
        }
        return new EnumResolver(enumCls, enumConstants, map, ai.findDefaultEnumValue(enumCls));
    }

    public static EnumResolver constructUsingMethod(Class<Enum<?>> enumCls, AnnotatedMember accessor, AnnotationIntrospector ai) {
        Enum<?>[] enumValues = enumCls.getEnumConstants();
        HashMap map = new HashMap();
        int i2 = enumValues.length;
        while (--i2 >= 0) {
            Enum<?> en = enumValues[i2];
            try {
                Object o2 = accessor.getValue(en);
                if (o2 == null) continue;
                map.put(o2.toString(), en);
            }
            catch (Exception e2) {
                throw new IllegalArgumentException("Failed to access @JsonValue of Enum value " + en + ": " + e2.getMessage());
            }
        }
        Enum<?> defaultEnum = ai != null ? ai.findDefaultEnumValue(enumCls) : null;
        return new EnumResolver(enumCls, enumValues, map, defaultEnum);
    }

    public static EnumResolver constructUnsafe(Class<?> rawEnumCls, AnnotationIntrospector ai) {
        Class<Enum<?>> enumCls = rawEnumCls;
        return EnumResolver.constructFor(enumCls, ai);
    }

    public static EnumResolver constructUnsafeUsingToString(Class<?> rawEnumCls, AnnotationIntrospector ai) {
        Class<Enum<?>> enumCls = rawEnumCls;
        return EnumResolver.constructUsingToString(enumCls, ai);
    }

    public static EnumResolver constructUnsafeUsingMethod(Class<?> rawEnumCls, AnnotatedMember accessor, AnnotationIntrospector ai) {
        Class<Enum<?>> enumCls = rawEnumCls;
        return EnumResolver.constructUsingMethod(enumCls, accessor, ai);
    }

    public CompactStringObjectMap constructLookup() {
        return CompactStringObjectMap.construct(this._enumsById);
    }

    public Enum<?> findEnum(String key) {
        return this._enumsById.get(key);
    }

    public Enum<?> getDefaultValue() {
        return this._defaultValue;
    }

    public Enum<?>[] getRawEnums() {
        return this._enums;
    }

    public Collection<String> getEnumIds() {
        return this._enumsById.keySet();
    }

    public Class<Enum<?>> getEnumClass() {
        return this._enumClass;
    }
}

