/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.apache.commons.compress.utils;

import java.io.IOException;
import java.io.InputStream;

public final class IOUtils {
    private static final byte[] SKIP_BUF = new byte[4096];

    public static long skip(InputStream input, long numToSkip) throws IOException {
        int read;
        long skipped;
        long available = numToSkip;
        while (numToSkip > 0L && (skipped = input.skip(numToSkip)) != 0L) {
            numToSkip -= skipped;
        }
        while (numToSkip > 0L && (read = IOUtils.readFully(input, SKIP_BUF, 0, (int)Math.min(numToSkip, 4096L))) >= 1) {
            numToSkip -= (long)read;
        }
        return available - numToSkip;
    }

    public static int readFully(InputStream input, byte[] array) throws IOException {
        return IOUtils.readFully(input, array, 0, array.length);
    }

    public static int readFully(InputStream input, byte[] array, int offset, int len) throws IOException {
        int count;
        if (len < 0 || offset < 0 || len + offset > array.length) {
            throw new IndexOutOfBoundsException();
        }
        int x2 = 0;
        for (count = 0; count != len && (x2 = input.read(array, offset + count, len - count)) != -1; count += x2) {
        }
        return count;
    }
}

