/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.common.configuration;

import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Stream;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Profile;
import org.apache.maven.project.MavenProject;

class TemplateEvaluationContext {
    private final MavenSession a;
    private final MavenProject b;
    private final Map<String, String> c;
    private final Properties d;
    private final String e;

    TemplateEvaluationContext(MavenSession session, MavenProject project) {
        this(session, project, System.getenv());
    }

    TemplateEvaluationContext(MavenSession session, MavenProject project, Map<String, String> env) {
        this.a = session;
        this.b = project;
        this.c = env;
        this.d = TemplateEvaluationContext.a(session, project);
        this.e = TemplateEvaluationContext.a(session.getRequest(), project);
    }

    private static Properties a(MavenSession session, MavenProject project) {
        MavenExecutionRequest request = session.getRequest();
        Properties properties = new Properties();
        ImmutableSet activeProfiles = ImmutableSet.copyOf(request.getActiveProfiles());
        for (Profile profile : request.getProfiles()) {
            if (!activeProfiles.contains(profile.getId())) continue;
            properties.putAll((Map<?, ?>)profile.getProperties());
        }
        if (project != null) {
            properties.putAll((Map<?, ?>)project.getProperties());
        }
        properties.putAll((Map<?, ?>)request.getUserProperties());
        properties.putAll((Map<?, ?>)request.getSystemProperties());
        return properties;
    }

    public MavenSession getSession() {
        return this.a;
    }

    public MavenProject getProject() {
        return this.b;
    }

    public MavenProject getPom() {
        return this.b;
    }

    public Map<String, String> getEnv() {
        return this.c;
    }

    public Properties getProperties() {
        return this.d;
    }

    public String getBasedir() {
        return this.e;
    }

    private static String a(MavenExecutionRequest request, MavenProject project) {
        File basedir;
        String result = null;
        if (project != null && (basedir = project.getBasedir()) != null) {
            result = basedir.getAbsolutePath();
        }
        if (result == null) {
            result = request.getBaseDirectory();
        }
        if (result == null) {
            result = System.getProperty("user.dir");
        }
        return result;
    }

    public static boolean isFalse(Object value) {
        String stringValue = String.valueOf(value);
        return Stream.of("false", "0", "0.0", "null").anyMatch(it -> it.equalsIgnoreCase(stringValue));
    }

    public static boolean isTrue(Object value) {
        return !TemplateEvaluationContext.isFalse(value);
    }
}

