/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast;

import com.gradle.maven.extension.internal.dep.org.springframework.asm.MethodVisitor;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.EvaluationException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.TypedValue;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.CodeFlow;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ExpressionState;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.SpelEvaluationException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.SpelNodeImpl;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.ValueRef;
import java.util.StringJoiner;

public class CompoundExpression
extends SpelNodeImpl {
    public CompoundExpression(int startPos, int endPos, SpelNodeImpl ... expressionComponents) {
        super(startPos, endPos, expressionComponents);
        if (expressionComponents.length < 2) {
            throw new IllegalStateException("Do not build compound expressions with less than two entries: " + expressionComponents.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ValueRef getValueRef(ExpressionState state) throws EvaluationException {
        if (this.getChildCount() == 1) {
            return this.children[0].getValueRef(state);
        }
        SpelNodeImpl nextNode = this.children[0];
        TypedValue result = nextNode.getValueInternal(state);
        int cc = this.getChildCount();
        for (int i2 = 1; i2 < cc - 1; ++i2) {
            try {
                state.pushActiveContextObject(result);
                nextNode = this.children[i2];
                result = nextNode.getValueInternal(state);
                continue;
            }
            finally {
                state.popActiveContextObject();
            }
        }
        try {
            state.pushActiveContextObject(result);
            nextNode = this.children[cc - 1];
            ValueRef valueRef = nextNode.getValueRef(state);
            state.popActiveContextObject();
            return valueRef;
        }
        catch (Throwable throwable) {
            try {
                state.popActiveContextObject();
                throw throwable;
            }
            catch (SpelEvaluationException ex) {
                ex.setPosition(nextNode.getStartPosition());
                throw ex;
            }
        }
    }

    @Override
    public TypedValue getValueInternal(ExpressionState state) throws EvaluationException {
        ValueRef ref = this.getValueRef(state);
        TypedValue result = ref.getValue();
        this.exitTypeDescriptor = this.children[this.children.length - 1].exitTypeDescriptor;
        return result;
    }

    @Override
    public void setValue(ExpressionState state, Object value) throws EvaluationException {
        this.getValueRef(state).setValue(value);
    }

    @Override
    public String toStringAST() {
        StringJoiner sj = new StringJoiner(".");
        for (int i2 = 0; i2 < this.getChildCount(); ++i2) {
            sj.add(this.getChild(i2).toStringAST());
        }
        return sj.toString();
    }

    @Override
    public boolean isCompilable() {
        for (SpelNodeImpl child : this.children) {
            if (child.isCompilable()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void generateCode(MethodVisitor mv, CodeFlow cf) {
        for (SpelNodeImpl child : this.children) {
            child.generateCode(mv, cf);
        }
        cf.pushDescriptor(this.exitTypeDescriptor);
    }
}

