/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.common.configuration;

import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableSet;
import com.gradle.maven.extension.internal.dep.org.apache.commons.codec.binary.Hex;
import com.gradle.scan.plugin.internal.b.c.b;
import java.io.File;
import java.net.InetAddress;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Profile;
import org.apache.maven.project.MavenProject;

class TemplateEvaluationContext {
    private final MavenSession a;
    private final MavenProject b;
    private final Map<String, String> c;
    private final Properties d;
    private final String e;
    private final String f;
    private final List<String> g;

    static TemplateEvaluationContext a(MavenSession session, MavenProject project) {
        b systemInfo = com.gradle.scan.plugin.internal.b.c.b.e();
        return new TemplateEvaluationContext(session, project, System.getenv(), systemInfo.b(), systemInfo.d().stream().map(InetAddress::getHostAddress).collect(Collectors.toList()));
    }

    TemplateEvaluationContext(MavenSession session, MavenProject project, Map<String, String> env, String username, List<String> ipAddresses) {
        this.a = session;
        this.b = project;
        this.c = env;
        this.d = TemplateEvaluationContext.b(session, project);
        this.e = TemplateEvaluationContext.a(session.getRequest(), project);
        this.f = username;
        this.g = ipAddresses;
    }

    private static Properties b(MavenSession session, MavenProject project) {
        MavenExecutionRequest request = session.getRequest();
        Properties properties = new Properties();
        ImmutableSet activeProfiles = ImmutableSet.copyOf(request.getActiveProfiles());
        for (Profile profile : request.getProfiles()) {
            if (!activeProfiles.contains(profile.getId())) continue;
            properties.putAll((Map<?, ?>)profile.getProperties());
        }
        if (project != null) {
            properties.putAll((Map<?, ?>)project.getProperties());
        }
        properties.putAll((Map<?, ?>)request.getUserProperties());
        properties.putAll((Map<?, ?>)request.getSystemProperties());
        return properties;
    }

    public MavenSession getSession() {
        return this.a;
    }

    public MavenProject getProject() {
        return this.b;
    }

    public MavenProject getPom() {
        return this.b;
    }

    public Map<String, String> getEnv() {
        return this.c;
    }

    public Properties getProperties() {
        return this.d;
    }

    public String getBasedir() {
        return this.e;
    }

    public String getUsername() {
        return this.f;
    }

    public List<String> getIpAddresses() {
        return this.g;
    }

    private static String a(MavenExecutionRequest request, MavenProject project) {
        File basedir;
        String result = null;
        if (project != null && (basedir = project.getBasedir()) != null) {
            result = basedir.getAbsolutePath();
        }
        if (result == null) {
            result = request.getBaseDirectory();
        }
        if (result == null) {
            result = System.getProperty("user.dir");
        }
        return result;
    }

    public static boolean isFalse(Object value) {
        String stringValue = String.valueOf(value);
        return Stream.of("false", "0", "0.0", "null").anyMatch(it -> it.equalsIgnoreCase(stringValue));
    }

    public static boolean isTrue(Object value) {
        return !TemplateEvaluationContext.isFalse(value);
    }

    public static Object sha512(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof List) {
            return ((List)value).stream().map(TemplateEvaluationContext::sha512).collect(Collectors.toList());
        }
        String stringValue = value.toString();
        try {
            byte[] digest = MessageDigest.getInstance("SHA-512").digest(stringValue.getBytes());
            return Hex.encodeHexString(digest);
        }
        catch (NoSuchAlgorithmException e2) {
            throw new RuntimeException(e2);
        }
    }
}

