/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.google.common.collect;

import com.gradle.maven.extension.internal.dep.com.google.common.collect.BaseImmutableMultimap;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.CollectPreconditions;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableCollection;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableListMultimap;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableMap;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.Ordering;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.Platform;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;

public abstract class ImmutableMultimap<K, V>
extends BaseImmutableMultimap<K, V>
implements Serializable {
    final transient ImmutableMap<K, ? extends ImmutableCollection<V>> map;
    final transient int size;

    public static <K, V> Builder<K, V> builder() {
        return new Builder();
    }

    ImmutableMultimap(ImmutableMap<K, ? extends ImmutableCollection<V>> map, int size) {
        this.map = map;
        this.size = size;
    }

    @Override
    public ImmutableMap<K, Collection<V>> asMap() {
        return this.map;
    }

    @Override
    Map<K, Collection<V>> createAsMap() {
        throw new AssertionError((Object)"should never be called");
    }

    public static class Builder<K, V> {
        Map<K, Collection<V>> builderMap = Platform.preservesInsertionOrderOnPutsMap();
        Comparator<? super K> keyComparator;
        Comparator<? super V> valueComparator;

        Collection<V> newMutableValueCollection() {
            return new ArrayList();
        }

        public Builder<K, V> put(K key, V value) {
            CollectPreconditions.checkEntryNotNull(key, value);
            Collection<V> valueCollection = this.builderMap.get(key);
            if (valueCollection == null) {
                valueCollection = this.newMutableValueCollection();
                this.builderMap.put(key, valueCollection);
            }
            valueCollection.add(value);
            return this;
        }

        public ImmutableMultimap<K, V> build() {
            Collection<Map.Entry<K, Collection<V>>> mapEntries = this.builderMap.entrySet();
            if (this.keyComparator != null) {
                mapEntries = Ordering.from(this.keyComparator).onKeys().immutableSortedCopy(mapEntries);
            }
            return ImmutableListMultimap.fromMapEntries(mapEntries, this.valueComparator);
        }
    }
}

