/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast;

import com.gradle.maven.extension.internal.dep.org.springframework.asm.MethodVisitor;
import com.gradle.maven.extension.internal.dep.org.springframework.asm.Opcodes;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.EvaluationException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.TypedValue;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.common.ExpressionUtils;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.CodeFlow;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ExpressionState;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.SpelEvaluationException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.SpelMessage;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.SpelNode;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.ValueRef;
import com.gradle.maven.extension.internal.dep.org.springframework.util.Assert;
import com.gradle.maven.extension.internal.dep.org.springframework.util.ObjectUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;

public abstract class SpelNodeImpl
implements Opcodes,
SpelNode {
    private static final SpelNodeImpl[] NO_CHILDREN = new SpelNodeImpl[0];
    private final int startPos;
    private final int endPos;
    protected SpelNodeImpl[] children = NO_CHILDREN;
    private SpelNodeImpl parent;
    protected volatile String exitTypeDescriptor;

    public SpelNodeImpl(int startPos, int endPos, SpelNodeImpl ... operands) {
        this.startPos = startPos;
        this.endPos = endPos;
        if (!ObjectUtils.isEmpty(operands)) {
            this.children = operands;
            for (SpelNodeImpl operand : operands) {
                Assert.notNull((Object)operand, "Operand must not be null");
                operand.parent = this;
            }
        }
    }

    protected boolean nextChildIs(Class<?> ... classes) {
        if (this.parent != null) {
            SpelNodeImpl[] peers = this.parent.children;
            int max = peers.length;
            for (int i2 = 0; i2 < max; ++i2) {
                if (this != peers[i2]) continue;
                if (i2 + 1 >= max) {
                    return false;
                }
                Class<?> peerClass = peers[i2 + 1].getClass();
                for (Class<?> desiredClass : classes) {
                    if (peerClass != desiredClass) continue;
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    @Override
    public final Object getValue(ExpressionState expressionState) throws EvaluationException {
        return this.getValueInternal(expressionState).getValue();
    }

    @Override
    public final TypedValue getTypedValue(ExpressionState expressionState) throws EvaluationException {
        return this.getValueInternal(expressionState);
    }

    @Override
    public void setValue(ExpressionState expressionState, Object newValue) throws EvaluationException {
        throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.SETVALUE_NOT_SUPPORTED, this.getClass());
    }

    public SpelNode getChild(int index) {
        return this.children[index];
    }

    public int getChildCount() {
        return this.children.length;
    }

    public Class<?> getObjectClass(Object obj) {
        if (obj == null) {
            return null;
        }
        return obj instanceof Class ? (Class<?>)obj : obj.getClass();
    }

    @Override
    public int getStartPosition() {
        return this.startPos;
    }

    public int getEndPosition() {
        return this.endPos;
    }

    public boolean isCompilable() {
        return false;
    }

    public void generateCode(MethodVisitor mv, CodeFlow cf) {
        throw new IllegalStateException(this.getClass().getName() + " has no generateCode(..) method");
    }

    public String getExitDescriptor() {
        return this.exitTypeDescriptor;
    }

    protected final <T> T getValue(ExpressionState state, Class<T> desiredReturnType) throws EvaluationException {
        return ExpressionUtils.convertTypedValue(state.getEvaluationContext(), this.getValueInternal(state), desiredReturnType);
    }

    protected ValueRef getValueRef(ExpressionState state) throws EvaluationException {
        throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.NOT_ASSIGNABLE, this.toStringAST());
    }

    public abstract TypedValue getValueInternal(ExpressionState var1) throws EvaluationException;

    protected static void generateCodeForArguments(MethodVisitor mv, CodeFlow cf, Member member, SpelNodeImpl[] arguments) {
        String[] paramDescriptors = null;
        boolean isVarargs = false;
        if (member instanceof Constructor) {
            Constructor ctor = (Constructor)member;
            paramDescriptors = CodeFlow.toDescriptors(ctor.getParameterTypes());
            isVarargs = ctor.isVarArgs();
        } else {
            Method method = (Method)member;
            paramDescriptors = CodeFlow.toDescriptors(method.getParameterTypes());
            isVarargs = method.isVarArgs();
        }
        if (isVarargs) {
            int p2 = 0;
            int childCount = arguments.length;
            for (p2 = 0; p2 < paramDescriptors.length - 1; ++p2) {
                SpelNodeImpl.generateCodeForArgument(mv, cf, arguments[p2], paramDescriptors[p2]);
            }
            SpelNodeImpl lastChild = childCount == 0 ? null : arguments[childCount - 1];
            String arrayType = paramDescriptors[paramDescriptors.length - 1];
            if (lastChild != null && arrayType.equals(lastChild.getExitDescriptor())) {
                SpelNodeImpl.generateCodeForArgument(mv, cf, lastChild, paramDescriptors[p2]);
            } else {
                arrayType = arrayType.substring(1);
                CodeFlow.insertNewArrayCode(mv, childCount - p2, arrayType);
                int arrayindex = 0;
                while (p2 < childCount) {
                    SpelNodeImpl child = arguments[p2];
                    mv.visitInsn(89);
                    CodeFlow.insertOptimalLoad(mv, arrayindex++);
                    SpelNodeImpl.generateCodeForArgument(mv, cf, child, arrayType);
                    CodeFlow.insertArrayStore(mv, arrayType);
                    ++p2;
                }
            }
        } else {
            for (int i2 = 0; i2 < paramDescriptors.length; ++i2) {
                SpelNodeImpl.generateCodeForArgument(mv, cf, arguments[i2], paramDescriptors[i2]);
            }
        }
    }

    protected static void generateCodeForArgument(MethodVisitor mv, CodeFlow cf, SpelNodeImpl argument, String paramDesc) {
        cf.enterCompilationScope();
        argument.generateCode(mv, cf);
        String lastDesc = cf.lastDescriptor();
        Assert.state(lastDesc != null, "No last descriptor");
        boolean primitiveOnStack = CodeFlow.isPrimitive(lastDesc);
        if (primitiveOnStack && paramDesc.charAt(0) == 'L') {
            CodeFlow.insertBoxIfNecessary(mv, lastDesc.charAt(0));
        } else if (paramDesc.length() == 1 && !primitiveOnStack) {
            CodeFlow.insertUnboxInsns(mv, paramDesc.charAt(0), lastDesc);
        } else if (!paramDesc.equals(lastDesc)) {
            CodeFlow.insertCheckCast(mv, paramDesc);
        }
        cf.exitCompilationScope();
    }
}

