/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.util;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.StringJoiner;

public abstract class ObjectUtils {
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];

    public static boolean isArray(Object obj) {
        return obj != null && obj.getClass().isArray();
    }

    public static boolean isEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    public static Object[] toObjectArray(Object source) {
        if (source instanceof Object[]) {
            return (Object[])source;
        }
        if (source == null) {
            return EMPTY_OBJECT_ARRAY;
        }
        if (!source.getClass().isArray()) {
            throw new IllegalArgumentException("Source is not an array: " + source);
        }
        int length = Array.getLength(source);
        if (length == 0) {
            return EMPTY_OBJECT_ARRAY;
        }
        Class<?> wrapperType = Array.get(source, 0).getClass();
        Object[] newArray = (Object[])Array.newInstance(wrapperType, length);
        for (int i2 = 0; i2 < length; ++i2) {
            newArray[i2] = Array.get(source, i2);
        }
        return newArray;
    }

    public static boolean nullSafeEquals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        if (o1.equals(o2)) {
            return true;
        }
        if (o1.getClass().isArray() && o2.getClass().isArray()) {
            return ObjectUtils.arrayEquals(o1, o2);
        }
        return false;
    }

    private static boolean arrayEquals(Object o1, Object o2) {
        if (o1 instanceof Object[] && o2 instanceof Object[]) {
            return Arrays.equals((Object[])o1, (Object[])o2);
        }
        if (o1 instanceof boolean[] && o2 instanceof boolean[]) {
            return Arrays.equals((boolean[])o1, (boolean[])o2);
        }
        if (o1 instanceof byte[] && o2 instanceof byte[]) {
            return Arrays.equals((byte[])o1, (byte[])o2);
        }
        if (o1 instanceof char[] && o2 instanceof char[]) {
            return Arrays.equals((char[])o1, (char[])o2);
        }
        if (o1 instanceof double[] && o2 instanceof double[]) {
            return Arrays.equals((double[])o1, (double[])o2);
        }
        if (o1 instanceof float[] && o2 instanceof float[]) {
            return Arrays.equals((float[])o1, (float[])o2);
        }
        if (o1 instanceof int[] && o2 instanceof int[]) {
            return Arrays.equals((int[])o1, (int[])o2);
        }
        if (o1 instanceof long[] && o2 instanceof long[]) {
            return Arrays.equals((long[])o1, (long[])o2);
        }
        if (o1 instanceof short[] && o2 instanceof short[]) {
            return Arrays.equals((short[])o1, (short[])o2);
        }
        return false;
    }

    public static int nullSafeHashCode(Object obj) {
        if (obj == null) {
            return 0;
        }
        if (obj.getClass().isArray()) {
            if (obj instanceof Object[]) {
                return ObjectUtils.nullSafeHashCode((Object[])obj);
            }
            if (obj instanceof boolean[]) {
                return ObjectUtils.nullSafeHashCode((boolean[])obj);
            }
            if (obj instanceof byte[]) {
                return ObjectUtils.nullSafeHashCode((byte[])obj);
            }
            if (obj instanceof char[]) {
                return ObjectUtils.nullSafeHashCode((char[])obj);
            }
            if (obj instanceof double[]) {
                return ObjectUtils.nullSafeHashCode((double[])obj);
            }
            if (obj instanceof float[]) {
                return ObjectUtils.nullSafeHashCode((float[])obj);
            }
            if (obj instanceof int[]) {
                return ObjectUtils.nullSafeHashCode((int[])obj);
            }
            if (obj instanceof long[]) {
                return ObjectUtils.nullSafeHashCode((long[])obj);
            }
            if (obj instanceof short[]) {
                return ObjectUtils.nullSafeHashCode((short[])obj);
            }
        }
        return obj.hashCode();
    }

    public static int nullSafeHashCode(Object[] array) {
        if (array == null) {
            return 0;
        }
        int hash = 7;
        for (Object element : array) {
            hash = 31 * hash + ObjectUtils.nullSafeHashCode(element);
        }
        return hash;
    }

    public static int nullSafeHashCode(boolean[] array) {
        if (array == null) {
            return 0;
        }
        int hash = 7;
        for (boolean element : array) {
            hash = 31 * hash + Boolean.hashCode(element);
        }
        return hash;
    }

    public static int nullSafeHashCode(byte[] array) {
        if (array == null) {
            return 0;
        }
        int hash = 7;
        for (byte element : array) {
            hash = 31 * hash + element;
        }
        return hash;
    }

    public static int nullSafeHashCode(char[] array) {
        if (array == null) {
            return 0;
        }
        int hash = 7;
        for (char element : array) {
            hash = 31 * hash + element;
        }
        return hash;
    }

    public static int nullSafeHashCode(double[] array) {
        if (array == null) {
            return 0;
        }
        int hash = 7;
        for (double element : array) {
            hash = 31 * hash + Double.hashCode(element);
        }
        return hash;
    }

    public static int nullSafeHashCode(float[] array) {
        if (array == null) {
            return 0;
        }
        int hash = 7;
        for (float element : array) {
            hash = 31 * hash + Float.hashCode(element);
        }
        return hash;
    }

    public static int nullSafeHashCode(int[] array) {
        if (array == null) {
            return 0;
        }
        int hash = 7;
        for (int element : array) {
            hash = 31 * hash + element;
        }
        return hash;
    }

    public static int nullSafeHashCode(long[] array) {
        if (array == null) {
            return 0;
        }
        int hash = 7;
        for (long element : array) {
            hash = 31 * hash + Long.hashCode(element);
        }
        return hash;
    }

    public static int nullSafeHashCode(short[] array) {
        if (array == null) {
            return 0;
        }
        int hash = 7;
        for (short element : array) {
            hash = 31 * hash + element;
        }
        return hash;
    }

    public static String nullSafeToString(Object obj) {
        if (obj == null) {
            return "null";
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof Object[]) {
            return ObjectUtils.nullSafeToString((Object[])obj);
        }
        if (obj instanceof boolean[]) {
            return ObjectUtils.nullSafeToString((boolean[])obj);
        }
        if (obj instanceof byte[]) {
            return ObjectUtils.nullSafeToString((byte[])obj);
        }
        if (obj instanceof char[]) {
            return ObjectUtils.nullSafeToString((char[])obj);
        }
        if (obj instanceof double[]) {
            return ObjectUtils.nullSafeToString((double[])obj);
        }
        if (obj instanceof float[]) {
            return ObjectUtils.nullSafeToString((float[])obj);
        }
        if (obj instanceof int[]) {
            return ObjectUtils.nullSafeToString((int[])obj);
        }
        if (obj instanceof long[]) {
            return ObjectUtils.nullSafeToString((long[])obj);
        }
        if (obj instanceof short[]) {
            return ObjectUtils.nullSafeToString((short[])obj);
        }
        String str = obj.toString();
        return str != null ? str : "";
    }

    public static String nullSafeToString(Object[] array) {
        if (array == null) {
            return "null";
        }
        int length = array.length;
        if (length == 0) {
            return "{}";
        }
        StringJoiner stringJoiner = new StringJoiner(", ", "{", "}");
        for (Object o2 : array) {
            stringJoiner.add(String.valueOf(o2));
        }
        return stringJoiner.toString();
    }

    public static String nullSafeToString(boolean[] array) {
        if (array == null) {
            return "null";
        }
        int length = array.length;
        if (length == 0) {
            return "{}";
        }
        StringJoiner stringJoiner = new StringJoiner(", ", "{", "}");
        for (boolean b2 : array) {
            stringJoiner.add(String.valueOf(b2));
        }
        return stringJoiner.toString();
    }

    public static String nullSafeToString(byte[] array) {
        if (array == null) {
            return "null";
        }
        int length = array.length;
        if (length == 0) {
            return "{}";
        }
        StringJoiner stringJoiner = new StringJoiner(", ", "{", "}");
        for (byte b2 : array) {
            stringJoiner.add(String.valueOf(b2));
        }
        return stringJoiner.toString();
    }

    public static String nullSafeToString(char[] array) {
        if (array == null) {
            return "null";
        }
        int length = array.length;
        if (length == 0) {
            return "{}";
        }
        StringJoiner stringJoiner = new StringJoiner(", ", "{", "}");
        for (char c2 : array) {
            stringJoiner.add('\'' + String.valueOf(c2) + '\'');
        }
        return stringJoiner.toString();
    }

    public static String nullSafeToString(double[] array) {
        if (array == null) {
            return "null";
        }
        int length = array.length;
        if (length == 0) {
            return "{}";
        }
        StringJoiner stringJoiner = new StringJoiner(", ", "{", "}");
        for (double d2 : array) {
            stringJoiner.add(String.valueOf(d2));
        }
        return stringJoiner.toString();
    }

    public static String nullSafeToString(float[] array) {
        if (array == null) {
            return "null";
        }
        int length = array.length;
        if (length == 0) {
            return "{}";
        }
        StringJoiner stringJoiner = new StringJoiner(", ", "{", "}");
        for (float f2 : array) {
            stringJoiner.add(String.valueOf(f2));
        }
        return stringJoiner.toString();
    }

    public static String nullSafeToString(int[] array) {
        if (array == null) {
            return "null";
        }
        int length = array.length;
        if (length == 0) {
            return "{}";
        }
        StringJoiner stringJoiner = new StringJoiner(", ", "{", "}");
        for (int i2 : array) {
            stringJoiner.add(String.valueOf(i2));
        }
        return stringJoiner.toString();
    }

    public static String nullSafeToString(long[] array) {
        if (array == null) {
            return "null";
        }
        int length = array.length;
        if (length == 0) {
            return "{}";
        }
        StringJoiner stringJoiner = new StringJoiner(", ", "{", "}");
        for (long l2 : array) {
            stringJoiner.add(String.valueOf(l2));
        }
        return stringJoiner.toString();
    }

    public static String nullSafeToString(short[] array) {
        if (array == null) {
            return "null";
        }
        int length = array.length;
        if (length == 0) {
            return "{}";
        }
        StringJoiner stringJoiner = new StringJoiner(", ", "{", "}");
        for (short s2 : array) {
            stringJoiner.add(String.valueOf(s2));
        }
        return stringJoiner.toString();
    }
}

