/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.FormatSchema;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonFactory;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonGenerator;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonParseException;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonParser;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonProcessingException;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonToken;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.ObjectCodec;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.TreeNode;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.filter.FilteringParserDelegate;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.filter.TokenFilter;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.type.TypeReference;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.DeserializationConfig;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.DeserializationContext;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.DeserializationFeature;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.InjectableValues;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JavaType;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JsonDeserializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JsonMappingException;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JsonNode;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.ObjectMapper;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.PropertyName;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.DataFormatReaders;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.DefaultDeserializationContext;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.node.TreeTraversingParser;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;

public class ObjectReader
extends ObjectCodec
implements Serializable {
    protected final DeserializationConfig _config;
    protected final DefaultDeserializationContext _context;
    protected final JsonFactory _parserFactory;
    protected final boolean _unwrapRoot;
    private final TokenFilter _filter;
    protected final JavaType _valueType;
    protected final JsonDeserializer<Object> _rootDeserializer;
    protected final Object _valueToUpdate;
    protected final FormatSchema _schema;
    protected final InjectableValues _injectableValues;
    protected final DataFormatReaders _dataFormatReaders;
    protected final ConcurrentHashMap<JavaType, JsonDeserializer<Object>> _rootDeserializers;

    protected ObjectReader(ObjectMapper mapper, DeserializationConfig config) {
        this(mapper, config, null, null, null, null);
    }

    protected ObjectReader(ObjectMapper mapper, DeserializationConfig config, JavaType valueType, Object valueToUpdate, FormatSchema schema, InjectableValues injectableValues) {
        this._config = config;
        this._context = mapper._deserializationContext;
        this._rootDeserializers = mapper._rootDeserializers;
        this._parserFactory = mapper._jsonFactory;
        this._valueType = valueType;
        this._valueToUpdate = valueToUpdate;
        this._schema = schema;
        this._injectableValues = injectableValues;
        this._unwrapRoot = config.useRootWrapping();
        this._rootDeserializer = this._prefetchRootDeserializer(valueType);
        this._dataFormatReaders = null;
        this._filter = null;
    }

    protected ObjectReader(ObjectReader base, DeserializationConfig config, JavaType valueType, JsonDeserializer<Object> rootDeser, Object valueToUpdate, FormatSchema schema, InjectableValues injectableValues, DataFormatReaders dataFormatReaders) {
        this._config = config;
        this._context = base._context;
        this._rootDeserializers = base._rootDeserializers;
        this._parserFactory = base._parserFactory;
        this._valueType = valueType;
        this._rootDeserializer = rootDeser;
        this._valueToUpdate = valueToUpdate;
        this._schema = schema;
        this._injectableValues = injectableValues;
        this._unwrapRoot = config.useRootWrapping();
        this._dataFormatReaders = dataFormatReaders;
        this._filter = base._filter;
    }

    protected ObjectReader _new(ObjectReader base, DeserializationConfig config, JavaType valueType, JsonDeserializer<Object> rootDeser, Object valueToUpdate, FormatSchema schema, InjectableValues injectableValues, DataFormatReaders dataFormatReaders) {
        return new ObjectReader(base, config, valueType, rootDeser, valueToUpdate, schema, injectableValues, dataFormatReaders);
    }

    protected JsonToken _initForReading(DeserializationContext ctxt, JsonParser p2) throws IOException {
        if (this._schema != null) {
            p2.setSchema(this._schema);
        }
        this._config.initialize(p2);
        JsonToken t2 = p2.getCurrentToken();
        if (t2 == null && (t2 = p2.nextToken()) == null) {
            ctxt.reportInputMismatch(this._valueType, "No content to map due to end-of-input", new Object[0]);
        }
        return t2;
    }

    public ObjectReader with(InjectableValues injectableValues) {
        if (this._injectableValues == injectableValues) {
            return this;
        }
        return this._new(this, this._config, this._valueType, this._rootDeserializer, this._valueToUpdate, this._schema, injectableValues, this._dataFormatReaders);
    }

    public ObjectReader forType(JavaType valueType) {
        if (valueType != null && valueType.equals(this._valueType)) {
            return this;
        }
        JsonDeserializer<Object> rootDeser = this._prefetchRootDeserializer(valueType);
        DataFormatReaders det = this._dataFormatReaders;
        if (det != null) {
            det = det.withType(valueType);
        }
        return this._new(this, this._config, valueType, rootDeser, this._valueToUpdate, this._schema, this._injectableValues, det);
    }

    public ObjectReader forType(Class<?> valueType) {
        return this.forType(this._config.constructType(valueType));
    }

    public ObjectReader forType(TypeReference<?> valueTypeRef) {
        return this.forType(this._config.getTypeFactory().constructType(valueTypeRef.getType()));
    }

    public ObjectReader withValueToUpdate(Object value) {
        if (value == this._valueToUpdate) {
            return this;
        }
        if (value == null) {
            return this._new(this, this._config, this._valueType, this._rootDeserializer, null, this._schema, this._injectableValues, this._dataFormatReaders);
        }
        JavaType t2 = this._valueType == null ? this._config.constructType(value.getClass()) : this._valueType;
        return this._new(this, this._config, t2, this._rootDeserializer, value, this._schema, this._injectableValues, this._dataFormatReaders);
    }

    @Override
    public JsonFactory getFactory() {
        return this._parserFactory;
    }

    public JsonParser createParser(String content) throws IOException {
        this._assertNotNull("content", content);
        return this._parserFactory.createParser(content);
    }

    public <T> T readValue(JsonParser p2) throws IOException {
        this._assertNotNull("p", p2);
        return (T)this._bind(p2, this._valueToUpdate);
    }

    @Override
    public <T> T readValue(JsonParser p2, Class<T> valueType) throws IOException {
        this._assertNotNull("p", p2);
        return this.forType(valueType).readValue(p2);
    }

    @Override
    public <T> T readValue(JsonParser p2, TypeReference<T> valueTypeRef) throws IOException {
        this._assertNotNull("p", p2);
        return this.forType(valueTypeRef).readValue(p2);
    }

    public JsonParser treeAsTokens(TreeNode n2) {
        this._assertNotNull("n", n2);
        ObjectReader codec = this.withValueToUpdate(null);
        return new TreeTraversingParser((JsonNode)n2, codec);
    }

    public <T> T readValue(String src) throws JsonProcessingException, JsonMappingException {
        if (this._dataFormatReaders != null) {
            this._reportUndetectableSource(src);
        }
        try {
            return (T)this._bindAndClose(this._considerFilter(this.createParser(src), false));
        }
        catch (JsonProcessingException e2) {
            throw e2;
        }
        catch (IOException e3) {
            throw JsonMappingException.fromUnexpectedIOE(e3);
        }
    }

    public <T> T treeToValue(TreeNode n2, Class<T> valueType) throws JsonProcessingException {
        this._assertNotNull("n", n2);
        try {
            return this.readValue(this.treeAsTokens(n2), valueType);
        }
        catch (JsonProcessingException e2) {
            throw e2;
        }
        catch (IOException e3) {
            throw JsonMappingException.fromUnexpectedIOE(e3);
        }
    }

    @Override
    public void writeValue(JsonGenerator gen, Object value) throws IOException {
        throw new UnsupportedOperationException("Not implemented for ObjectReader");
    }

    protected Object _bind(JsonParser p2, Object valueToUpdate) throws IOException {
        Object result;
        DefaultDeserializationContext ctxt = this.createDeserializationContext(p2);
        JsonToken t2 = this._initForReading(ctxt, p2);
        if (t2 == JsonToken.VALUE_NULL) {
            result = valueToUpdate == null ? this._findRootDeserializer(ctxt).getNullValue(ctxt) : valueToUpdate;
        } else if (t2 == JsonToken.END_ARRAY || t2 == JsonToken.END_OBJECT) {
            result = valueToUpdate;
        } else {
            JsonDeserializer<Object> deser = this._findRootDeserializer(ctxt);
            result = this._unwrapRoot ? this._unwrapAndDeserialize(p2, ctxt, this._valueType, deser) : (valueToUpdate == null ? deser.deserialize(p2, ctxt) : deser.deserialize(p2, ctxt, valueToUpdate));
        }
        p2.clearCurrentToken();
        if (this._config.isEnabled(DeserializationFeature.FAIL_ON_TRAILING_TOKENS)) {
            this._verifyNoTrailingTokens(p2, ctxt, this._valueType);
        }
        return result;
    }

    protected Object _bindAndClose(JsonParser p0) throws IOException {
        try (JsonParser p2 = p0;){
            Object result;
            DefaultDeserializationContext ctxt = this.createDeserializationContext(p2);
            JsonToken t2 = this._initForReading(ctxt, p2);
            if (t2 == JsonToken.VALUE_NULL) {
                result = this._valueToUpdate == null ? this._findRootDeserializer(ctxt).getNullValue(ctxt) : this._valueToUpdate;
            } else if (t2 == JsonToken.END_ARRAY || t2 == JsonToken.END_OBJECT) {
                result = this._valueToUpdate;
            } else {
                JsonDeserializer<Object> deser = this._findRootDeserializer(ctxt);
                if (this._unwrapRoot) {
                    result = this._unwrapAndDeserialize(p2, ctxt, this._valueType, deser);
                } else if (this._valueToUpdate == null) {
                    result = deser.deserialize(p2, ctxt);
                } else {
                    deser.deserialize(p2, ctxt, this._valueToUpdate);
                    result = this._valueToUpdate;
                }
            }
            if (this._config.isEnabled(DeserializationFeature.FAIL_ON_TRAILING_TOKENS)) {
                this._verifyNoTrailingTokens(p2, ctxt, this._valueType);
            }
            Object object = result;
            return object;
        }
    }

    protected Object _unwrapAndDeserialize(JsonParser p2, DeserializationContext ctxt, JavaType rootType, JsonDeserializer<Object> deser) throws IOException {
        Object result;
        String actualName;
        PropertyName expRootName = this._config.findRootName(rootType);
        String expSimpleName = expRootName.getSimpleName();
        if (p2.getCurrentToken() != JsonToken.START_OBJECT) {
            ctxt.reportWrongTokenException(rootType, JsonToken.START_OBJECT, "Current token not START_OBJECT (needed to unwrap root name '%s'), but %s", new Object[]{expSimpleName, p2.getCurrentToken()});
        }
        if (p2.nextToken() != JsonToken.FIELD_NAME) {
            ctxt.reportWrongTokenException(rootType, JsonToken.FIELD_NAME, "Current token not FIELD_NAME (to contain expected root name '%s'), but %s", new Object[]{expSimpleName, p2.getCurrentToken()});
        }
        if (!expSimpleName.equals(actualName = p2.getCurrentName())) {
            ctxt.reportPropertyInputMismatch(rootType, actualName, "Root name '%s' does not match expected ('%s') for type %s", actualName, expSimpleName, rootType);
        }
        p2.nextToken();
        if (this._valueToUpdate == null) {
            result = deser.deserialize(p2, ctxt);
        } else {
            deser.deserialize(p2, ctxt, this._valueToUpdate);
            result = this._valueToUpdate;
        }
        if (p2.nextToken() != JsonToken.END_OBJECT) {
            ctxt.reportWrongTokenException(rootType, JsonToken.END_OBJECT, "Current token not END_OBJECT (to match wrapper object with root name '%s'), but %s", new Object[]{expSimpleName, p2.getCurrentToken()});
        }
        if (this._config.isEnabled(DeserializationFeature.FAIL_ON_TRAILING_TOKENS)) {
            this._verifyNoTrailingTokens(p2, ctxt, this._valueType);
        }
        return result;
    }

    protected JsonParser _considerFilter(JsonParser p2, boolean multiValue) {
        return this._filter == null || FilteringParserDelegate.class.isInstance(p2) ? p2 : new FilteringParserDelegate(p2, this._filter, false, multiValue);
    }

    protected final void _verifyNoTrailingTokens(JsonParser p2, DeserializationContext ctxt, JavaType bindType) throws IOException {
        JsonToken t2 = p2.nextToken();
        if (t2 != null) {
            Class<?> bt2 = ClassUtil.rawClass(bindType);
            if (bt2 == null && this._valueToUpdate != null) {
                bt2 = this._valueToUpdate.getClass();
            }
            ctxt.reportTrailingTokens(bt2, p2, t2);
        }
    }

    protected DefaultDeserializationContext createDeserializationContext(JsonParser p2) {
        return this._context.createInstance(this._config, p2, this._injectableValues);
    }

    protected void _reportUndetectableSource(Object src) throws JsonParseException {
        throw new JsonParseException(null, "Cannot use source of type " + src.getClass().getName() + " with format auto-detection: must be byte- not char-based");
    }

    protected JsonDeserializer<Object> _findRootDeserializer(DeserializationContext ctxt) throws JsonMappingException {
        JsonDeserializer<Object> deser;
        if (this._rootDeserializer != null) {
            return this._rootDeserializer;
        }
        JavaType t2 = this._valueType;
        if (t2 == null) {
            ctxt.reportBadDefinition((JavaType)null, "No value type configured for ObjectReader");
        }
        if ((deser = this._rootDeserializers.get(t2)) != null) {
            return deser;
        }
        deser = ctxt.findRootValueDeserializer(t2);
        if (deser == null) {
            ctxt.reportBadDefinition(t2, "Cannot find a deserializer for type " + t2);
        }
        this._rootDeserializers.put(t2, deser);
        return deser;
    }

    protected JsonDeserializer<Object> _prefetchRootDeserializer(JavaType valueType) {
        if (valueType == null || !this._config.isEnabled(DeserializationFeature.EAGER_DESERIALIZER_FETCH)) {
            return null;
        }
        JsonDeserializer<Object> deser = this._rootDeserializers.get(valueType);
        if (deser == null) {
            try {
                DefaultDeserializationContext ctxt = this.createDeserializationContext(null);
                deser = ctxt.findRootValueDeserializer(valueType);
                if (deser != null) {
                    this._rootDeserializers.put(valueType, deser);
                }
                return deser;
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
        }
        return deser;
    }

    protected final void _assertNotNull(String paramName, Object src) {
        if (src == null) {
            throw new IllegalArgumentException(String.format("argument \"%s\" is null", paramName));
        }
    }
}

