/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client;

import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.ConnectionPool;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.HttpDestination;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.api.Connection;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.Attachable;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.Callback;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.Pool;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.Promise;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.component.ContainerLifeCycle;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.component.Dumpable;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.Log;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.Logger;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.thread.Sweeper;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;

public abstract class AbstractConnectionPool
extends ContainerLifeCycle
implements ConnectionPool,
Sweeper.Sweepable {
    private static final Logger LOG = Log.getLogger(AbstractConnectionPool.class);
    private final HttpDestination destination;
    private final Callback requester;
    private final Pool<Connection> pool;
    private boolean maximizeConnections;

    protected AbstractConnectionPool(HttpDestination destination, Pool<Connection> pool, Callback requester) {
        this.destination = destination;
        this.requester = requester;
        this.pool = pool;
        this.addBean(pool);
    }

    @Override
    protected void doStop() throws Exception {
        this.pool.close();
    }

    public int getActiveConnectionCount() {
        return this.pool.getInUseCount();
    }

    public int getIdleConnectionCount() {
        return this.pool.getIdleCount();
    }

    public int getMaxConnectionCount() {
        return this.pool.getMaxEntries();
    }

    public int getConnectionCount() {
        return this.pool.size();
    }

    public int getPendingConnectionCount() {
        return this.pool.getReservedCount();
    }

    @Override
    public boolean isEmpty() {
        return this.pool.size() == 0;
    }

    public boolean isClosed() {
        return this.pool.isClosed();
    }

    public boolean isMaximizeConnections() {
        return this.maximizeConnections;
    }

    @Override
    public Connection acquire() {
        return this.acquire(true);
    }

    protected Connection acquire(boolean create) {
        Connection connection;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Acquiring create={} on {}", create, this);
        }
        if ((connection = this.activate()) == null && (create || this.isMaximizeConnections())) {
            this.tryCreate(this.destination.getQueuedRequestCount());
            connection = this.activate();
        }
        return connection;
    }

    protected void tryCreate(int maxPending) {
        this.tryCreateAsync(maxPending);
    }

    private CompletableFuture<Void> tryCreateAsync(int maxPending) {
        Pool.Entry entry;
        final int connectionCount = this.getConnectionCount();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Try creating connection {}/{} with {}/{} pending", connectionCount, this.getMaxConnectionCount(), this.getPendingConnectionCount(), maxPending);
        }
        if ((entry = this.pool.reserve(maxPending)) == null) {
            return CompletableFuture.completedFuture(null);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating connection {}/{}", connectionCount, this.getMaxConnectionCount());
        }
        final CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.destination.newConnection(new Promise<Connection>(){

            @Override
            public void succeeded(Connection connection) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Connection {}/{} creation succeeded {}", connectionCount, AbstractConnectionPool.this.getMaxConnectionCount(), connection);
                }
                if (!(connection instanceof Attachable)) {
                    this.failed(new IllegalArgumentException("Invalid connection object: " + connection));
                    return;
                }
                ((Attachable)((Object)connection)).setAttachment(entry);
                AbstractConnectionPool.this.onCreated(connection);
                entry.enable(connection, false);
                AbstractConnectionPool.this.idle(connection, false);
                future.complete(null);
                AbstractConnectionPool.this.proceed();
            }

            @Override
            public void failed(Throwable x2) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Connection {}/{} creation failed", connectionCount, AbstractConnectionPool.this.getMaxConnectionCount(), x2);
                }
                entry.remove();
                future.completeExceptionally(x2);
                AbstractConnectionPool.this.requester.failed(x2);
            }
        });
        return future;
    }

    protected void proceed() {
        this.requester.succeeded();
    }

    protected Connection activate() {
        Pool.Entry entry = this.pool.acquire();
        if (entry != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Activated {} {}", entry, this.pool);
            }
            Connection connection = (Connection)entry.getPooled();
            this.acquired(connection);
            return connection;
        }
        return null;
    }

    @Override
    public boolean isActive(Connection connection) {
        if (!(connection instanceof Attachable)) {
            throw new IllegalArgumentException("Invalid connection object: " + connection);
        }
        Attachable attachable = (Attachable)((Object)connection);
        Pool.Entry entry = (Pool.Entry)attachable.getAttachment();
        if (entry == null) {
            return false;
        }
        return !entry.isIdle();
    }

    @Override
    public boolean release(Connection connection) {
        if (!this.deactivate(connection)) {
            return false;
        }
        this.released(connection);
        return this.idle(connection, this.isClosed());
    }

    protected boolean deactivate(Connection connection) {
        if (!(connection instanceof Attachable)) {
            throw new IllegalArgumentException("Invalid connection object: " + connection);
        }
        Attachable attachable = (Attachable)((Object)connection);
        Pool.Entry entry = (Pool.Entry)attachable.getAttachment();
        if (entry == null) {
            return true;
        }
        boolean reusable = this.pool.release(entry);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Released ({}) {} {}", reusable, entry, this.pool);
        }
        if (reusable) {
            return true;
        }
        this.remove(connection);
        return false;
    }

    @Override
    public boolean remove(Connection connection) {
        return this.remove(connection, false);
    }

    protected boolean remove(Connection connection, boolean force) {
        if (!(connection instanceof Attachable)) {
            throw new IllegalArgumentException("Invalid connection object: " + connection);
        }
        Attachable attachable = (Attachable)((Object)connection);
        Pool.Entry entry = (Pool.Entry)attachable.getAttachment();
        if (entry == null) {
            return false;
        }
        attachable.setAttachment(null);
        boolean removed = this.pool.remove(entry);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Removed ({}) {} {}", removed, entry, this.pool);
        }
        if (removed || force) {
            this.released(connection);
            this.removed(connection);
        }
        return removed;
    }

    protected void onCreated(Connection connection) {
    }

    protected boolean idle(Connection connection, boolean close) {
        return !close;
    }

    protected void acquired(Connection connection) {
    }

    protected void released(Connection connection) {
    }

    protected void removed(Connection connection) {
    }

    @Override
    public void close() {
        this.pool.close();
    }

    @Override
    public void dump(Appendable out, String indent) throws IOException {
        Dumpable.dumpObjects(out, indent, this, new Object[0]);
    }

    @Override
    public boolean sweep() {
        this.pool.values().stream().filter(entry -> entry.getPooled() instanceof Sweeper.Sweepable).forEach(entry -> {
            Connection connection = (Connection)entry.getPooled();
            if (((Sweeper.Sweepable)((Object)connection)).sweep()) {
                boolean removed = this.remove(connection);
                LOG.warn("Connection swept: {}{}{} from active connections{}{}", connection, System.lineSeparator(), removed ? "Removed" : "Not removed", System.lineSeparator(), this.dump());
            }
        });
        return false;
    }

    @Override
    public String toString() {
        return String.format("%s@%x[c=%d/%d/%d,a=%d,i=%d]", this.getClass().getSimpleName(), this.hashCode(), this.getPendingConnectionCount(), this.getConnectionCount(), this.getMaxConnectionCount(), this.getActiveConnectionCount(), this.getIdleConnectionCount());
    }
}

