/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.eventmodel;

import com.gradle.scan.eventmodel.Nullable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;

public final class Preconditions {
    public static void checkNull(@Nullable Object reference) {
        if (reference != null) {
            throw new IllegalArgumentException(reference + " is not null!");
        }
    }

    public static <T> T checkNotNull(T reference) {
        if (reference == null) {
            throw new NullPointerException();
        }
        return reference;
    }

    public static <T> T checkNotNull(T reference, Supplier<Object> errorMessage) {
        if (reference == null) {
            throw new NullPointerException(errorMessage.get().toString());
        }
        return reference;
    }

    public static void checkState(boolean expression, Supplier<Object> errorMessage) {
        if (!expression) {
            throw new IllegalStateException(errorMessage.get().toString());
        }
    }

    public static void checkEquals(Object o1, Object o2) {
        if (!Objects.equals(o1, o2)) {
            throw new IllegalStateException(o1 + " != " + o2);
        }
    }

    public static void checkArgument(boolean expression, Supplier<Object> errorMessage) {
        if (!expression) {
            throw new IllegalArgumentException(errorMessage.get().toString());
        }
    }

    public static int checkNonNegative(int value, String name) {
        if (value < 0) {
            throw new IllegalArgumentException(name + " cannot be negative but was: " + value);
        }
        return value;
    }

    public static String checkNotEmpty(String value, String name) {
        if (value == null || value.isEmpty()) {
            throw new IllegalArgumentException("'" + name + "' cannot be empty");
        }
        return value;
    }

    public static <T extends Collection<?>> T checkNotEmpty(T values, Supplier<Object> errorMessage) {
        if (values == null || values.isEmpty()) {
            throw new IllegalArgumentException(errorMessage.get().toString());
        }
        return values;
    }

    public static <T> List<T> checkNonNullValues(@Nullable List<T> list) {
        if (list != null) {
            list.forEach(Preconditions::checkNotNull);
        }
        return list;
    }

    public static <K, V> Map<K, V> checkNonNullValues(@Nullable Map<K, V> map) {
        if (map != null) {
            map.forEach((k2, v2) -> {
                Preconditions.checkNotNull(k2);
                if (v2 instanceof Map) {
                    Preconditions.checkNonNullValues((Map)v2);
                } else {
                    Preconditions.checkNotNull(v2);
                }
            });
        }
        return map;
    }

    private Preconditions() {
    }
}

