/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.common;

import java.nio.charset.StandardCharsets;

public class CloseInfo {
    private int statusCode = 0;
    private byte[] reasonBytes;

    public CloseInfo() {
        this(1005, null);
    }

    public CloseInfo(int statusCode) {
        this(statusCode, null);
    }

    public CloseInfo(int statusCode, String reason) {
        this.statusCode = statusCode;
        if (reason != null) {
            byte[] utf8Bytes = reason.getBytes(StandardCharsets.UTF_8);
            if (utf8Bytes.length > 123) {
                this.reasonBytes = new byte[123];
                System.arraycopy(utf8Bytes, 0, this.reasonBytes, 0, 123);
            } else {
                this.reasonBytes = utf8Bytes;
            }
        }
    }

    public String getReason() {
        if (this.reasonBytes == null) {
            return null;
        }
        return new String(this.reasonBytes, StandardCharsets.UTF_8);
    }

    public String toString() {
        return String.format("CloseInfo[code=%d,reason=%s]", this.statusCode, this.getReason());
    }
}

