/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.auth0.jwt.impl;

import com.gradle.maven.extension.internal.dep.com.auth0.jwt.impl.JsonNodeClaim;
import com.gradle.maven.extension.internal.dep.com.auth0.jwt.interfaces.Claim;
import com.gradle.maven.extension.internal.dep.com.auth0.jwt.interfaces.Payload;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JsonNode;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.ObjectReader;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;

class PayloadImpl
implements Payload,
Serializable {
    private final String issuer;
    private final String subject;
    private final List<String> audience;
    private final Date expiresAt;
    private final Date notBefore;
    private final Date issuedAt;
    private final String jwtId;
    private final Map<String, JsonNode> tree;
    private final ObjectReader objectReader;

    PayloadImpl(String issuer, String subject, List<String> audience, Date expiresAt, Date notBefore, Date issuedAt, String jwtId, Map<String, JsonNode> tree, ObjectReader objectReader) {
        this.issuer = issuer;
        this.subject = subject;
        this.audience = audience;
        this.expiresAt = expiresAt;
        this.notBefore = notBefore;
        this.issuedAt = issuedAt;
        this.jwtId = jwtId;
        this.tree = tree != null ? Collections.unmodifiableMap(tree) : Collections.emptyMap();
        this.objectReader = objectReader;
    }

    @Override
    public String getIssuer() {
        return this.issuer;
    }

    @Override
    public String getSubject() {
        return this.subject;
    }

    @Override
    public List<String> getAudience() {
        return this.audience;
    }

    @Override
    public Date getExpiresAt() {
        return this.expiresAt;
    }

    @Override
    public Date getNotBefore() {
        return this.notBefore;
    }

    @Override
    public Date getIssuedAt() {
        return this.issuedAt;
    }

    @Override
    public String getId() {
        return this.jwtId;
    }

    @Override
    public Claim getClaim(String name) {
        return JsonNodeClaim.extractClaim(name, this.tree, this.objectReader);
    }
}

