/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util;

import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.ArrayTrie;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.Trie;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class StringUtil {
    private static final Trie<String> CHARSETS = new ArrayTrie<String>(256);
    @Deprecated
    public static final String __LINE_SEPARATOR = System.lineSeparator();
    public static final char[] lowercases;

    public static String asciiToLowerCase(String s2) {
        if (s2 == null) {
            return null;
        }
        char[] c2 = null;
        int i2 = s2.length();
        while (i2-- > 0) {
            char c22;
            char c1 = s2.charAt(i2);
            if (c1 > '\u007f' || c1 == (c22 = lowercases[c1])) continue;
            c2 = s2.toCharArray();
            c2[i2] = c22;
            break;
        }
        while (i2-- > 0) {
            if (c2[i2] > 127) continue;
            c2[i2] = lowercases[c2[i2]];
        }
        return c2 == null ? s2 : new String(c2);
    }

    public static String replace(String str, char find, char with) {
        if (str == null) {
            return null;
        }
        if (find == with) {
            return str;
        }
        int c2 = 0;
        int idx = str.indexOf(find, c2);
        if (idx == -1) {
            return str;
        }
        char[] chars = str.toCharArray();
        int len = chars.length;
        for (int i2 = idx; i2 < len; ++i2) {
            if (chars[i2] != find) continue;
            chars[i2] = with;
        }
        return String.valueOf(chars);
    }

    public static String replace(String s2, String sub, String with) {
        if (s2 == null) {
            return null;
        }
        int c2 = 0;
        int i2 = s2.indexOf(sub, c2);
        if (i2 == -1) {
            return s2;
        }
        StringBuilder buf = new StringBuilder(s2.length() + with.length());
        do {
            buf.append(s2, c2, i2);
            buf.append(with);
        } while ((i2 = s2.indexOf(sub, c2 = i2 + sub.length())) != -1);
        if (c2 < s2.length()) {
            buf.append(s2.substring(c2));
        }
        return buf.toString();
    }

    public static int indexOfControlChars(String str) {
        if (str == null) {
            return -1;
        }
        int len = str.length();
        for (int i2 = 0; i2 < len; ++i2) {
            if (!Character.isISOControl(str.codePointAt(i2))) continue;
            return i2;
        }
        return -1;
    }

    public static boolean isBlank(String str) {
        if (str == null) {
            return true;
        }
        int len = str.length();
        for (int i2 = 0; i2 < len; ++i2) {
            if (Character.isWhitespace(str.codePointAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(String str) {
        return str == null || str.isEmpty();
    }

    public static boolean isHex(String str, int offset, int length) {
        if (offset + length > str.length()) {
            return false;
        }
        for (int i2 = offset; i2 < offset + length; ++i2) {
            char c2 = str.charAt(i2);
            if (c2 >= 'a' && c2 <= 'f' || c2 >= 'A' && c2 <= 'F' || c2 >= '0' && c2 <= '9') continue;
            return false;
        }
        return true;
    }

    public static byte[] getBytes(String s2) {
        return s2.getBytes(StandardCharsets.ISO_8859_1);
    }

    public static List<String> csvSplit(List<String> list, String s2, int off, int len) {
        if (list == null) {
            list = new ArrayList<String>();
        }
        CsvSplitState state = CsvSplitState.PRE_DATA;
        StringBuilder out = new StringBuilder();
        int last = -1;
        block13: while (len > 0) {
            char ch2 = s2.charAt(off++);
            --len;
            switch (state) {
                case PRE_DATA: {
                    if (Character.isWhitespace(ch2)) continue block13;
                    if ('\"' == ch2) {
                        state = CsvSplitState.QUOTE;
                        continue block13;
                    }
                    if (',' == ch2) {
                        list.add("");
                        continue block13;
                    }
                    state = CsvSplitState.DATA;
                    out.append(ch2);
                    continue block13;
                }
                case DATA: {
                    if (Character.isWhitespace(ch2)) {
                        last = out.length();
                        out.append(ch2);
                        state = CsvSplitState.WHITE;
                        continue block13;
                    }
                    if (',' == ch2) {
                        list.add(out.toString());
                        out.setLength(0);
                        state = CsvSplitState.PRE_DATA;
                        continue block13;
                    }
                    out.append(ch2);
                    continue block13;
                }
                case WHITE: {
                    if (Character.isWhitespace(ch2)) {
                        out.append(ch2);
                        continue block13;
                    }
                    if (',' == ch2) {
                        out.setLength(last);
                        list.add(out.toString());
                        out.setLength(0);
                        state = CsvSplitState.PRE_DATA;
                        continue block13;
                    }
                    state = CsvSplitState.DATA;
                    out.append(ch2);
                    last = -1;
                    continue block13;
                }
                case QUOTE: {
                    if ('\\' == ch2) {
                        state = CsvSplitState.SLOSH;
                        continue block13;
                    }
                    if ('\"' == ch2) {
                        list.add(out.toString());
                        out.setLength(0);
                        state = CsvSplitState.POST_DATA;
                        continue block13;
                    }
                    out.append(ch2);
                    continue block13;
                }
                case SLOSH: {
                    out.append(ch2);
                    state = CsvSplitState.QUOTE;
                    continue block13;
                }
                case POST_DATA: {
                    if (',' != ch2) continue block13;
                    state = CsvSplitState.PRE_DATA;
                    continue block13;
                }
            }
        }
        switch (state) {
            case PRE_DATA: 
            case POST_DATA: {
                break;
            }
            case DATA: 
            case QUOTE: 
            case SLOSH: {
                list.add(out.toString());
                break;
            }
            case WHITE: {
                out.setLength(last);
                list.add(out.toString());
            }
        }
        return list;
    }

    public static String valueOf(Object object) {
        return object == null ? null : String.valueOf(object);
    }

    static {
        CHARSETS.put("utf-8", "utf-8");
        CHARSETS.put("utf8", "utf-8");
        CHARSETS.put("utf-16", "utf-16");
        CHARSETS.put("utf16", "utf-16");
        CHARSETS.put("iso-8859-1", "iso-8859-1");
        CHARSETS.put("iso_8859_1", "iso-8859-1");
        lowercases = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '\u007f'};
    }

    static enum CsvSplitState {
        PRE_DATA,
        QUOTE,
        SLOSH,
        DATA,
        WHITE,
        POST_DATA;

    }
}

