/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.compression;

import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.component.AbstractLifeCycle;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class CompressionPool<T>
extends AbstractLifeCycle {
    private final Queue<T> _pool;
    private final AtomicInteger _numObjects = new AtomicInteger(0);
    private final int _capacity;

    public CompressionPool(int capacity) {
        this._capacity = capacity;
        this._pool = this._capacity == 0 ? null : new ConcurrentLinkedQueue();
    }

    protected abstract void end(T var1);

    @Override
    public void doStop() {
        T t2 = this._pool.poll();
        while (t2 != null) {
            this.end(t2);
            t2 = this._pool.poll();
        }
        this._numObjects.set(0);
    }

    @Override
    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append(this.getClass().getSimpleName());
        str.append('@').append(Integer.toHexString(this.hashCode()));
        str.append('{').append(this.getState());
        str.append(",size=").append(this._pool == null ? -1 : this._pool.size());
        str.append(",capacity=").append(this._capacity <= 0 ? "UNLIMITED" : Integer.valueOf(this._capacity));
        str.append('}');
        return str.toString();
    }
}

