/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.thread;

import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.component.Destroyable;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.component.LifeCycle;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.Log;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.Logger;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class ShutdownThread
extends Thread {
    private static final Logger LOG = Log.getLogger(ShutdownThread.class);
    private static final ShutdownThread _thread = new ShutdownThread();
    private boolean _hooked;
    private final List<LifeCycle> _lifeCycles = new CopyOnWriteArrayList<LifeCycle>();

    private ShutdownThread() {
        super("JettyShutdownThread");
    }

    private synchronized void unhook() {
        try {
            this._hooked = false;
            Runtime.getRuntime().removeShutdownHook(this);
        }
        catch (Exception e2) {
            LOG.ignore(e2);
            LOG.debug("shutdown already commenced", new Object[0]);
        }
    }

    public static synchronized void deregister(LifeCycle lifeCycle) {
        ShutdownThread._thread._lifeCycles.remove(lifeCycle);
        if (ShutdownThread._thread._lifeCycles.size() == 0) {
            _thread.unhook();
        }
    }

    @Override
    public void run() {
        for (LifeCycle lifeCycle : ShutdownThread._thread._lifeCycles) {
            try {
                if (lifeCycle.isStarted()) {
                    lifeCycle.stop();
                    LOG.debug("Stopped {}", lifeCycle);
                }
                if (!(lifeCycle instanceof Destroyable)) continue;
                ((Destroyable)((Object)lifeCycle)).destroy();
                LOG.debug("Destroyed {}", lifeCycle);
            }
            catch (Exception ex) {
                LOG.debug(ex);
            }
        }
    }
}

