/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.api;

import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.api.WebSocketBehavior;

public class WebSocketPolicy {
    private int maxTextMessageSize = 65536;
    private int maxTextMessageBufferSize = 32768;
    private int maxBinaryMessageSize = 65536;
    private int maxBinaryMessageBufferSize = 32768;
    private long asyncWriteTimeout = 60000L;
    private long idleTimeout = 300000L;
    private int inputBufferSize = 4096;
    private final WebSocketBehavior behavior;

    public static WebSocketPolicy newClientPolicy() {
        return new WebSocketPolicy(WebSocketBehavior.CLIENT);
    }

    public WebSocketPolicy(WebSocketBehavior behavior) {
        this.behavior = behavior;
    }

    @Deprecated
    public long getAsyncWriteTimeout() {
        return this.asyncWriteTimeout;
    }

    public WebSocketBehavior getBehavior() {
        return this.behavior;
    }

    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    public int getInputBufferSize() {
        return this.inputBufferSize;
    }

    public int getMaxBinaryMessageSize() {
        return this.maxBinaryMessageSize;
    }

    public int getMaxTextMessageBufferSize() {
        return this.maxTextMessageBufferSize;
    }

    public int getMaxTextMessageSize() {
        return this.maxTextMessageSize;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append("@").append(Integer.toHexString(this.hashCode()));
        builder.append("[behavior=").append((Object)this.getBehavior());
        builder.append(",maxTextMessageSize=").append(this.getMaxTextMessageSize());
        builder.append(",maxTextMessageBufferSize=").append(this.getMaxTextMessageBufferSize());
        builder.append(",maxBinaryMessageSize=").append(this.getMaxBinaryMessageSize());
        builder.append(",maxBinaryMessageBufferSize=").append(this.getMaxTextMessageBufferSize());
        builder.append(",asyncWriteTimeout=").append(this.getAsyncWriteTimeout());
        builder.append(",idleTimeout=").append(this.getIdleTimeout());
        builder.append(",inputBufferSize=").append(this.getInputBufferSize());
        builder.append("]");
        return builder.toString();
    }
}

