/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.common;

import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.io.Connection;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.Callback;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.component.ContainerLifeCycle;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.Log;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.Logger;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.thread.ThreadClassLoaderScope;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.api.BatchMode;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.api.RemoteEndpoint;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.api.Session;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.api.WebSocketPolicy;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.api.extensions.IncomingFrames;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.api.extensions.OutgoingFrames;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.common.CloseInfo;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.common.LogicalConnection;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.common.RemoteEndpointFactory;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.common.WebSocketRemoteEndpoint;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.common.WebSocketSessionListener;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.common.events.EventDriver;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.common.io.DisconnectCallback;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.common.scopes.WebSocketContainerScope;
import java.net.URI;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;

public class WebSocketSession
extends ContainerLifeCycle
implements Connection.Listener,
Session,
IncomingFrames,
OutgoingFrames,
RemoteEndpointFactory {
    private static final Logger LOG = Log.getLogger(WebSocketSession.class);
    private static final RemoteEndpointFactory defaultRemoteEndpointFactory;
    private final WebSocketContainerScope containerScope;
    private final URI requestURI;
    private final LogicalConnection connection;
    private final EventDriver websocket;
    private final WebSocketPolicy policy;
    private final AtomicBoolean onCloseCalled;
    private final RemoteEndpointFactory remoteEndpointFactory;
    private ClassLoader classLoader;
    private RemoteEndpoint remote;
    private IncomingFrames incomingHandler;
    private OutgoingFrames outgoingHandler;
    private CompletableFuture<Session> openFuture;

    public void close(Throwable cause) {
        this.connection.close(cause);
    }

    @Override
    public void close() {
        this.close(new CloseInfo(1000), null);
    }

    private void close(CloseInfo closeInfo, Callback callback) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("close({})", closeInfo);
        }
        this.connection.close(closeInfo, callback);
    }

    public void disconnect() {
        this.connection.disconnect();
    }

    @Override
    protected void doStart() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("starting - {}", this);
        }
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("stopping - {}", this);
        }
        this.connection.close(new CloseInfo(1001, "Shutdown"), new DisconnectCallback(this.connection));
        super.doStop();
    }

    @Override
    public String dumpSelf() {
        return String.format("%s@%x[behavior=%s,batchMode=%s,idleTimeout=%d,requestURI=%s]", new Object[]{this.getClass().getSimpleName(), this.hashCode(), this.getPolicy().getBehavior(), this.getBatchMode(), this.getIdleTimeout(), this.getRequestURI()});
    }

    public long getIdleTimeout() {
        return this.connection.getMaxIdleTimeout();
    }

    public WebSocketPolicy getPolicy() {
        return this.policy;
    }

    public URI getRequestURI() {
        return this.requestURI;
    }

    public void callApplicationOnClose(CloseInfo closeInfo) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("callApplicationOnClose({})", closeInfo);
        }
        if (this.onCloseCalled.compareAndSet(false, true)) {
            try {
                this.websocket.onClose(closeInfo);
            }
            catch (Throwable t2) {
                LOG.warn("Exception while notifying onClose", t2);
            }
        }
    }

    @Override
    public void onClosed(Connection connection) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("[{}] {}.onSessionClosed()", new Object[]{this.policy.getBehavior(), this.getClass().getSimpleName()});
        }
        if (connection == this.connection) {
            this.connection.disconnect();
            try {
                this.notifySessionListeners(this.containerScope, listener -> listener.onSessionClosed(this));
            }
            catch (Throwable cause) {
                LOG.ignore(cause);
            }
        }
    }

    @Override
    public void onOpened(Connection connection) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("[{}] {}.onSessionOpened()", new Object[]{this.policy.getBehavior(), this.getClass().getSimpleName()});
        }
        this.open();
    }

    @Override
    public WebSocketRemoteEndpoint newRemoteEndpoint(LogicalConnection connection, OutgoingFrames outgoingFrames, BatchMode batchMode) {
        return new WebSocketRemoteEndpoint(connection, outgoingFrames, this.getBatchMode());
    }

    public void open() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("[{}] {}.open()", new Object[]{this.policy.getBehavior(), this.getClass().getSimpleName()});
        }
        if (this.remote != null) {
            return;
        }
        try (ThreadClassLoaderScope ignored = new ThreadClassLoaderScope(this.classLoader);){
            if (this.connection.opening()) {
                this.remote = this.remoteEndpointFactory.newRemoteEndpoint(this.connection, this, this.getBatchMode());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("[{}] {}.open() remote={}", new Object[]{this.policy.getBehavior(), this.getClass().getSimpleName(), this.remote});
                }
                this.websocket.openSession(this);
                if (this.connection.opened()) {
                    try {
                        this.notifySessionListeners(this.containerScope, listener -> listener.onSessionOpened(this));
                    }
                    catch (Throwable t2) {
                        LOG.ignore(t2);
                    }
                } else {
                    this.callApplicationOnClose(new CloseInfo(1006, "Failed to open local endpoint"));
                    this.disconnect();
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("[{}] open -> {}", new Object[]{this.getPolicy().getBehavior(), this.dump()});
                }
                if (this.openFuture != null) {
                    this.openFuture.complete(this);
                }
            }
        }
        catch (Throwable t3) {
            this.close(t3);
        }
    }

    public BatchMode getBatchMode() {
        return BatchMode.AUTO;
    }

    private void notifySessionListeners(WebSocketContainerScope scope, Consumer<WebSocketSessionListener> consumer) {
        for (WebSocketSessionListener listener : scope.getSessionListeners()) {
            try {
                consumer.accept(listener);
            }
            catch (Throwable x2) {
                LOG.info("Exception while invoking listener " + listener, x2);
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("WebSocketSession[");
        builder.append("websocket=").append(this.websocket);
        builder.append(",behavior=").append((Object)this.policy.getBehavior());
        builder.append(",connection=").append(this.connection);
        builder.append(",remote=").append(this.remote);
        builder.append(",incoming=").append(this.incomingHandler);
        builder.append(",outgoing=").append(this.outgoingHandler);
        builder.append("]");
        return builder.toString();
    }

    static {
        Iterator<RemoteEndpointFactory> iter = ServiceLoader.load(RemoteEndpointFactory.class).iterator();
        RemoteEndpointFactory remoteEndpointFactory = defaultRemoteEndpointFactory = iter.hasNext() ? iter.next() : null;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Discovered default RemoteEndpointFactory: {}", defaultRemoteEndpointFactory);
        }
    }
}

