/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.common.events;

import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.Log;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.Logger;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.common.events.EventDriverImpl;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.common.events.JettyAnnotatedImpl;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.common.events.JettyListenerImpl;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.common.scopes.WebSocketContainerScope;
import java.util.ArrayList;
import java.util.List;

public class EventDriverFactory {
    private static final Logger LOG = Log.getLogger(EventDriverFactory.class);
    private final WebSocketContainerScope containerScope;
    private final List<EventDriverImpl> implementations;

    public EventDriverFactory(WebSocketContainerScope containerScope) {
        this.containerScope = containerScope;
        this.implementations = new ArrayList<EventDriverImpl>();
        this.addImplementation(new JettyListenerImpl());
        this.addImplementation(new JettyAnnotatedImpl());
    }

    public void addImplementation(EventDriverImpl impl) {
        if (this.implementations.contains(impl)) {
            LOG.warn("Ignoring attempt to add duplicate EventDriverImpl: " + impl, new Object[0]);
            return;
        }
        this.implementations.add(impl);
    }

    public String toString() {
        StringBuilder msg = new StringBuilder();
        msg.append(this.getClass().getSimpleName());
        msg.append("[implementations=[");
        boolean delim = false;
        for (EventDriverImpl impl : this.implementations) {
            if (delim) {
                msg.append(',');
            }
            msg.append(impl.toString());
            delim = true;
        }
        msg.append("]");
        return msg.toString();
    }
}

