/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.common.extensions;

import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.component.ContainerLifeCycle;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.component.Dumpable;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.component.LifeCycle;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.compression.DeflaterPool;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.compression.InflaterPool;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.api.extensions.Extension;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.api.extensions.ExtensionFactory;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.common.scopes.WebSocketContainerScope;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;

public class WebSocketExtensionFactory
extends ExtensionFactory
implements Dumpable,
LifeCycle {
    private ContainerLifeCycle containerLifeCycle;
    private WebSocketContainerScope container;
    private ServiceLoader<Extension> extensionLoader = ServiceLoader.load(Extension.class);
    private Map<String, Class<? extends Extension>> availableExtensions;
    private final InflaterPool inflaterPool = new InflaterPool(-1, true);
    private final DeflaterPool deflaterPool = new DeflaterPool(-1, -1, true);

    public WebSocketExtensionFactory(WebSocketContainerScope container) {
        this.containerLifeCycle = new ContainerLifeCycle(){

            @Override
            public String toString() {
                return String.format("%s@%x{%s}", WebSocketExtensionFactory.class.getSimpleName(), this.hashCode(), WebSocketExtensionFactory.this.containerLifeCycle.getState());
            }
        };
        this.availableExtensions = new HashMap<String, Class<? extends Extension>>();
        for (Extension ext : this.extensionLoader) {
            if (ext == null) continue;
            this.availableExtensions.put(ext.getName(), ext.getClass());
        }
        this.container = container;
        this.containerLifeCycle.addBean(this.inflaterPool);
        this.containerLifeCycle.addBean(this.deflaterPool);
    }

    @Override
    public Iterator<Class<? extends Extension>> iterator() {
        return this.availableExtensions.values().iterator();
    }

    @Override
    public void start() throws Exception {
        this.containerLifeCycle.start();
    }

    @Override
    public void stop() throws Exception {
        this.containerLifeCycle.stop();
    }

    @Override
    public boolean isRunning() {
        return this.containerLifeCycle.isRunning();
    }

    @Override
    public boolean isStarted() {
        return this.containerLifeCycle.isStarted();
    }

    @Override
    public boolean isStarting() {
        return this.containerLifeCycle.isStarting();
    }

    @Override
    public boolean isStopping() {
        return this.containerLifeCycle.isStopping();
    }

    @Override
    public boolean isStopped() {
        return this.containerLifeCycle.isStopped();
    }

    @Override
    public boolean isFailed() {
        return this.containerLifeCycle.isFailed();
    }

    @Override
    public String dumpSelf() {
        return this.containerLifeCycle.dumpSelf();
    }

    @Override
    public void dump(Appendable out, String indent) throws IOException {
        this.containerLifeCycle.dump(out, indent);
    }

    public String toString() {
        return this.containerLifeCycle.toString();
    }
}

