/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.io;

import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.KryoException;
import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.io.Output;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;

public class ByteBufferOutput
extends Output {
    protected ByteBuffer niobuffer;
    protected boolean varIntsEnabled = true;
    ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;
    protected static final ByteOrder nativeOrder = ByteOrder.nativeOrder();

    public ByteBufferOutput() {
    }

    public ByteBufferOutput(int bufferSize, int maxBufferSize) {
        if (maxBufferSize < -1) {
            throw new IllegalArgumentException("maxBufferSize cannot be < -1: " + maxBufferSize);
        }
        this.capacity = bufferSize;
        this.maxCapacity = maxBufferSize == -1 ? 0x7FFFFFF7 : maxBufferSize;
        this.niobuffer = ByteBuffer.allocateDirect(bufferSize);
        this.niobuffer.order(this.byteOrder);
    }

    @Override
    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public void setBuffer(ByteBuffer buffer, int maxBufferSize) {
        if (buffer == null) {
            throw new IllegalArgumentException("buffer cannot be null.");
        }
        if (maxBufferSize < -1) {
            throw new IllegalArgumentException("maxBufferSize cannot be < -1: " + maxBufferSize);
        }
        this.niobuffer = buffer;
        this.maxCapacity = maxBufferSize == -1 ? 0x7FFFFFF7 : maxBufferSize;
        this.byteOrder = buffer.order();
        this.capacity = buffer.capacity();
        this.position = buffer.position();
        this.total = 0L;
        this.outputStream = null;
    }

    public ByteBuffer getByteBuffer() {
        this.niobuffer.position(this.position);
        return this.niobuffer;
    }

    @Override
    public byte[] toBytes() {
        byte[] newBuffer = new byte[this.position];
        this.niobuffer.position(0);
        this.niobuffer.get(newBuffer, 0, this.position);
        return newBuffer;
    }

    @Override
    protected boolean require(int required) throws KryoException {
        if (this.capacity - this.position >= required) {
            return false;
        }
        if (required > this.maxCapacity) {
            this.niobuffer.order(this.byteOrder);
            throw new KryoException("Buffer overflow. Max capacity: " + this.maxCapacity + ", required: " + required);
        }
        this.flush();
        while (this.capacity - this.position < required) {
            if (this.capacity == this.maxCapacity) {
                this.niobuffer.order(this.byteOrder);
                throw new KryoException("Buffer overflow. Available: " + (this.capacity - this.position) + ", required: " + required);
            }
            if (this.capacity == 0) {
                this.capacity = 1;
            }
            this.capacity = Math.min(this.capacity * 2, this.maxCapacity);
            if (this.capacity < 0) {
                this.capacity = this.maxCapacity;
            }
            ByteBuffer newBuffer = this.niobuffer != null && !this.niobuffer.isDirect() ? ByteBuffer.allocate(this.capacity) : ByteBuffer.allocateDirect(this.capacity);
            this.niobuffer.position(0);
            this.niobuffer.limit(this.position);
            newBuffer.put(this.niobuffer);
            newBuffer.order(this.niobuffer.order());
            ByteOrder currentByteOrder = this.byteOrder;
            this.setBuffer(newBuffer, this.maxCapacity);
            this.byteOrder = currentByteOrder;
        }
        return true;
    }

    @Override
    public void flush() throws KryoException {
        if (this.outputStream == null) {
            return;
        }
        try {
            byte[] tmp = new byte[this.position];
            this.niobuffer.position(0);
            this.niobuffer.get(tmp);
            this.niobuffer.position(0);
            this.outputStream.write(tmp, 0, this.position);
        }
        catch (IOException ex) {
            throw new KryoException(ex);
        }
        this.total += (long)this.position;
        this.position = 0;
    }

    @Override
    public void close() throws KryoException {
        this.flush();
        if (this.outputStream != null) {
            try {
                this.outputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void write(int value) throws KryoException {
        if (this.position == this.capacity) {
            this.require(1);
        }
        this.niobuffer.put((byte)value);
        ++this.position;
    }

    @Override
    public void write(byte[] bytes) throws KryoException {
        if (bytes == null) {
            throw new IllegalArgumentException("bytes cannot be null.");
        }
        this.writeBytes(bytes, 0, bytes.length);
    }

    @Override
    public void write(byte[] bytes, int offset, int length) throws KryoException {
        this.writeBytes(bytes, offset, length);
    }

    @Override
    public void writeByte(byte value) throws KryoException {
        if (this.position == this.capacity) {
            this.require(1);
        }
        this.niobuffer.put(value);
        ++this.position;
    }

    @Override
    public void writeByte(int value) throws KryoException {
        if (this.position == this.capacity) {
            this.require(1);
        }
        this.niobuffer.put((byte)value);
        ++this.position;
    }

    @Override
    public void writeBytes(byte[] bytes) throws KryoException {
        if (bytes == null) {
            throw new IllegalArgumentException("bytes cannot be null.");
        }
        this.writeBytes(bytes, 0, bytes.length);
    }

    @Override
    public void writeBytes(byte[] bytes, int offset, int count) throws KryoException {
        if (bytes == null) {
            throw new IllegalArgumentException("bytes cannot be null.");
        }
        int copyCount = Math.min(this.capacity - this.position, count);
        while (true) {
            this.niobuffer.put(bytes, offset, copyCount);
            this.position += copyCount;
            if ((count -= copyCount) == 0) {
                return;
            }
            offset += copyCount;
            copyCount = Math.min(this.capacity, count);
            this.require(copyCount);
        }
    }

    @Override
    public void writeInt(int value) throws KryoException {
        this.require(4);
        this.niobuffer.putInt(value);
        this.position += 4;
    }

    @Override
    public int writeInt(int value, boolean optimizePositive) throws KryoException {
        if (!this.varIntsEnabled) {
            this.writeInt(value);
            return 4;
        }
        return this.writeVarInt(value, optimizePositive);
    }

    @Override
    public int writeVarInt(int val, boolean optimizePositive) throws KryoException {
        this.niobuffer.position(this.position);
        int value = val;
        if (!optimizePositive) {
            value = value << 1 ^ value >> 31;
        }
        int varInt = 0;
        varInt = value & 0x7F;
        if ((value >>>= 7) == 0) {
            this.writeByte(varInt);
            return 1;
        }
        varInt |= 0x80;
        varInt |= (value & 0x7F) << 8;
        if ((value >>>= 7) == 0) {
            this.niobuffer.order(ByteOrder.LITTLE_ENDIAN);
            this.writeInt(varInt);
            this.niobuffer.order(this.byteOrder);
            this.position -= 2;
            this.niobuffer.position(this.position);
            return 2;
        }
        varInt |= 0x8000;
        varInt |= (value & 0x7F) << 16;
        if ((value >>>= 7) == 0) {
            this.niobuffer.order(ByteOrder.LITTLE_ENDIAN);
            this.writeInt(varInt);
            this.niobuffer.order(this.byteOrder);
            --this.position;
            this.niobuffer.position(this.position);
            return 3;
        }
        varInt |= 0x800000;
        varInt |= (value & 0x7F) << 24;
        if ((value >>>= 7) == 0) {
            this.niobuffer.order(ByteOrder.LITTLE_ENDIAN);
            this.writeInt(varInt);
            this.niobuffer.order(this.byteOrder);
            this.position -= 0;
            return 4;
        }
        long varLong = (long)(varInt |= Integer.MIN_VALUE) & 0xFFFFFFFFL | (long)value << 32;
        this.niobuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.writeLong(varLong);
        this.niobuffer.order(this.byteOrder);
        this.position -= 3;
        this.niobuffer.position(this.position);
        return 5;
    }

    @Override
    public void writeString(String value) throws KryoException {
        this.niobuffer.position(this.position);
        if (value == null) {
            this.writeByte(128);
            return;
        }
        int charCount = value.length();
        if (charCount == 0) {
            this.writeByte(129);
            return;
        }
        boolean ascii = false;
        if (charCount > 1 && charCount < 64) {
            ascii = true;
            for (int i2 = 0; i2 < charCount; ++i2) {
                char c2 = value.charAt(i2);
                if (c2 <= '\u007f') continue;
                ascii = false;
                break;
            }
        }
        if (ascii) {
            if (this.capacity - this.position < charCount) {
                this.writeAscii_slow(value, charCount);
            } else {
                byte[] tmp = value.getBytes();
                this.niobuffer.put(tmp, 0, tmp.length);
                this.position += charCount;
            }
            this.niobuffer.put(this.position - 1, (byte)(this.niobuffer.get(this.position - 1) | 0x80));
        } else {
            int charIndex;
            this.writeUtf8Length(charCount + 1);
            if (this.capacity - this.position >= charCount) {
                char c3;
                int position = this.position;
                for (charIndex = 0; charIndex < charCount && (c3 = value.charAt(charIndex)) <= '\u007f'; ++charIndex) {
                    this.niobuffer.put(position++, (byte)c3);
                }
                this.position = position;
                this.niobuffer.position(position);
            }
            if (charIndex < charCount) {
                this.writeString_slow(value, charCount, charIndex);
            }
            this.niobuffer.position(this.position);
        }
    }

    @Override
    public void writeString(CharSequence value) throws KryoException {
        int charIndex;
        if (value == null) {
            this.writeByte(128);
            return;
        }
        int charCount = value.length();
        if (charCount == 0) {
            this.writeByte(129);
            return;
        }
        this.writeUtf8Length(charCount + 1);
        if (this.capacity - this.position >= charCount) {
            char c2;
            int position = this.position;
            for (charIndex = 0; charIndex < charCount && (c2 = value.charAt(charIndex)) <= '\u007f'; ++charIndex) {
                this.niobuffer.put(position++, (byte)c2);
            }
            this.position = position;
            this.niobuffer.position(position);
        }
        if (charIndex < charCount) {
            this.writeString_slow(value, charCount, charIndex);
        }
        this.niobuffer.position(this.position);
    }

    @Override
    public void writeAscii(String value) throws KryoException {
        if (value == null) {
            this.writeByte(128);
            return;
        }
        int charCount = value.length();
        if (charCount == 0) {
            this.writeByte(129);
            return;
        }
        if (this.capacity - this.position < charCount) {
            this.writeAscii_slow(value, charCount);
        } else {
            byte[] tmp = value.getBytes();
            this.niobuffer.put(tmp, 0, tmp.length);
            this.position += charCount;
        }
        this.niobuffer.put(this.position - 1, (byte)(this.niobuffer.get(this.position - 1) | 0x80));
    }

    private void writeUtf8Length(int value) {
        if (value >>> 6 == 0) {
            this.require(1);
            this.niobuffer.put((byte)(value | 0x80));
            ++this.position;
        } else if (value >>> 13 == 0) {
            this.require(2);
            this.niobuffer.put((byte)(value | 0x40 | 0x80));
            this.niobuffer.put((byte)(value >>> 6));
            this.position += 2;
        } else if (value >>> 20 == 0) {
            this.require(3);
            this.niobuffer.put((byte)(value | 0x40 | 0x80));
            this.niobuffer.put((byte)(value >>> 6 | 0x80));
            this.niobuffer.put((byte)(value >>> 13));
            this.position += 3;
        } else if (value >>> 27 == 0) {
            this.require(4);
            this.niobuffer.put((byte)(value | 0x40 | 0x80));
            this.niobuffer.put((byte)(value >>> 6 | 0x80));
            this.niobuffer.put((byte)(value >>> 13 | 0x80));
            this.niobuffer.put((byte)(value >>> 20));
            this.position += 4;
        } else {
            this.require(5);
            this.niobuffer.put((byte)(value | 0x40 | 0x80));
            this.niobuffer.put((byte)(value >>> 6 | 0x80));
            this.niobuffer.put((byte)(value >>> 13 | 0x80));
            this.niobuffer.put((byte)(value >>> 20 | 0x80));
            this.niobuffer.put((byte)(value >>> 27));
            this.position += 5;
        }
    }

    private void writeString_slow(CharSequence value, int charCount, int charIndex) {
        while (charIndex < charCount) {
            char c2;
            if (this.position == this.capacity) {
                this.require(Math.min(this.capacity, charCount - charIndex));
            }
            if ((c2 = value.charAt(charIndex)) <= '\u007f') {
                this.niobuffer.put(this.position++, (byte)c2);
            } else if (c2 > '\u07ff') {
                this.niobuffer.put(this.position++, (byte)(0xE0 | c2 >> 12 & 0xF));
                this.require(2);
                this.niobuffer.put(this.position++, (byte)(0x80 | c2 >> 6 & 0x3F));
                this.niobuffer.put(this.position++, (byte)(0x80 | c2 & 0x3F));
            } else {
                this.niobuffer.put(this.position++, (byte)(0xC0 | c2 >> 6 & 0x1F));
                this.require(1);
                this.niobuffer.put(this.position++, (byte)(0x80 | c2 & 0x3F));
            }
            ++charIndex;
        }
    }

    private void writeAscii_slow(String value, int charCount) throws KryoException {
        ByteBuffer buffer = this.niobuffer;
        int charIndex = 0;
        int charsToWrite = Math.min(charCount, this.capacity - this.position);
        while (charIndex < charCount) {
            byte[] tmp = new byte[charCount];
            value.getBytes(charIndex, charIndex + charsToWrite, tmp, 0);
            buffer.put(tmp, 0, charsToWrite);
            this.position += charsToWrite;
            if (!this.require(charsToWrite = Math.min(charCount - (charIndex += charsToWrite), this.capacity))) continue;
            buffer = this.niobuffer;
        }
    }

    @Override
    public void writeFloat(float value) throws KryoException {
        this.require(4);
        this.niobuffer.putFloat(value);
        this.position += 4;
    }

    @Override
    public void writeShort(int value) throws KryoException {
        this.require(2);
        this.niobuffer.putShort((short)value);
        this.position += 2;
    }

    @Override
    public void writeLong(long value) throws KryoException {
        this.require(8);
        this.niobuffer.putLong(value);
        this.position += 8;
    }

    @Override
    public int writeLong(long value, boolean optimizePositive) throws KryoException {
        if (!this.varIntsEnabled) {
            this.writeLong(value);
            return 8;
        }
        return this.writeVarLong(value, optimizePositive);
    }

    @Override
    public int writeVarLong(long value, boolean optimizePositive) throws KryoException {
        if (!optimizePositive) {
            value = value << 1 ^ value >> 63;
        }
        int varInt = 0;
        varInt = (int)(value & 0x7FL);
        if ((value >>>= 7) == 0L) {
            this.writeByte(varInt);
            return 1;
        }
        varInt |= 0x80;
        varInt = (int)((long)varInt | (value & 0x7FL) << 8);
        if ((value >>>= 7) == 0L) {
            this.niobuffer.order(ByteOrder.LITTLE_ENDIAN);
            this.writeInt(varInt);
            this.niobuffer.order(this.byteOrder);
            this.position -= 2;
            this.niobuffer.position(this.position);
            return 2;
        }
        varInt |= 0x8000;
        varInt = (int)((long)varInt | (value & 0x7FL) << 16);
        if ((value >>>= 7) == 0L) {
            this.niobuffer.order(ByteOrder.LITTLE_ENDIAN);
            this.writeInt(varInt);
            this.niobuffer.order(this.byteOrder);
            --this.position;
            this.niobuffer.position(this.position);
            return 3;
        }
        varInt |= 0x800000;
        varInt = (int)((long)varInt | (value & 0x7FL) << 24);
        if ((value >>>= 7) == 0L) {
            this.niobuffer.order(ByteOrder.LITTLE_ENDIAN);
            this.writeInt(varInt);
            this.niobuffer.order(this.byteOrder);
            this.position -= 0;
            return 4;
        }
        long varLong = (long)(varInt |= Integer.MIN_VALUE) & 0xFFFFFFFFL;
        varLong |= (value & 0x7FL) << 32;
        if ((value >>>= 7) == 0L) {
            this.niobuffer.order(ByteOrder.LITTLE_ENDIAN);
            this.writeLong(varLong);
            this.niobuffer.order(this.byteOrder);
            this.position -= 3;
            this.niobuffer.position(this.position);
            return 5;
        }
        varLong |= 0x8000000000L;
        varLong |= (value & 0x7FL) << 40;
        if ((value >>>= 7) == 0L) {
            this.niobuffer.order(ByteOrder.LITTLE_ENDIAN);
            this.writeLong(varLong);
            this.niobuffer.order(this.byteOrder);
            this.position -= 2;
            this.niobuffer.position(this.position);
            return 6;
        }
        varLong |= 0x800000000000L;
        varLong |= (value & 0x7FL) << 48;
        if ((value >>>= 7) == 0L) {
            this.niobuffer.order(ByteOrder.LITTLE_ENDIAN);
            this.writeLong(varLong);
            this.niobuffer.order(this.byteOrder);
            --this.position;
            this.niobuffer.position(this.position);
            return 7;
        }
        varLong |= 0x80000000000000L;
        varLong |= (value & 0x7FL) << 56;
        if ((value >>>= 7) == 0L) {
            this.niobuffer.order(ByteOrder.LITTLE_ENDIAN);
            this.writeLong(varLong);
            this.niobuffer.order(this.byteOrder);
            return 8;
        }
        this.niobuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.writeLong(varLong |= Long.MIN_VALUE);
        this.niobuffer.order(this.byteOrder);
        this.write((byte)value);
        return 9;
    }

    @Override
    public void writeBoolean(boolean value) throws KryoException {
        this.require(1);
        this.niobuffer.put((byte)(value ? 1 : 0));
        ++this.position;
    }

    @Override
    public void writeChar(char value) throws KryoException {
        this.require(2);
        this.niobuffer.putChar(value);
        this.position += 2;
    }

    @Override
    public void writeDouble(double value) throws KryoException {
        this.require(8);
        this.niobuffer.putDouble(value);
        this.position += 8;
    }

    @Override
    public void writeFloats(float[] object) throws KryoException {
        if (this.capacity - this.position >= object.length * 4 && this.isNativeOrder()) {
            FloatBuffer buf = this.niobuffer.asFloatBuffer();
            buf.put(object);
            this.position += object.length * 4;
        } else {
            super.writeFloats(object);
        }
    }

    @Override
    public void writeShorts(short[] object) throws KryoException {
        if (this.capacity - this.position >= object.length * 2 && this.isNativeOrder()) {
            ShortBuffer buf = this.niobuffer.asShortBuffer();
            buf.put(object);
            this.position += object.length * 2;
        } else {
            super.writeShorts(object);
        }
    }

    @Override
    public void writeChars(char[] object) throws KryoException {
        if (this.capacity - this.position >= object.length * 2 && this.isNativeOrder()) {
            CharBuffer buf = this.niobuffer.asCharBuffer();
            buf.put(object);
            this.position += object.length * 2;
        } else {
            super.writeChars(object);
        }
    }

    @Override
    public void writeDoubles(double[] object) throws KryoException {
        if (this.capacity - this.position >= object.length * 8 && this.isNativeOrder()) {
            DoubleBuffer buf = this.niobuffer.asDoubleBuffer();
            buf.put(object);
            this.position += object.length * 8;
        } else {
            super.writeDoubles(object);
        }
    }

    private boolean isNativeOrder() {
        return this.byteOrder == nativeOrder;
    }
}

