/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.eclipse.jetty.http;

import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.TypeUtil;

public class HttpURI {
    private String _scheme;
    private String _user;
    private String _host;
    private int _port;
    private String _path;
    private String _param;
    private String _query;
    private String _fragment;
    String _uri;
    String _decodedPath;

    public HttpURI() {
    }

    public HttpURI(String uri) {
        this._port = -1;
        this.parse(State.START, uri, 0, uri.length());
    }

    private void parse(State state, String uri, int offset, int end) {
        boolean encoded = false;
        int mark = offset;
        int pathMark = 0;
        block67: for (int i2 = offset; i2 < end; ++i2) {
            char c2 = uri.charAt(i2);
            switch (state) {
                case START: {
                    switch (c2) {
                        case '/': {
                            mark = i2;
                            state = State.HOST_OR_PATH;
                            continue block67;
                        }
                        case ';': {
                            mark = i2 + 1;
                            state = State.PARAM;
                            continue block67;
                        }
                        case '?': {
                            this._path = "";
                            mark = i2 + 1;
                            state = State.QUERY;
                            continue block67;
                        }
                        case '#': {
                            mark = i2 + 1;
                            state = State.FRAGMENT;
                            continue block67;
                        }
                        case '*': {
                            this._path = "*";
                            state = State.ASTERISK;
                            continue block67;
                        }
                    }
                    mark = i2;
                    if (this._scheme == null) {
                        state = State.SCHEME_OR_PATH;
                        continue block67;
                    }
                    pathMark = i2;
                    state = State.PATH;
                    continue block67;
                }
                case SCHEME_OR_PATH: {
                    switch (c2) {
                        case ':': {
                            this._scheme = uri.substring(mark, i2);
                            state = State.START;
                            break;
                        }
                        case '/': {
                            state = State.PATH;
                            break;
                        }
                        case ';': {
                            mark = i2 + 1;
                            state = State.PARAM;
                            break;
                        }
                        case '?': {
                            this._path = uri.substring(mark, i2);
                            mark = i2 + 1;
                            state = State.QUERY;
                            break;
                        }
                        case '%': {
                            encoded = true;
                            state = State.PATH;
                            break;
                        }
                        case '#': {
                            this._path = uri.substring(mark, i2);
                            state = State.FRAGMENT;
                        }
                    }
                    continue block67;
                }
                case HOST_OR_PATH: {
                    switch (c2) {
                        case '/': {
                            this._host = "";
                            mark = i2 + 1;
                            state = State.HOST;
                            continue block67;
                        }
                        case '#': 
                        case ';': 
                        case '?': 
                        case '@': {
                            --i2;
                            pathMark = mark;
                            state = State.PATH;
                            continue block67;
                        }
                    }
                    pathMark = mark;
                    state = State.PATH;
                    continue block67;
                }
                case HOST: {
                    switch (c2) {
                        case '/': {
                            this._host = uri.substring(mark, i2);
                            pathMark = mark = i2;
                            state = State.PATH;
                            break;
                        }
                        case ':': {
                            if (i2 > mark) {
                                this._host = uri.substring(mark, i2);
                            }
                            mark = i2 + 1;
                            state = State.PORT;
                            break;
                        }
                        case '@': {
                            if (this._user != null) {
                                throw new IllegalArgumentException("Bad authority");
                            }
                            this._user = uri.substring(mark, i2);
                            mark = i2 + 1;
                            break;
                        }
                        case '[': {
                            state = State.IPV6;
                        }
                    }
                    continue block67;
                }
                case IPV6: {
                    switch (c2) {
                        case '/': {
                            throw new IllegalArgumentException("No closing ']' for ipv6 in " + uri);
                        }
                        case ']': {
                            c2 = uri.charAt(++i2);
                            this._host = uri.substring(mark, i2);
                            if (c2 == ':') {
                                mark = i2 + 1;
                                state = State.PORT;
                                break;
                            }
                            pathMark = mark = i2;
                            state = State.PATH;
                        }
                    }
                    continue block67;
                }
                case PORT: {
                    if (c2 == '@') {
                        if (this._user != null) {
                            throw new IllegalArgumentException("Bad authority");
                        }
                        this._user = this._host + ":" + uri.substring(mark, i2);
                        mark = i2 + 1;
                        state = State.HOST;
                        continue block67;
                    }
                    if (c2 != '/') continue block67;
                    this._port = TypeUtil.parseInt(uri, mark, i2 - mark, 10);
                    pathMark = mark = i2;
                    state = State.PATH;
                    continue block67;
                }
                case PATH: {
                    switch (c2) {
                        case ';': {
                            mark = i2 + 1;
                            state = State.PARAM;
                            break;
                        }
                        case '?': {
                            this._path = uri.substring(pathMark, i2);
                            mark = i2 + 1;
                            state = State.QUERY;
                            break;
                        }
                        case '#': {
                            this._path = uri.substring(pathMark, i2);
                            mark = i2 + 1;
                            state = State.FRAGMENT;
                            break;
                        }
                        case '%': {
                            encoded = true;
                        }
                    }
                    continue block67;
                }
                case PARAM: {
                    switch (c2) {
                        case '?': {
                            this._path = uri.substring(pathMark, i2);
                            this._param = uri.substring(mark, i2);
                            mark = i2 + 1;
                            state = State.QUERY;
                            break;
                        }
                        case '#': {
                            this._path = uri.substring(pathMark, i2);
                            this._param = uri.substring(mark, i2);
                            mark = i2 + 1;
                            state = State.FRAGMENT;
                            break;
                        }
                        case '/': {
                            encoded = true;
                            state = State.PATH;
                            break;
                        }
                        case ';': {
                            mark = i2 + 1;
                        }
                    }
                    continue block67;
                }
                case QUERY: {
                    if (c2 != '#') continue block67;
                    this._query = uri.substring(mark, i2);
                    mark = i2 + 1;
                    state = State.FRAGMENT;
                    continue block67;
                }
                case ASTERISK: {
                    throw new IllegalArgumentException("Bad character '*'");
                }
                case FRAGMENT: {
                    this._fragment = uri.substring(mark, end);
                    i2 = end;
                }
            }
        }
        switch (state) {
            case START: {
                break;
            }
            case SCHEME_OR_PATH: {
                this._path = uri.substring(mark, end);
                break;
            }
            case HOST_OR_PATH: {
                this._path = uri.substring(mark, end);
                break;
            }
            case HOST: {
                if (end <= mark) break;
                this._host = uri.substring(mark, end);
                break;
            }
            case IPV6: {
                throw new IllegalArgumentException("No closing ']' for ipv6 in " + uri);
            }
            case PORT: {
                this._port = TypeUtil.parseInt(uri, mark, end - mark, 10);
                break;
            }
            case ASTERISK: {
                break;
            }
            case FRAGMENT: {
                this._fragment = uri.substring(mark, end);
                break;
            }
            case PARAM: {
                this._path = uri.substring(pathMark, end);
                this._param = uri.substring(mark, end);
                break;
            }
            case PATH: {
                this._path = uri.substring(pathMark, end);
                break;
            }
            case QUERY: {
                this._query = uri.substring(mark, end);
            }
        }
        if (!encoded) {
            this._decodedPath = this._param == null ? this._path : this._path.substring(0, this._path.length() - this._param.length() - 1);
        }
    }

    public String toString() {
        if (this._uri == null) {
            StringBuilder out = new StringBuilder();
            if (this._scheme != null) {
                out.append(this._scheme).append(':');
            }
            if (this._host != null) {
                out.append("//");
                if (this._user != null) {
                    out.append(this._user).append('@');
                }
                out.append(this._host);
            }
            if (this._port > 0) {
                out.append(':').append(this._port);
            }
            if (this._path != null) {
                out.append(this._path);
            }
            if (this._query != null) {
                out.append('?').append(this._query);
            }
            if (this._fragment != null) {
                out.append('#').append(this._fragment);
            }
            this._uri = out.length() > 0 ? out.toString() : "";
        }
        return this._uri;
    }

    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof HttpURI)) {
            return false;
        }
        return this.toString().equals(o2.toString());
    }

    private static enum State {
        START,
        HOST_OR_PATH,
        SCHEME_OR_PATH,
        HOST,
        IPV6,
        PORT,
        PATH,
        PARAM,
        QUERY,
        FRAGMENT,
        ASTERISK;

    }
}

