/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.impl;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonParser;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonToken;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.DeserializationContext;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.IOException;
import java.lang.reflect.Constructor;

public final class InnerClassProperty
extends SettableBeanProperty.Delegating {
    protected final transient Constructor<?> _creator;

    public InnerClassProperty(SettableBeanProperty delegate, Constructor<?> ctor) {
        super(delegate);
        this._creator = ctor;
    }

    @Override
    protected SettableBeanProperty withDelegate(SettableBeanProperty d2) {
        if (d2 == this.delegate) {
            return this;
        }
        return new InnerClassProperty(d2, this._creator);
    }

    @Override
    public void deserializeAndSet(JsonParser p2, DeserializationContext ctxt, Object bean) throws IOException {
        Object value;
        JsonToken t2 = p2.currentToken();
        if (t2 == JsonToken.VALUE_NULL) {
            value = this._valueDeserializer.getNullValue(ctxt);
        } else if (this._valueTypeDeserializer != null) {
            value = this._valueDeserializer.deserializeWithType(p2, ctxt, this._valueTypeDeserializer);
        } else {
            try {
                value = this._creator.newInstance(bean);
            }
            catch (Exception e2) {
                ClassUtil.unwrapAndThrowAsIAE(e2, String.format("Failed to instantiate class %s, problem: %s", this._creator.getDeclaringClass().getName(), e2.getMessage()));
                value = null;
            }
            this._valueDeserializer.deserialize(p2, ctxt, value);
        }
        this.set(bean, value);
    }

    @Override
    public Object deserializeSetAndReturn(JsonParser p2, DeserializationContext ctxt, Object instance) throws IOException {
        return this.setAndReturn(instance, this.deserialize(p2, ctxt));
    }
}

