/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.apache.commons.io.filefilter;

import com.gradle.maven.extension.internal.dep.org.apache.commons.io.filefilter.AbstractFileFilter;
import com.gradle.maven.extension.internal.dep.org.apache.commons.io.filefilter.IOFileFilter;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class AndFileFilter
extends AbstractFileFilter
implements Serializable {
    private final List<IOFileFilter> fileFilters;

    public AndFileFilter() {
        this.fileFilters = new ArrayList<IOFileFilter>();
    }

    public AndFileFilter(List<IOFileFilter> fileFilters) {
        this.fileFilters = fileFilters == null ? new ArrayList<IOFileFilter>() : new ArrayList<IOFileFilter>(fileFilters);
    }

    @Override
    public boolean accept(File file) {
        if (this.fileFilters.isEmpty()) {
            return false;
        }
        for (IOFileFilter fileFilter : this.fileFilters) {
            if (fileFilter.accept(file)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean accept(File file, String name) {
        if (this.fileFilters.isEmpty()) {
            return false;
        }
        for (IOFileFilter fileFilter : this.fileFilters) {
            if (fileFilter.accept(file, name)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(super.toString());
        buffer.append("(");
        if (this.fileFilters != null) {
            for (int i2 = 0; i2 < this.fileFilters.size(); ++i2) {
                IOFileFilter filter;
                if (i2 > 0) {
                    buffer.append(",");
                }
                buffer.append((filter = this.fileFilters.get(i2)) == null ? "null" : filter.toString());
            }
        }
        buffer.append(")");
        return buffer.toString();
    }
}

