/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log;

import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.Loader;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.Uptime;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.Logger;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.StdErrLog;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class Log {
    public static String __logClass;
    public static boolean __ignored;
    protected static final Properties __props;
    private static final ConcurrentMap<String, Logger> __loggers;
    private static boolean __initialized;
    private static Logger LOG;

    private static void loadProperties(String resourceName, Properties props) {
        URL testProps = Loader.getResource(resourceName);
        if (testProps != null) {
            try (InputStream in = testProps.openStream();){
                Properties p2 = new Properties();
                p2.load(in);
                for (Object key : p2.keySet()) {
                    Object value = p2.get(key);
                    if (value == null) continue;
                    props.put(key, value);
                }
            }
            catch (IOException e2) {
                System.err.println("[WARN] Error loading logging config: " + testProps);
                e2.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialized() {
        Class<Log> clazz = Log.class;
        synchronized (Log.class) {
            if (__initialized) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            __initialized = true;
            boolean announce = Boolean.parseBoolean(__props.getProperty("com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.announce", "true"));
            try {
                Class logClass = Loader.loadClass(Log.class, __logClass);
                if (LOG == null || !LOG.getClass().equals(logClass)) {
                    LOG = (Logger)logClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    if (announce) {
                        LOG.debug("Logging to {} via {}", LOG, logClass.getName());
                    }
                }
            }
            catch (Throwable e2) {
                Log.initStandardLogging(e2);
            }
            if (announce && LOG != null) {
                LOG.info(String.format("Logging initialized @%dms to %s", Uptime.getUptime(), LOG.getClass().getName()), new Object[0]);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static void initStandardLogging(Throwable e2) {
        if (__ignored) {
            e2.printStackTrace();
        }
        if (LOG == null) {
            LOG = new StdErrLog();
        }
    }

    public static Logger getRootLogger() {
        Log.initialized();
        return LOG;
    }

    static boolean isIgnored() {
        return __ignored;
    }

    public static Logger getLogger(Class<?> clazz) {
        return Log.getLogger(clazz.getName());
    }

    public static Logger getLogger(String name) {
        Log.initialized();
        if (name == null) {
            return LOG;
        }
        Logger logger = (Logger)__loggers.get(name);
        if (logger == null) {
            logger = LOG.getLogger(name);
        }
        return logger;
    }

    static ConcurrentMap<String, Logger> getMutableLoggers() {
        return __loggers;
    }

    public static Map<String, Logger> getLoggers() {
        return Collections.unmodifiableMap(__loggers);
    }

    static {
        __props = new Properties();
        __loggers = new ConcurrentHashMap<String, Logger>();
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                Log.loadProperties("jetty-logging.properties", __props);
                String osName = System.getProperty("os.name");
                if (osName != null && osName.length() > 0) {
                    osName = osName.toLowerCase(Locale.ENGLISH).replace(' ', '-');
                    Log.loadProperties("jetty-logging-" + osName + ".properties", __props);
                }
                Enumeration<?> systemKeyEnum = System.getProperties().propertyNames();
                while (systemKeyEnum.hasMoreElements()) {
                    String key = (String)systemKeyEnum.nextElement();
                    String val = System.getProperty(key);
                    if (val == null) continue;
                    __props.setProperty(key, val);
                }
                __logClass = __props.getProperty("com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.class", "com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.Slf4jLog");
                __ignored = Boolean.parseBoolean(__props.getProperty("com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.IGNORED", "false"));
                return null;
            }
        });
    }
}

