/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.junit.platform.commons.util;

import com.gradle.maven.extension.internal.dep.org.junit.platform.commons.PreconditionViolationException;
import com.gradle.maven.extension.internal.dep.org.junit.platform.commons.util.StringUtils;
import java.util.function.Supplier;

public final class Preconditions {
    public static <T> T notNull(T object, String message) throws PreconditionViolationException {
        Preconditions.condition(object != null, message);
        return object;
    }

    public static String notBlank(String str, String message) throws PreconditionViolationException {
        Preconditions.condition(StringUtils.isNotBlank(str), message);
        return str;
    }

    public static void condition(boolean predicate, String message) throws PreconditionViolationException {
        if (!predicate) {
            throw new PreconditionViolationException(message);
        }
    }

    public static void condition(boolean predicate, Supplier<String> messageSupplier) throws PreconditionViolationException {
        if (!predicate) {
            throw new PreconditionViolationException(messageSupplier.get());
        }
    }
}

