/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.junit.platform.commons.util;

import com.gradle.maven.extension.internal.dep.org.junit.platform.commons.util.UnrecoverableExceptions;
import java.util.Arrays;
import java.util.regex.Pattern;

public final class StringUtils {
    private static final Pattern ISO_CONTROL_PATTERN = StringUtils.compileIsoControlPattern();
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("\\s");

    static Pattern compileIsoControlPattern() {
        try {
            return Pattern.compile("\\p{Cntrl}", 256);
        }
        catch (IllegalArgumentException e2) {
            return Pattern.compile("\\p{Cntrl}");
        }
    }

    public static boolean isBlank(String str) {
        return str == null || str.trim().isEmpty();
    }

    public static boolean isNotBlank(String str) {
        return !StringUtils.isBlank(str);
    }

    public static String nullSafeToString(Object obj) {
        if (obj == null) {
            return "null";
        }
        try {
            if (obj.getClass().isArray()) {
                if (obj.getClass().getComponentType().isPrimitive()) {
                    if (obj instanceof boolean[]) {
                        return Arrays.toString((boolean[])obj);
                    }
                    if (obj instanceof char[]) {
                        return Arrays.toString((char[])obj);
                    }
                    if (obj instanceof short[]) {
                        return Arrays.toString((short[])obj);
                    }
                    if (obj instanceof byte[]) {
                        return Arrays.toString((byte[])obj);
                    }
                    if (obj instanceof int[]) {
                        return Arrays.toString((int[])obj);
                    }
                    if (obj instanceof long[]) {
                        return Arrays.toString((long[])obj);
                    }
                    if (obj instanceof float[]) {
                        return Arrays.toString((float[])obj);
                    }
                    if (obj instanceof double[]) {
                        return Arrays.toString((double[])obj);
                    }
                }
                return Arrays.deepToString((Object[])obj);
            }
            String result = obj.toString();
            return result != null ? result : "null";
        }
        catch (Throwable throwable) {
            UnrecoverableExceptions.rethrowIfUnrecoverable(throwable);
            return StringUtils.defaultToString(obj);
        }
    }

    public static String defaultToString(Object obj) {
        if (obj == null) {
            return "null";
        }
        return obj.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(obj));
    }
}

