/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.cfg;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.annotation.JsonFormat;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.annotation.JsonInclude;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.annotation.JsonSetter;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JavaType;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.MapperFeature;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.PropertyName;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.cfg.BaseSettings;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.cfg.ConfigFeature;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.cfg.ConfigOverride;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.cfg.ConfigOverrides;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.cfg.ContextAttributes;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.introspect.SimpleMixInResolver;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.jsontype.SubtypeResolver;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.util.RootNameLookup;
import java.io.Serializable;

public abstract class MapperConfigBase<CFG extends ConfigFeature, T extends MapperConfigBase<CFG, T>>
extends MapperConfig<T>
implements Serializable {
    protected static final ConfigOverride EMPTY_OVERRIDE = ConfigOverride.empty();
    private static final int DEFAULT_MAPPER_FEATURES = MapperConfigBase.collectFeatureDefaults(MapperFeature.class);
    private static final int AUTO_DETECT_MASK = MapperFeature.AUTO_DETECT_FIELDS.getMask() | MapperFeature.AUTO_DETECT_GETTERS.getMask() | MapperFeature.AUTO_DETECT_IS_GETTERS.getMask() | MapperFeature.AUTO_DETECT_SETTERS.getMask() | MapperFeature.AUTO_DETECT_CREATORS.getMask();
    protected final SimpleMixInResolver _mixIns;
    protected final SubtypeResolver _subtypeResolver;
    protected final PropertyName _rootName;
    protected final Class<?> _view;
    protected final ContextAttributes _attributes;
    protected final RootNameLookup _rootNames;
    protected final ConfigOverrides _configOverrides;

    protected MapperConfigBase(BaseSettings base, SubtypeResolver str, SimpleMixInResolver mixins, RootNameLookup rootNames, ConfigOverrides configOverrides) {
        super(base, DEFAULT_MAPPER_FEATURES);
        this._mixIns = mixins;
        this._subtypeResolver = str;
        this._rootNames = rootNames;
        this._rootName = null;
        this._view = null;
        this._attributes = ContextAttributes.getEmpty();
        this._configOverrides = configOverrides;
    }

    protected MapperConfigBase(MapperConfigBase<CFG, T> src, BaseSettings base) {
        super(src, base);
        this._mixIns = src._mixIns;
        this._subtypeResolver = src._subtypeResolver;
        this._rootNames = src._rootNames;
        this._rootName = src._rootName;
        this._view = src._view;
        this._attributes = src._attributes;
        this._configOverrides = src._configOverrides;
    }

    protected MapperConfigBase(MapperConfigBase<CFG, T> src, int mapperFeatures) {
        super(src, mapperFeatures);
        this._mixIns = src._mixIns;
        this._subtypeResolver = src._subtypeResolver;
        this._rootNames = src._rootNames;
        this._rootName = src._rootName;
        this._view = src._view;
        this._attributes = src._attributes;
        this._configOverrides = src._configOverrides;
    }

    protected abstract T _withBase(BaseSettings var1);

    protected abstract T _withMapperFeatures(int var1);

    public final T with(MapperFeature ... features) {
        int newMapperFlags = this._mapperFeatures;
        for (MapperFeature f2 : features) {
            newMapperFlags |= f2.getMask();
        }
        if (newMapperFlags == this._mapperFeatures) {
            return (T)this;
        }
        return this._withMapperFeatures(newMapperFlags);
    }

    public final T without(MapperFeature ... features) {
        int newMapperFlags = this._mapperFeatures;
        for (MapperFeature f2 : features) {
            newMapperFlags &= ~f2.getMask();
        }
        if (newMapperFlags == this._mapperFeatures) {
            return (T)this;
        }
        return this._withMapperFeatures(newMapperFlags);
    }

    public final T with(PropertyNamingStrategy pns) {
        return this._withBase(this._base.withPropertyNamingStrategy(pns));
    }

    public final SubtypeResolver getSubtypeResolver() {
        return this._subtypeResolver;
    }

    public final PropertyName getFullRootName() {
        return this._rootName;
    }

    public final Class<?> getActiveView() {
        return this._view;
    }

    public final ContextAttributes getAttributes() {
        return this._attributes;
    }

    @Override
    public final ConfigOverride getConfigOverride(Class<?> type) {
        ConfigOverride override = this._configOverrides.findOverride(type);
        return override == null ? EMPTY_OVERRIDE : override;
    }

    public final JsonInclude.Value getDefaultPropertyInclusion() {
        return this._configOverrides.getDefaultInclusion();
    }

    @Override
    public final JsonInclude.Value getDefaultPropertyInclusion(Class<?> baseType) {
        JsonInclude.Value v2 = this.getConfigOverride(baseType).getInclude();
        JsonInclude.Value def = this.getDefaultPropertyInclusion();
        if (def == null) {
            return v2;
        }
        return def.withOverrides(v2);
    }

    @Override
    public final JsonInclude.Value getDefaultInclusion(Class<?> baseType, Class<?> propertyType) {
        JsonInclude.Value v2 = this.getConfigOverride(propertyType).getIncludeAsProperty();
        JsonInclude.Value def = this.getDefaultPropertyInclusion(baseType);
        if (def == null) {
            return v2;
        }
        return def.withOverrides(v2);
    }

    @Override
    public final JsonFormat.Value getDefaultPropertyFormat(Class<?> type) {
        return this._configOverrides.findFormatDefaults(type);
    }

    public final JsonIgnoreProperties.Value getDefaultPropertyIgnorals(Class<?> type) {
        JsonIgnoreProperties.Value v2;
        ConfigOverride overrides = this._configOverrides.findOverride(type);
        if (overrides != null && (v2 = overrides.getIgnorals()) != null) {
            return v2;
        }
        return null;
    }

    public final JsonIgnoreProperties.Value getDefaultPropertyIgnorals(Class<?> baseType, AnnotatedClass actualClass) {
        AnnotationIntrospector intr = this.getAnnotationIntrospector();
        JsonIgnoreProperties.Value base = intr == null ? null : intr.findPropertyIgnorals(actualClass);
        JsonIgnoreProperties.Value overrides = this.getDefaultPropertyIgnorals(baseType);
        return JsonIgnoreProperties.Value.merge(base, overrides);
    }

    public final VisibilityChecker<?> getDefaultVisibilityChecker() {
        VisibilityChecker<?> vchecker = this._configOverrides.getDefaultVisibility();
        if ((this._mapperFeatures & AUTO_DETECT_MASK) != AUTO_DETECT_MASK) {
            if (!this.isEnabled(MapperFeature.AUTO_DETECT_FIELDS)) {
                vchecker = vchecker.withFieldVisibility(JsonAutoDetect.Visibility.NONE);
            }
            if (!this.isEnabled(MapperFeature.AUTO_DETECT_GETTERS)) {
                vchecker = vchecker.withGetterVisibility(JsonAutoDetect.Visibility.NONE);
            }
            if (!this.isEnabled(MapperFeature.AUTO_DETECT_IS_GETTERS)) {
                vchecker = vchecker.withIsGetterVisibility(JsonAutoDetect.Visibility.NONE);
            }
            if (!this.isEnabled(MapperFeature.AUTO_DETECT_SETTERS)) {
                vchecker = vchecker.withSetterVisibility(JsonAutoDetect.Visibility.NONE);
            }
            if (!this.isEnabled(MapperFeature.AUTO_DETECT_CREATORS)) {
                vchecker = vchecker.withCreatorVisibility(JsonAutoDetect.Visibility.NONE);
            }
        }
        return vchecker;
    }

    @Override
    public final VisibilityChecker<?> getDefaultVisibilityChecker(Class<?> baseType, AnnotatedClass actualClass) {
        ConfigOverride overrides;
        VisibilityChecker<?> vc = this.getDefaultVisibilityChecker();
        AnnotationIntrospector intr = this.getAnnotationIntrospector();
        if (intr != null) {
            vc = intr.findAutoDetectVisibility(actualClass, vc);
        }
        if ((overrides = this._configOverrides.findOverride(baseType)) != null) {
            vc = vc.withOverrides(overrides.getVisibility());
        }
        return vc;
    }

    @Override
    public final JsonSetter.Value getDefaultSetterInfo() {
        return this._configOverrides.getDefaultSetterInfo();
    }

    @Override
    public Boolean getDefaultMergeable() {
        return this._configOverrides.getDefaultMergeable();
    }

    public Boolean getDefaultMergeable(Class<?> baseType) {
        Boolean b2;
        ConfigOverride cfg = this._configOverrides.findOverride(baseType);
        if (cfg != null && (b2 = cfg.getMergeable()) != null) {
            return b2;
        }
        return this._configOverrides.getDefaultMergeable();
    }

    public PropertyName findRootName(JavaType rootType) {
        if (this._rootName != null) {
            return this._rootName;
        }
        return this._rootNames.findRootName(rootType, this);
    }

    public PropertyName findRootName(Class<?> rawRootType) {
        if (this._rootName != null) {
            return this._rootName;
        }
        return this._rootNames.findRootName(rawRootType, this);
    }

    @Override
    public final Class<?> findMixInClassFor(Class<?> cls) {
        return this._mixIns.findMixInClassFor(cls);
    }
}

