/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.google.common.io;

import com.gradle.maven.extension.internal.dep.com.google.common.base.Optional;
import com.gradle.maven.extension.internal.dep.com.google.common.base.Preconditions;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableList;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableSet;
import com.gradle.maven.extension.internal.dep.com.google.common.graph.SuccessorsFunction;
import com.gradle.maven.extension.internal.dep.com.google.common.io.ByteSink;
import com.gradle.maven.extension.internal.dep.com.google.common.io.ByteSource;
import com.gradle.maven.extension.internal.dep.com.google.common.io.ByteStreams;
import com.gradle.maven.extension.internal.dep.com.google.common.io.Closer;
import com.gradle.maven.extension.internal.dep.com.google.common.io.FileWriteMode;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;

public final class Files {
    private static final SuccessorsFunction<File> FILE_TREE = new SuccessorsFunction<File>(){

        @Override
        public Iterable<File> successors(File file) {
            File[] files;
            if (file.isDirectory() && (files = file.listFiles()) != null) {
                return Collections.unmodifiableList(Arrays.asList(files));
            }
            return ImmutableList.of();
        }
    };

    public static ByteSource asByteSource(File file) {
        return new FileByteSource(file);
    }

    public static ByteSink asByteSink(File file, FileWriteMode ... modes) {
        return new FileByteSink(file, modes);
    }

    private static final class FileByteSink
    extends ByteSink {
        private final File file;
        private final ImmutableSet<FileWriteMode> modes;

        private FileByteSink(File file, FileWriteMode ... modes) {
            this.file = Preconditions.checkNotNull(file);
            this.modes = ImmutableSet.copyOf(modes);
        }

        @Override
        public FileOutputStream openStream() throws IOException {
            return new FileOutputStream(this.file, this.modes.contains((Object)FileWriteMode.APPEND));
        }

        public String toString() {
            String string = String.valueOf(this.file);
            String string2 = String.valueOf(this.modes);
            return new StringBuilder(20 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Files.asByteSink(").append(string).append(", ").append(string2).append(")").toString();
        }
    }

    private static final class FileByteSource
    extends ByteSource {
        private final File file;

        private FileByteSource(File file) {
            this.file = Preconditions.checkNotNull(file);
        }

        @Override
        public FileInputStream openStream() throws IOException {
            return new FileInputStream(this.file);
        }

        @Override
        public Optional<Long> sizeIfKnown() {
            if (this.file.isFile()) {
                return Optional.of(this.file.length());
            }
            return Optional.absent();
        }

        @Override
        public byte[] read() throws IOException {
            try (Closer closer = Closer.create();){
                FileInputStream in = closer.register(this.openStream());
                byte[] byArray = ByteStreams.toByteArray(in, in.getChannel().size());
                return byArray;
            }
        }

        public String toString() {
            String string = String.valueOf(this.file);
            return new StringBuilder(20 + String.valueOf(string).length()).append("Files.asByteSource(").append(string).append(")").toString();
        }
    }
}

