/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.junit.platform.commons.util;

import com.gradle.maven.extension.internal.dep.org.junit.platform.commons.util.Preconditions;
import com.gradle.maven.extension.internal.dep.org.junit.platform.commons.util.StringUtils;
import java.util.ArrayList;
import java.util.List;

public class ToStringBuilder {
    private final String typeName;
    private final List<String> values = new ArrayList<String>();

    public ToStringBuilder(Object obj) {
        this(Preconditions.notNull(obj, "Object must not be null").getClass().getSimpleName());
    }

    public ToStringBuilder(String typeName) {
        this.typeName = Preconditions.notNull(typeName, "Type name must not be null");
    }

    public ToStringBuilder append(String name, Object value) {
        Preconditions.notBlank(name, "Name must not be null or blank");
        this.values.add(name + " = " + this.toString(value));
        return this;
    }

    private String toString(Object obj) {
        return obj instanceof CharSequence ? "'" + obj + "'" : StringUtils.nullSafeToString(obj);
    }

    public String toString() {
        return this.typeName + " [" + String.join((CharSequence)", ", this.values) + "]";
    }
}

