/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.junit.platform.engine;

import com.gradle.maven.extension.internal.dep.org.junit.platform.commons.JUnitException;
import com.gradle.maven.extension.internal.dep.org.junit.platform.commons.util.Preconditions;
import com.gradle.maven.extension.internal.dep.org.junit.platform.commons.util.ToStringBuilder;
import com.gradle.maven.extension.internal.dep.org.junit.platform.engine.UniqueIdFormat;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class UniqueId
implements Serializable,
Cloneable {
    private final UniqueIdFormat uniqueIdFormat;
    private final List<Segment> segments;
    private transient int hashCode;
    private transient SoftReference<String> toString;

    public static UniqueId parse(String uniqueId) throws JUnitException {
        Preconditions.notBlank(uniqueId, "Unique ID string must not be null or blank");
        return UniqueIdFormat.getDefault().parse(uniqueId);
    }

    UniqueId(UniqueIdFormat uniqueIdFormat, List<Segment> segments) {
        this.uniqueIdFormat = uniqueIdFormat;
        this.segments = segments;
    }

    public final List<Segment> getSegments() {
        return Collections.unmodifiableList(this.segments);
    }

    public Segment getLastSegment() {
        return this.segments.get(this.segments.size() - 1);
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        UniqueId that = (UniqueId)o2;
        return this.segments.equals(that.segments);
    }

    public int hashCode() {
        int value = this.hashCode;
        if (value == 0) {
            value = this.segments.hashCode();
            if (value == 0) {
                value = 1;
            }
            this.hashCode = value;
        }
        return value;
    }

    public String toString() {
        String value;
        SoftReference<String> s2 = this.toString;
        String string = value = s2 == null ? null : s2.get();
        if (value == null) {
            value = this.uniqueIdFormat.format(this);
            this.toString = new SoftReference<String>(value);
        }
        return value;
    }

    public static class Segment
    implements Serializable {
        private final String type;
        private final String value;

        Segment(String type, String value) {
            Preconditions.notBlank(type, "type must not be null or blank");
            Preconditions.notBlank(value, "value must not be null or blank");
            this.type = type;
            this.value = value;
        }

        public String getType() {
            return this.type;
        }

        public String getValue() {
            return this.value;
        }

        public int hashCode() {
            return Objects.hash(this.type, this.value);
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (o2 == null || this.getClass() != o2.getClass()) {
                return false;
            }
            Segment that = (Segment)o2;
            return Objects.equals(this.type, that.type) && Objects.equals(this.value, that.value);
        }

        public String toString() {
            return new ToStringBuilder(this).append("type", this.type).append("value", this.value).toString();
        }
    }
}

