/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.core;

import com.gradle.maven.extension.internal.dep.org.apache.commons.logging.Log;
import com.gradle.maven.extension.internal.dep.org.apache.commons.logging.LogFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;

public final class SpringProperties {
    private static final Log logger;
    private static final Properties localProperties;

    private SpringProperties() {
    }

    public static String getProperty(String key) {
        String value;
        block3: {
            value = localProperties.getProperty(key);
            if (value == null) {
                try {
                    value = System.getProperty(key);
                }
                catch (Throwable ex) {
                    if (!logger.isDebugEnabled()) break block3;
                    logger.debug("Could not retrieve system property '" + key + "': " + ex);
                }
            }
        }
        return value;
    }

    static {
        block14: {
            logger = LogFactory.getLog(SpringProperties.class);
            localProperties = new Properties();
            try {
                URL url;
                ClassLoader cl2 = SpringProperties.class.getClassLoader();
                URL uRL = url = cl2 != null ? cl2.getResource("spring.properties") : ClassLoader.getSystemResource("spring.properties");
                if (url == null) break block14;
                logger.debug("Found 'spring.properties' file in local classpath");
                try (InputStream is = url.openStream();){
                    localProperties.load(is);
                }
            }
            catch (IOException ex) {
                if (!logger.isInfoEnabled()) break block14;
                logger.info("Could not load 'spring.properties' file from local classpath: " + ex);
            }
        }
    }
}

