/*
 * Decompiled with CFR 0.152.
 */
package com.gradle;

import com.gradle.QuarkusExtensionUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.project.MavenProject;

final class QuarkusExtensionConfiguration {
    private static final String DEVELOCITY_QUARKUS_KEY_CACHE_ENABLED = "DEVELOCITY_QUARKUS_CACHE_ENABLED";
    private static final String DEVELOCITY_QUARKUS_KEY_CONFIG_FILE = "DEVELOCITY_QUARKUS_CONFIG_FILE";
    private static final String DEVELOCITY_QUARKUS_KEY_BUILD_PROFILE = "DEVELOCITY_QUARKUS_BUILD_PROFILE";
    private static final String DEVELOCITY_QUARKUS_DEFAULT_BUILD_PROFILE = "prod";
    private static final String DEVELOCITY_QUARKUS_KEY_DUMP_CONFIG_PREFIX = "DEVELOCITY_QUARKUS_DUMP_CONFIG_PREFIX";
    private static final String DEVELOCITY_QUARKUS_DEFAULT_DUMP_CONFIG_PREFIX = "quarkus";
    private static final String DEVELOCITY_QUARKUS_KEY_DUMP_CONFIG_SUFFIX = "DEVELOCITY_QUARKUS_DUMP_CONFIG_SUFFIX";
    private static final String DEVELOCITY_QUARKUS_DEFAULT_DUMP_CONFIG_SUFFIX = "config-dump";
    private static final String DEVELOCITY_QUARKUS_KEY_DUMP_CONFIG_SUBFOLDER = "DEVELOCITY_QUARKUS_DUMP_CONFIG_SUBFOLDER";
    private static final String DEVELOCITY_QUARKUS_KEY_EXTRA_OUTPUT_DIRS = "DEVELOCITY_QUARKUS_EXTRA_OUTPUT_DIRS";
    private static final String DEVELOCITY_QUARKUS_KEY_EXTRA_OUTPUT_FILES = "DEVELOCITY_QUARKUS_EXTRA_OUTPUT_FILES";
    private static final String DEVELOCITY_QUARKUS_KEY_NATIVE_BUILD_IN_CONTAINER_REQUIRED = "DEVELOCITY_QUARKUS_NATIVE_BUILD_IN_CONTAINER_REQUIRED";
    private final Properties configuration = new Properties();

    QuarkusExtensionConfiguration(MavenProject project) {
        this.initWithDefault();
        this.overrideFromEnvironment();
        this.overrideFromMaven(project);
        this.overrideFromConfigurationFile(project);
    }

    private void initWithDefault() {
        this.configuration.setProperty(DEVELOCITY_QUARKUS_KEY_CACHE_ENABLED, Boolean.TRUE.toString());
        this.configuration.setProperty(DEVELOCITY_QUARKUS_KEY_BUILD_PROFILE, DEVELOCITY_QUARKUS_DEFAULT_BUILD_PROFILE);
        this.configuration.setProperty(DEVELOCITY_QUARKUS_KEY_DUMP_CONFIG_PREFIX, DEVELOCITY_QUARKUS_DEFAULT_DUMP_CONFIG_PREFIX);
        this.configuration.setProperty(DEVELOCITY_QUARKUS_KEY_DUMP_CONFIG_SUFFIX, DEVELOCITY_QUARKUS_DEFAULT_DUMP_CONFIG_SUFFIX);
        this.configuration.setProperty(DEVELOCITY_QUARKUS_KEY_DUMP_CONFIG_SUBFOLDER, "");
        this.configuration.setProperty(DEVELOCITY_QUARKUS_KEY_CONFIG_FILE, "");
        this.configuration.setProperty(DEVELOCITY_QUARKUS_KEY_EXTRA_OUTPUT_DIRS, "");
        this.configuration.setProperty(DEVELOCITY_QUARKUS_KEY_EXTRA_OUTPUT_FILES, "");
        this.configuration.setProperty(DEVELOCITY_QUARKUS_KEY_NATIVE_BUILD_IN_CONTAINER_REQUIRED, Boolean.TRUE.toString());
    }

    private void overrideFromEnvironment() {
        this.configuration.stringPropertyNames().forEach(key -> {
            String envValue = System.getenv(key);
            if (envValue != null && !envValue.isEmpty()) {
                this.configuration.setProperty((String)key, envValue);
            }
        });
    }

    private void overrideFromMaven(MavenProject project) {
        this.configuration.stringPropertyNames().forEach(key -> {
            String mavenProperty = project.getProperties().getProperty(key.toLowerCase().replace("_", "."), "");
            if (mavenProperty != null && !mavenProperty.isEmpty()) {
                this.configuration.setProperty((String)key, mavenProperty);
            }
        });
    }

    private void overrideFromConfigurationFile(MavenProject project) {
        String configurationFile = this.configuration.getProperty(DEVELOCITY_QUARKUS_KEY_CONFIG_FILE);
        if (!configurationFile.isEmpty()) {
            this.configuration.putAll((Map<?, ?>)QuarkusExtensionUtil.loadProperties(project.getBasedir().getAbsolutePath(), configurationFile));
        }
    }

    boolean isQuarkusCacheEnabled() {
        return !Boolean.FALSE.toString().equals(this.configuration.get(DEVELOCITY_QUARKUS_KEY_CACHE_ENABLED));
    }

    boolean isNativeBuildInContainerRequired() {
        return !Boolean.FALSE.toString().equals(this.configuration.get(DEVELOCITY_QUARKUS_KEY_NATIVE_BUILD_IN_CONTAINER_REQUIRED));
    }

    String getDumpConfigFileName() {
        String subFolder = this.configuration.getProperty(DEVELOCITY_QUARKUS_KEY_DUMP_CONFIG_SUBFOLDER);
        String folder = subFolder.isEmpty() ? ".quarkus" : String.format(".quarkus/%s", subFolder);
        return String.format("%s/%s-%s-%s", folder, this.configuration.getProperty(DEVELOCITY_QUARKUS_KEY_DUMP_CONFIG_PREFIX), this.configuration.getProperty(DEVELOCITY_QUARKUS_KEY_BUILD_PROFILE), this.configuration.getProperty(DEVELOCITY_QUARKUS_KEY_DUMP_CONFIG_SUFFIX));
    }

    String getCurrentConfigFileName() {
        return String.format("target/%s-%s-config-check", this.configuration.getProperty(DEVELOCITY_QUARKUS_KEY_DUMP_CONFIG_PREFIX), this.configuration.getProperty(DEVELOCITY_QUARKUS_KEY_BUILD_PROFILE));
    }

    String getCurrentDependencyFileName() {
        return String.format("target/%s-%s-dependencies.txt", this.configuration.getProperty(DEVELOCITY_QUARKUS_KEY_DUMP_CONFIG_PREFIX), this.configuration.getProperty(DEVELOCITY_QUARKUS_KEY_BUILD_PROFILE));
    }

    String getCurrentDependencyChecksumsFileName() {
        return String.format("target/%s-%s-dependency-checksums.txt", this.configuration.getProperty(DEVELOCITY_QUARKUS_KEY_DUMP_CONFIG_PREFIX), this.configuration.getProperty(DEVELOCITY_QUARKUS_KEY_BUILD_PROFILE));
    }

    List<String> getExtraOutputDirs() {
        return Arrays.asList(this.configuration.getProperty(DEVELOCITY_QUARKUS_KEY_EXTRA_OUTPUT_DIRS).split(","));
    }

    List<String> getExtraOutputFiles() {
        return Arrays.asList(this.configuration.getProperty(DEVELOCITY_QUARKUS_KEY_EXTRA_OUTPUT_FILES).split(","));
    }

    public String toString() {
        return this.configuration.toString();
    }
}

