/*
 * Decompiled with CFR 0.152.
 */
package com.gradle;

import com.gradle.QuarkusExtensionUtil;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.project.MavenProject;

final class QuarkusExtensionConfiguration {
    private static final String DEVELOCITY_QUARKUS_KEY_CACHE_ENABLED = "DEVELOCITY_QUARKUS_CACHE_ENABLED";
    private static final String DEVELOCITY_QUARKUS_KEY_CONFIG_FILE = "DEVELOCITY_QUARKUS_EXTENSION_CONFIG_FILE";
    private static final String DEVELOCITY_QUARKUS_KEY_BUILD_PROFILE = "BUILD_PROFILE";
    private static final String DEVELOCITY_QUARKUS_DEFAULT_BUILD_PROFILE = "prod";
    private static final String DEVELOCITY_QUARKUS_KEY_DUMP_CONFIG_PREFIX = "DUMP_CONFIG_PREFIX";
    private static final String DEVELOCITY_QUARKUS_DEFAULT_DUMP_CONFIG_PREFIX = "quarkus";
    private static final String DEVELOCITY_QUARKUS_KEY_DUMP_CONFIG_SUFFIX = "DUMP_CONFIG_SUFFIX";
    private static final String DEVELOCITY_QUARKUS_DEFAULT_DUMP_CONFIG_SUFFIX = "config-dump";
    private final Properties configuration = new Properties();

    QuarkusExtensionConfiguration(MavenProject project) {
        String isQuarkusCacheEnabledFromEnv = System.getenv(DEVELOCITY_QUARKUS_KEY_CACHE_ENABLED);
        this.configuration.setProperty(DEVELOCITY_QUARKUS_KEY_CACHE_ENABLED, isQuarkusCacheEnabledFromEnv != null ? isQuarkusCacheEnabledFromEnv : "");
        this.configuration.setProperty(DEVELOCITY_QUARKUS_KEY_BUILD_PROFILE, DEVELOCITY_QUARKUS_DEFAULT_BUILD_PROFILE);
        this.configuration.setProperty(DEVELOCITY_QUARKUS_KEY_DUMP_CONFIG_PREFIX, DEVELOCITY_QUARKUS_DEFAULT_DUMP_CONFIG_PREFIX);
        this.configuration.setProperty(DEVELOCITY_QUARKUS_KEY_DUMP_CONFIG_SUFFIX, DEVELOCITY_QUARKUS_DEFAULT_DUMP_CONFIG_SUFFIX);
        String extensionConfigurationFileFromEnv = System.getenv(DEVELOCITY_QUARKUS_KEY_CONFIG_FILE);
        String extensionConfigurationFileFromMaven = project.getProperties().getProperty(DEVELOCITY_QUARKUS_KEY_CONFIG_FILE.toLowerCase().replace("_", "."), "");
        if (extensionConfigurationFileFromEnv != null && !extensionConfigurationFileFromEnv.isEmpty()) {
            this.configuration.putAll((Map<?, ?>)QuarkusExtensionUtil.loadProperties(project.getBasedir().getAbsolutePath(), extensionConfigurationFileFromEnv));
        } else if (!extensionConfigurationFileFromMaven.isEmpty()) {
            this.configuration.putAll((Map<?, ?>)QuarkusExtensionUtil.loadProperties(project.getBasedir().getAbsolutePath(), extensionConfigurationFileFromMaven));
        }
    }

    boolean isQuarkusCacheEnabled() {
        return !Boolean.FALSE.toString().equals(this.configuration.get(DEVELOCITY_QUARKUS_KEY_CACHE_ENABLED));
    }

    String getDumpConfigFileName() {
        return String.format(".quarkus/%s-%s-%s", this.configuration.getProperty(DEVELOCITY_QUARKUS_KEY_DUMP_CONFIG_PREFIX), this.configuration.getProperty(DEVELOCITY_QUARKUS_KEY_BUILD_PROFILE), this.configuration.getProperty(DEVELOCITY_QUARKUS_KEY_DUMP_CONFIG_SUFFIX));
    }

    String getCurrentConfigFileName() {
        return String.format("target/%s-%s-config-check", this.configuration.getProperty(DEVELOCITY_QUARKUS_KEY_DUMP_CONFIG_PREFIX), this.configuration.getProperty(DEVELOCITY_QUARKUS_KEY_BUILD_PROFILE));
    }

    String getCurrentDependencyFileName() {
        return String.format("target/%s-%s-dependencies.txt", this.configuration.getProperty(DEVELOCITY_QUARKUS_KEY_DUMP_CONFIG_PREFIX), this.configuration.getProperty(DEVELOCITY_QUARKUS_KEY_BUILD_PROFILE));
    }

    String getCurrentDependencyChecksumsFileName() {
        return String.format("target/%s-%s-dependency-checksums.txt", this.configuration.getProperty(DEVELOCITY_QUARKUS_KEY_DUMP_CONFIG_PREFIX), this.configuration.getProperty(DEVELOCITY_QUARKUS_KEY_BUILD_PROFILE));
    }
}

