/*
 * Decompiled with CFR 0.152.
 */
package com.gradle;

import com.gradle.QuarkusExtensionConfiguration;
import com.gradle.QuarkusExtensionUtil;
import com.gradle.TestConfiguration;
import com.gradle.develocity.agent.maven.api.cache.BuildCacheApi;
import com.gradle.develocity.agent.maven.api.cache.MojoMetadataProvider;
import com.gradle.develocity.agent.maven.api.cache.NormalizationProvider;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class QuarkusBuildCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(QuarkusBuildCache.class);
    private static final String TARGET_DIR = "target/";
    private static final List<String> QUARKUS_CONFIG_KEY_NATIVE_CONTAINER_BUILD = Arrays.asList("quarkus.native.container-build", "quarkus.native.remote-container-build");
    private static final String QUARKUS_CONFIG_KEY_NATIVE_BUILDER_IMAGE = "quarkus.native.builder-image";
    private static final String QUARKUS_CONFIG_KEY_DEPRECATED_PACKAGE_TYPE = "quarkus.package.type";
    private static final String QUARKUS_CONFIG_KEY_NATIVE = "quarkus.native.enabled";
    private static final String QUARKUS_CONFIG_KEY_JAR_TYPE = "quarkus.package.jar.type";
    private static final String QUARKUS_CONFIG_KEY_GRAALVM_HOME = "quarkus.native.graalvm-home";
    private static final String QUARKUS_CONFIG_KEY_JAVA_HOME = "quarkus.native.java-home";
    private static final String PACKAGE_NATIVE = "native";
    private static final List<String> QUARKUS_CACHEABLE_JAR_TYPES = Arrays.asList("jar", "legacy-jar", "uber-jar");
    private static final List<String> QUARKUS_KEYS_AS_FILE_INPUTS = Arrays.asList("quarkus.docker.dockerfile-native-path", "quarkus.docker.dockerfile-jvm-path", "quarkus.openshift.jvm-dockerfile", "quarkus.openshift.native-dockerfile");
    private static final List<String> QUARKUS_IGNORED_PROPERTIES = Arrays.asList("quarkus.native.graalvm-home", "quarkus.native.java-home");
    private static final String QUARKUS_ARTIFACT_PROPERTIES_FILE_NAME = "quarkus-artifact.properties";

    QuarkusBuildCache() {
    }

    void configureBuildCache(BuildCacheApi buildCache) {
        buildCache.registerNormalizationProvider(context -> {
            QuarkusExtensionConfiguration extensionConfiguration = new QuarkusExtensionConfiguration(context.getProject());
            this.configureNormalization(context, extensionConfiguration);
        });
        buildCache.registerMojoMetadataProvider(context -> {
            QuarkusExtensionConfiguration extensionConfiguration = new QuarkusExtensionConfiguration(context.getProject());
            context.withPlugin("quarkus-maven-plugin", () -> this.configureQuarkusBuildGoal(context, extensionConfiguration));
            context.withPlugin("maven-surefire-plugin", () -> {
                TestConfiguration testConfiguration = new TestConfiguration(context, extensionConfiguration);
                this.configureQuarkusExtraTestInputs(context, extensionConfiguration, testConfiguration);
            });
            context.withPlugin("maven-failsafe-plugin", () -> {
                TestConfiguration testConfiguration = new TestConfiguration(context, extensionConfiguration);
                this.configureQuarkusExtraTestInputs(context, extensionConfiguration, testConfiguration);
                this.configureQuarkusExtraIntegrationTestInputs(context, testConfiguration);
            });
        });
    }

    private void configureNormalization(NormalizationProvider.Context context, QuarkusExtensionConfiguration extensionConfiguration) {
        if (extensionConfiguration.isQuarkusCacheEnabled()) {
            context.configureRuntimeClasspathNormalization(normalization -> normalization.addPropertiesNormalization(extensionConfiguration.getCurrentConfigFileName(), QUARKUS_IGNORED_PROPERTIES));
        }
    }

    private void configureQuarkusExtraTestInputs(MojoMetadataProvider.Context context, QuarkusExtensionConfiguration extensionConfiguration, TestConfiguration testConfiguration) {
        LOGGER.debug(QuarkusExtensionUtil.getLogMessage(testConfiguration.toString()));
        if (testConfiguration.isAddQuarkusInputs()) {
            LOGGER.debug(QuarkusExtensionUtil.getLogMessage("Adding Quarkus extra test inputs"));
            context.inputs(inputs -> this.addQuarkusDependencyChecksumsInput((MojoMetadataProvider.Context.Inputs)inputs, extensionConfiguration));
            context.inputs(inputs -> this.addQuarkusDependenciesInputs((MojoMetadataProvider.Context.Inputs)inputs, extensionConfiguration));
        }
        if (testConfiguration.isAddQuarkusPackageInputs()) {
            LOGGER.debug(QuarkusExtensionUtil.getLogMessage("Adding Quarkus extra test package inputs"));
            context.inputs(inputs -> this.addQuarkusJarInput((MojoMetadataProvider.Context.Inputs)inputs, testConfiguration));
        }
    }

    private void configureQuarkusExtraIntegrationTestInputs(MojoMetadataProvider.Context context, TestConfiguration testConfiguration) {
        if (testConfiguration.isAddQuarkusInputs()) {
            context.inputs(this::addQuarkusArtifactPropertiesInput);
        }
        if (testConfiguration.isAddQuarkusPackageInputs()) {
            context.inputs(inputs -> this.addQuarkusExeInput((MojoMetadataProvider.Context.Inputs)inputs, testConfiguration));
        }
    }

    private void configureQuarkusBuildGoal(MojoMetadataProvider.Context context, QuarkusExtensionConfiguration extensionConfiguration) {
        if ("build".equals(context.getMojoExecution().getGoal())) {
            LOGGER.debug(QuarkusExtensionUtil.getLogMessage(extensionConfiguration.toString()));
            if (extensionConfiguration.isQuarkusCacheEnabled()) {
                LOGGER.debug(QuarkusExtensionUtil.getLogMessage("Quarkus caching is enabled"));
                String baseDir = context.getProject().getBasedir().getAbsolutePath();
                Properties quarkusPreviousProperties = QuarkusExtensionUtil.loadProperties(baseDir, extensionConfiguration.getDumpConfigFileName());
                Properties quarkusCurrentProperties = QuarkusExtensionUtil.loadProperties(baseDir, extensionConfiguration.getCurrentConfigFileName());
                if (this.isQuarkusBuildCacheable(quarkusPreviousProperties, quarkusCurrentProperties, extensionConfiguration.isNativeBuildInContainerRequired())) {
                    LOGGER.info(QuarkusExtensionUtil.getLogMessage("Quarkus build goal marked as cacheable"));
                    this.configureInputs(context, extensionConfiguration, quarkusCurrentProperties);
                    this.configureOutputs(context, extensionConfiguration.getExtraOutputDirs(), extensionConfiguration.getExtraOutputFiles());
                } else {
                    LOGGER.info(QuarkusExtensionUtil.getLogMessage("Quarkus build goal marked as not cacheable"));
                }
            } else {
                LOGGER.debug(QuarkusExtensionUtil.getLogMessage("Quarkus caching is disabled"));
            }
        }
    }

    private boolean isQuarkusBuildCacheable(Properties quarkusPreviousProperties, Properties quarkusCurrentProperties, boolean isNativeBuildInContainerRequired) {
        return this.isQuarkusDumpConfigFilePresent(quarkusPreviousProperties, quarkusCurrentProperties) && this.isJarPackagingTypeSupported(quarkusCurrentProperties) && this.isNotNativeOrInContainerNativeBuild(quarkusCurrentProperties, isNativeBuildInContainerRequired) && this.isQuarkusPropertiesUnchanged(quarkusPreviousProperties, quarkusCurrentProperties);
    }

    private boolean isQuarkusDumpConfigFilePresent(Properties quarkusPreviousProperties, Properties quarkusCurrentProperties) {
        if (quarkusPreviousProperties.isEmpty()) {
            LOGGER.info(QuarkusExtensionUtil.getLogMessage("Quarkus previous configuration not found"));
            return false;
        }
        if (quarkusCurrentProperties.isEmpty()) {
            LOGGER.info(QuarkusExtensionUtil.getLogMessage("Quarkus current configuration not found"));
            return false;
        }
        return true;
    }

    private boolean isQuarkusPropertiesUnchanged(Properties quarkusPreviousProperties, Properties quarkusCurrentProperties) {
        HashSet<Map.Entry<Object, Object>> quarkusPropertiesCopy = new HashSet<Map.Entry<Object, Object>>(quarkusPreviousProperties.entrySet());
        quarkusPropertiesCopy.removeAll(quarkusCurrentProperties.entrySet());
        quarkusPropertiesCopy.removeIf(e -> QUARKUS_IGNORED_PROPERTIES.contains(e.getKey().toString()));
        if (quarkusPropertiesCopy.isEmpty()) {
            return true;
        }
        LOGGER.info(QuarkusExtensionUtil.getLogMessage("Quarkus properties have changed"));
        LOGGER.debug(QuarkusExtensionUtil.getLogMessage("[" + quarkusPropertiesCopy.stream().map(e -> e.getKey().toString()).collect(Collectors.joining(", ")) + "]"));
        return false;
    }

    private boolean isNativeBuild(Properties quarkusCurrentProperties) {
        return Boolean.parseBoolean(quarkusCurrentProperties.getProperty(QUARKUS_CONFIG_KEY_NATIVE)) || PACKAGE_NATIVE.equals(quarkusCurrentProperties.getProperty(QUARKUS_CONFIG_KEY_DEPRECATED_PACKAGE_TYPE));
    }

    private boolean isNotNativeOrInContainerNativeBuild(Properties quarkusCurrentProperties, boolean isNativeBuildInContainerRequired) {
        if (this.isNativeBuild(quarkusCurrentProperties)) {
            if (isNativeBuildInContainerRequired) {
                String builderImage = quarkusCurrentProperties.getProperty(QUARKUS_CONFIG_KEY_NATIVE_BUILDER_IMAGE, "");
                if (builderImage.isEmpty()) {
                    LOGGER.info(QuarkusExtensionUtil.getLogMessage("Quarkus build is not using a fixed image"));
                    return false;
                }
                if (QUARKUS_CONFIG_KEY_NATIVE_CONTAINER_BUILD.stream().noneMatch(key -> Boolean.parseBoolean(quarkusCurrentProperties.getProperty((String)key)))) {
                    LOGGER.info(QuarkusExtensionUtil.getLogMessage("Quarkus build strategy is not in-container"));
                    return false;
                }
            } else {
                LOGGER.info(QuarkusExtensionUtil.getLogMessage("Quarkus in-container build strategy is not required"));
            }
        } else {
            LOGGER.debug(QuarkusExtensionUtil.getLogMessage("Quarkus build is not native"));
        }
        return true;
    }

    private boolean isJarPackagingTypeSupported(Properties quarkusCurrentProperties) {
        String packageType;
        if (!(this.isNativeBuild(quarkusCurrentProperties) || (packageType = this.getJarPackageType(quarkusCurrentProperties)) != null && QUARKUS_CACHEABLE_JAR_TYPES.contains(packageType))) {
            LOGGER.info(QuarkusExtensionUtil.getLogMessage("Quarkus package type " + packageType + " is not cacheable"));
            return false;
        }
        return true;
    }

    private String getJarPackageType(Properties quarkusCurrentProperties) {
        String jarPackageType = quarkusCurrentProperties.getProperty(QUARKUS_CONFIG_KEY_JAR_TYPE);
        if (jarPackageType == null) {
            jarPackageType = quarkusCurrentProperties.getProperty(QUARKUS_CONFIG_KEY_DEPRECATED_PACKAGE_TYPE);
        }
        return jarPackageType;
    }

    private void configureInputs(MojoMetadataProvider.Context context, QuarkusExtensionConfiguration extensionConfiguration, Properties quarkusCurrentProperties) {
        context.inputs(inputs -> {
            this.addOsInputs((MojoMetadataProvider.Context.Inputs)inputs);
            this.addCompilerInputs((MojoMetadataProvider.Context.Inputs)inputs);
            this.addClasspathInput(context, (MojoMetadataProvider.Context.Inputs)inputs);
            this.addMojoInputs((MojoMetadataProvider.Context.Inputs)inputs);
            this.addQuarkusPropertiesInput((MojoMetadataProvider.Context.Inputs)inputs, extensionConfiguration);
            this.addQuarkusConfigurationFilesInputs((MojoMetadataProvider.Context.Inputs)inputs, quarkusCurrentProperties);
            this.addQuarkusDependenciesInputs((MojoMetadataProvider.Context.Inputs)inputs, extensionConfiguration);
            this.addQuarkusDependencyChecksumsInput((MojoMetadataProvider.Context.Inputs)inputs, extensionConfiguration);
        });
    }

    private void addOsInputs(MojoMetadataProvider.Context.Inputs inputs) {
        inputs.property("osName", (Object)System.getProperty("os.name")).property("osVersion", (Object)System.getProperty("os.version")).property("osArch", (Object)System.getProperty("os.arch"));
    }

    private void addCompilerInputs(MojoMetadataProvider.Context.Inputs inputs) {
        inputs.property("javaVersion", (Object)System.getProperty("java.version"));
    }

    private void addClasspathInput(MojoMetadataProvider.Context context, MojoMetadataProvider.Context.Inputs inputs) {
        try {
            List compileClasspathElements = context.getProject().getCompileClasspathElements();
            inputs.fileSet("quarkusCompileClasspath", (Object)compileClasspathElements, fileSet -> fileSet.normalizationStrategy(MojoMetadataProvider.Context.FileSet.NormalizationStrategy.CLASSPATH));
        }
        catch (DependencyResolutionRequiredException e) {
            throw new IllegalStateException("Classpath can't be resolved");
        }
    }

    private void addMojoInputs(MojoMetadataProvider.Context.Inputs inputs) {
        inputs.fileSet("generatedSourcesDirectory", fileSet -> {}).properties(new String[]{"appArtifact", "closeBootstrappedApp", "finalName", "ignoredEntries", "manifestEntries", "manifestSections", "skip", "skipOriginalJarRename", "systemProperties", "properties"}).ignore(new String[]{"project", "buildDir", "mojoExecution", "session", "repoSession", "repos", "pluginRepos", "attachRunnerAsMainArtifact", "bootstrapId", "buildDirectory"});
    }

    private void addQuarkusPropertiesInput(MojoMetadataProvider.Context.Inputs inputs, QuarkusExtensionConfiguration extensionConfiguration) {
        inputs.fileSet("quarkusConfigCheck", (Object)new File(extensionConfiguration.getCurrentConfigFileName()), fileSet -> fileSet.normalizationStrategy(MojoMetadataProvider.Context.FileSet.NormalizationStrategy.RELATIVE_PATH));
        inputs.fileSet("generatedSourcesDirectory", fileSet -> {});
    }

    private void addQuarkusConfigurationFilesInputs(MojoMetadataProvider.Context.Inputs inputs, Properties quarkusCurrentProperties) {
        for (String quarkusFilePropertyKey : QUARKUS_KEYS_AS_FILE_INPUTS) {
            String quarkusFilePropertyValue = quarkusCurrentProperties.getProperty(quarkusFilePropertyKey);
            if (!QuarkusExtensionUtil.isNotEmpty(quarkusFilePropertyValue)) continue;
            inputs.fileSet(quarkusFilePropertyKey, (Object)new File(quarkusFilePropertyValue), fileSet -> fileSet.normalizationStrategy(MojoMetadataProvider.Context.FileSet.NormalizationStrategy.RELATIVE_PATH));
        }
    }

    @Deprecated
    private void addQuarkusDependencyChecksumsInput(MojoMetadataProvider.Context.Inputs inputs, QuarkusExtensionConfiguration extensionConfiguration) {
        inputs.fileSet("quarkusDependencyChecksums", (Object)new File(extensionConfiguration.getCurrentDependencyChecksumsFileName()), fileSet -> fileSet.normalizationStrategy(MojoMetadataProvider.Context.FileSet.NormalizationStrategy.RELATIVE_PATH));
    }

    private void addQuarkusArtifactPropertiesInput(MojoMetadataProvider.Context.Inputs inputs) {
        inputs.fileSet("quarkusArtifactProperties", (Object)new File("target/quarkus-artifact.properties"), fileSet -> fileSet.normalizationStrategy(MojoMetadataProvider.Context.FileSet.NormalizationStrategy.RELATIVE_PATH));
    }

    private void addQuarkusJarInput(MojoMetadataProvider.Context.Inputs inputs, TestConfiguration testConfiguration) {
        inputs.fileSet("quarkusJarFile", (Object)new File(TARGET_DIR), fileSet -> fileSet.include(new String[]{testConfiguration.getQuarkusJarFilePattern()}).normalizationStrategy(MojoMetadataProvider.Context.FileSet.NormalizationStrategy.CLASSPATH));
    }

    private void addQuarkusExeInput(MojoMetadataProvider.Context.Inputs inputs, TestConfiguration testConfiguration) {
        inputs.fileSet("quarkusExeFile", (Object)new File(TARGET_DIR), fileSet -> fileSet.include(new String[]{testConfiguration.getQuarkusExeFilePattern()}).normalizationStrategy(MojoMetadataProvider.Context.FileSet.NormalizationStrategy.RELATIVE_PATH));
    }

    private void addQuarkusDependenciesInputs(MojoMetadataProvider.Context.Inputs inputs, QuarkusExtensionConfiguration extensionConfiguration) {
        File quarkusDependencyFile = new File(extensionConfiguration.getCurrentDependencyFileName());
        if (quarkusDependencyFile.exists()) {
            try {
                List<String> quarkusDependencies = Files.readAllLines(quarkusDependencyFile.toPath(), Charset.defaultCharset());
                inputs.fileSet("quarkusDependencies", quarkusDependencies, fileSet -> fileSet.normalizationStrategy(MojoMetadataProvider.Context.FileSet.NormalizationStrategy.CLASSPATH));
            }
            catch (IOException e) {
                LOGGER.error(QuarkusExtensionUtil.getLogMessage("Error while loading " + quarkusDependencyFile), (Throwable)e);
            }
        } else {
            LOGGER.debug(QuarkusExtensionUtil.getLogMessage(quarkusDependencyFile + " not found"));
        }
    }

    private void configureOutputs(MojoMetadataProvider.Context context, List<String> extraOutputDirs, List<String> extraOutputFiles) {
        context.outputs(outputs -> {
            String quarkusExeFileName = TARGET_DIR + context.getProject().getBuild().getFinalName() + "-runner";
            String quarkusJarFileName = TARGET_DIR + context.getProject().getBuild().getFinalName() + ".jar";
            String quarkusUberJarFileName = TARGET_DIR + context.getProject().getBuild().getFinalName() + "-runner.jar";
            String quarkusArtifactProperties = "target/quarkus-artifact.properties";
            outputs.cacheable("this plugin has CPU-bound goals with well-defined inputs and outputs");
            outputs.file("quarkusExe", (Object)quarkusExeFileName);
            outputs.file("quarkusJar", (Object)quarkusJarFileName);
            outputs.file("quarkusUberJar", (Object)quarkusUberJarFileName);
            outputs.file("quarkusArtifactProperties", (Object)quarkusArtifactProperties);
            extraOutputDirs.forEach(extraOutput -> {
                if (!extraOutput.isEmpty()) {
                    LOGGER.debug(QuarkusExtensionUtil.getLogMessage("Adding extra output dir " + extraOutput));
                    outputs.directory(extraOutput, (Object)(TARGET_DIR + extraOutput));
                }
            });
            extraOutputFiles.forEach(extraOutput -> {
                if (!extraOutput.isEmpty()) {
                    LOGGER.debug(QuarkusExtensionUtil.getLogMessage("Adding extra output file " + extraOutput));
                    outputs.file(extraOutput, (Object)(TARGET_DIR + extraOutput));
                }
            });
        });
    }
}

