/*
 * Decompiled with CFR 0.152.
 */
package com.gradleup.gr8;

import com.gradleup.gr8.FilterTransform;
import com.gradleup.gr8.Gr8Configurator;
import com.gradleup.gr8.Gr8Extension;
import com.gradleup.gr8.Gr8Task;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationPublications;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.FileCollectionDependency;
import org.gradle.api.artifacts.transform.TransformSpec;
import org.gradle.api.artifacts.type.ArtifactTypeDefinition;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.Bundling;
import org.gradle.api.attributes.Category;
import org.gradle.api.attributes.LibraryElements;
import org.gradle.api.attributes.Usage;
import org.gradle.api.component.AdhocComponentWithVariants;
import org.gradle.api.component.SoftwareComponentContainer;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0001J$\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00072\u000e\b\u0002\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014J\u0014\u0010\u0016\u001a\u00020\r2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00070\u0018J\u001c\u0010\u0016\u001a\u00020\r2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00070\u00182\u0006\u0010\u0019\u001a\u00020\u0007J\u0006\u0010\u001a\u001a\u00020\rJ\u000e\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u0001R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8eX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/gradleup/gr8/Gr8Extension;", "", "project", "Lorg/gradle/api/Project;", "(Lorg/gradle/api/Project;)V", "configurators", "", "", "javaToolchainService", "Lorg/gradle/jvm/toolchain/JavaToolchainService;", "getJavaToolchainService", "()Lorg/gradle/jvm/toolchain/JavaToolchainService;", "addShadowedVariant", "", "shadowedJar", "create", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/RegularFile;", "name", "action", "Lorg/gradle/api/Action;", "Lcom/gradleup/gr8/Gr8Configurator;", "registerFilterTransform", "excludePatterns", "", "artifactType", "removeGradleApiFromApi", "replaceOutgoingJar", "newJar", "gr8-plugin-common"})
@SourceDebugExtension(value={"SMAP\nGr8Extension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Gr8Extension.kt\ncom/gradleup/gr8/Gr8Extension\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,129:1\n288#2,2:130\n*S KotlinDebug\n*F\n+ 1 Gr8Extension.kt\ncom/gradleup/gr8/Gr8Extension\n*L\n109#1:130,2\n*E\n"})
public abstract class Gr8Extension {
    @NotNull
    private final Project project;
    @NotNull
    private final Set<String> configurators;

    public Gr8Extension(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.configurators = new LinkedHashSet();
    }

    @Inject
    @NotNull
    protected abstract JavaToolchainService getJavaToolchainService();

    @NotNull
    public final Provider<RegularFile> create(@NotNull String name, @NotNull Action<Gr8Configurator> action) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        if (!(!this.configurators.contains(name))) {
            boolean $i$a$-check-Gr8Extension$create$32 = false;
            String $i$a$-check-Gr8Extension$create$32 = "Gr8: " + name + " is already created";
            throw new IllegalStateException($i$a$-check-Gr8Extension$create$32.toString());
        }
        Gr8Configurator configurator = new Gr8Configurator(name, this.project, this.getJavaToolchainService());
        this.configurators.add(name);
        action.execute((Object)configurator);
        TaskProvider<Gr8Task> provider = configurator.registerTasks$gr8_plugin_common();
        Provider provider2 = provider.flatMap(arg_0 -> Gr8Extension.create$lambda$2(create.3.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"flatMap(...)");
        return provider2;
    }

    public static /* synthetic */ Provider create$default(Gr8Extension gr8Extension, String string, Action action, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: create");
        }
        if ((n & 2) != 0) {
            action = Gr8Extension::create$lambda$0;
        }
        return gr8Extension.create(string, (Action<Gr8Configurator>)action);
    }

    public final void replaceOutgoingJar(@NotNull Object newJar) {
        Intrinsics.checkNotNullParameter((Object)newJar, (String)"newJar");
        this.project.getConfigurations().configureEach(arg_0 -> Gr8Extension.replaceOutgoingJar$lambda$3((Function1)new Function1<Configuration, Unit>(newJar){
            final /* synthetic */ Object $newJar;
            {
                this.$newJar = $newJar;
                super(1);
            }

            public final void invoke(Configuration configuration) {
                configuration.outgoing(arg_0 -> replaceOutgoingJar.1.invoke$lambda$0((Function1)new Function1<ConfigurationPublications, Unit>(this.$newJar){
                    final /* synthetic */ Object $newJar;
                    {
                        this.$newJar = $newJar;
                        super(1);
                    }

                    public final void invoke(ConfigurationPublications publications) {
                        boolean removed2 = publications.getArtifacts().removeIf(arg_0 -> replaceOutgoingJar.1.invoke$lambda$0(replaceOutgoingJar.removed.1.INSTANCE, arg_0));
                        if (removed2) {
                            publications.artifact(this.$newJar, arg_0 -> replaceOutgoingJar.1.invoke$lambda$1(replaceOutgoingJar.1.INSTANCE, arg_0));
                        }
                    }

                    private static final boolean invoke$lambda$0(Function1 $tmp0, Object p0) {
                        return (Boolean)$tmp0.invoke(p0);
                    }

                    private static final void invoke$lambda$1(Function1 $tmp0, Object p0) {
                        $tmp0.invoke(p0);
                    }
                }, arg_0));
            }

            private static final void invoke$lambda$0(Function1 $tmp0, Object p0) {
                $tmp0.invoke(p0);
            }
        }, arg_0));
    }

    public final void addShadowedVariant(@NotNull Object shadowedJar) {
        Intrinsics.checkNotNullParameter((Object)shadowedJar, (String)"shadowedJar");
        Configuration producerConfiguration2 = (Configuration)this.project.getConfigurations().create("gr8", arg_0 -> Gr8Extension.addShadowedVariant$lambda$4((Function1)new Function1<Configuration, Unit>(this){
            final /* synthetic */ Gr8Extension this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(Configuration it) {
                it.setCanBeResolved(false);
                it.setCanBeConsumed(true);
                it.attributes(arg_0 -> addShadowedVariant.producerConfiguration.1.invoke$lambda$0((Function1)new Function1<AttributeContainer, Unit>(this.this$0){
                    final /* synthetic */ Gr8Extension this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(AttributeContainer it) {
                        it.attribute(Usage.USAGE_ATTRIBUTE, (Object)Gr8Extension.access$getProject$p(this.this$0).getObjects().named(Usage.class, "java-runtime"));
                        it.attribute(Bundling.BUNDLING_ATTRIBUTE, (Object)Gr8Extension.access$getProject$p(this.this$0).getObjects().named(Bundling.class, "shadowed"));
                        it.attribute(Category.CATEGORY_ATTRIBUTE, (Object)Gr8Extension.access$getProject$p(this.this$0).getObjects().named(Category.class, "library"));
                        it.attribute(LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE, (Object)Gr8Extension.access$getProject$p(this.this$0).getObjects().named(LibraryElements.class, "jar"));
                    }
                }, arg_0));
            }

            private static final void invoke$lambda$0(Function1 $tmp0, Object p0) {
                $tmp0.invoke(p0);
            }
        }, arg_0));
        SoftwareComponentContainer components = this.project.getComponents();
        Object object = components.findByName("java");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.gradle.api.component.AdhocComponentWithVariants");
        AdhocComponentWithVariants javaComponent = (AdhocComponentWithVariants)object;
        javaComponent.addVariantsFromConfiguration(producerConfiguration2, arg_0 -> Gr8Extension.addShadowedVariant$lambda$5(addShadowedVariant.1.INSTANCE, arg_0));
        this.project.getArtifacts().add("gr8", shadowedJar);
    }

    public final void removeGradleApiFromApi() {
        Object v0;
        DependencySet apiDependencies;
        block1: {
            apiDependencies = this.project.getConfigurations().getByName("api").getDependencies();
            Intrinsics.checkNotNull((Object)apiDependencies);
            Iterable $this$firstOrNull$iv = (Iterable)apiDependencies;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Dependency it = (Dependency)element$iv;
                boolean bl = false;
                if (!(it instanceof FileCollectionDependency)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        Dependency it = v0;
        boolean bl = false;
        apiDependencies.remove((Object)it);
    }

    public final void registerFilterTransform(@NotNull List<String> excludePatterns) {
        Intrinsics.checkNotNullParameter(excludePatterns, (String)"excludePatterns");
        this.registerFilterTransform(excludePatterns, FilterTransform.artifactType);
    }

    public final void registerFilterTransform(@NotNull List<String> excludePatterns, @NotNull String artifactType) {
        Intrinsics.checkNotNullParameter(excludePatterns, (String)"excludePatterns");
        Intrinsics.checkNotNullParameter((Object)artifactType, (String)"artifactType");
        this.project.getDependencies().registerTransform(FilterTransform.class, arg_0 -> Gr8Extension.registerFilterTransform$lambda$8((Function1)new Function1<TransformSpec<FilterTransform.Parameters>, Unit>(artifactType, excludePatterns){
            final /* synthetic */ String $artifactType;
            final /* synthetic */ List<String> $excludePatterns;
            {
                this.$artifactType = $artifactType;
                this.$excludePatterns = $excludePatterns;
                super(1);
            }

            public final void invoke(TransformSpec<FilterTransform.Parameters> it) {
                it.getFrom().attribute(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE, (Object)"jar");
                it.getTo().attribute(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE, (Object)this.$artifactType);
                ((FilterTransform.Parameters)it.getParameters()).setExcludes(this.$excludePatterns);
            }
        }, arg_0));
    }

    private static final void create$lambda$0(Gr8Configurator it) {
    }

    private static final Provider create$lambda$2(Function1 $tmp0, Object p0) {
        return (Provider)$tmp0.invoke(p0);
    }

    private static final void replaceOutgoingJar$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void addShadowedVariant$lambda$4(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void addShadowedVariant$lambda$5(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void registerFilterTransform$lambda$8(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ Project access$getProject$p(Gr8Extension $this) {
        return $this.project;
    }
}

