/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.apache.logging.log4j.spi;

import shadow.org.apache.logging.log4j.LogManager;
import shadow.org.apache.logging.log4j.Logger;
import shadow.org.apache.logging.log4j.spi.CopyOnWriteSortedArrayThreadContextMap;
import shadow.org.apache.logging.log4j.spi.DefaultThreadContextMap;
import shadow.org.apache.logging.log4j.spi.GarbageFreeSortedArrayThreadContextMap;
import shadow.org.apache.logging.log4j.spi.Provider;
import shadow.org.apache.logging.log4j.spi.ThreadContextMap;
import shadow.org.apache.logging.log4j.status.StatusLogger;
import shadow.org.apache.logging.log4j.util.Constants;
import shadow.org.apache.logging.log4j.util.LoaderUtil;
import shadow.org.apache.logging.log4j.util.PropertiesUtil;
import shadow.org.apache.logging.log4j.util.ProviderUtil;

public final class ThreadContextMapFactory {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private static final String THREAD_CONTEXT_KEY = "log4j2.threadContextMap";
    private static final String GC_FREE_THREAD_CONTEXT_KEY = "log4j2.garbagefree.threadContextMap";
    private static boolean GcFreeThreadContextKey;
    private static String ThreadContextMapName;
    private static final String GARBAGE_FREE_CONTEXT_MAP = "shadow.org.apache.logging.log4j.spi.GarbageFreeSortedArrayThreadContextMap";
    private static final String COPY_ON_WRITE_CONTEXT_MAP = "shadow.org.apache.logging.log4j.spi.CopyOnWriteSortedArrayThreadContextMap";

    public static void init() {
        CopyOnWriteSortedArrayThreadContextMap.init();
        GarbageFreeSortedArrayThreadContextMap.init();
        DefaultThreadContextMap.init();
        ThreadContextMapFactory.initPrivate();
    }

    private static void initPrivate() {
        PropertiesUtil properties = PropertiesUtil.getProperties();
        ThreadContextMapName = properties.getStringProperty(THREAD_CONTEXT_KEY);
        GcFreeThreadContextKey = properties.getBooleanProperty(GC_FREE_THREAD_CONTEXT_KEY);
    }

    private ThreadContextMapFactory() {
    }

    public static ThreadContextMap createThreadContextMap() {
        ClassLoader cl = ProviderUtil.findClassLoader();
        ThreadContextMap result = null;
        if (ThreadContextMapName != null) {
            switch (ThreadContextMapName) {
                case "shadow.org.apache.logging.log4j.spi.GarbageFreeSortedArrayThreadContextMap": {
                    result = new GarbageFreeSortedArrayThreadContextMap();
                    break;
                }
                case "shadow.org.apache.logging.log4j.spi.CopyOnWriteSortedArrayThreadContextMap": {
                    result = new CopyOnWriteSortedArrayThreadContextMap();
                    break;
                }
                default: {
                    try {
                        result = LoaderUtil.newCheckedInstanceOf(ThreadContextMapName, ThreadContextMap.class);
                        break;
                    }
                    catch (ClassNotFoundException cnfe) {
                        LOGGER.error("Unable to locate configured ThreadContextMap {}", (Object)ThreadContextMapName);
                        break;
                    }
                    catch (Exception ex) {
                        LOGGER.error("Unable to create configured ThreadContextMap {}", (Object)ThreadContextMapName, (Object)ex);
                    }
                }
            }
        }
        if (result == null && ProviderUtil.hasProviders() && LogManager.getFactory() != null) {
            String factoryClassName = LogManager.getFactory().getClass().getName();
            for (Provider provider : ProviderUtil.getProviders()) {
                Class<? extends ThreadContextMap> clazz;
                if (!factoryClassName.equals(provider.getClassName()) || (clazz = provider.loadThreadContextMap()) == null) continue;
                try {
                    result = LoaderUtil.newInstanceOf(clazz);
                    break;
                }
                catch (Exception e) {
                    LOGGER.error("Unable to locate or load configured ThreadContextMap {}", (Object)provider.getThreadContextMap(), (Object)e);
                    result = ThreadContextMapFactory.createDefaultThreadContextMap();
                }
            }
        }
        if (result == null) {
            result = ThreadContextMapFactory.createDefaultThreadContextMap();
        }
        return result;
    }

    private static ThreadContextMap createDefaultThreadContextMap() {
        if (Constants.ENABLE_THREADLOCALS) {
            if (GcFreeThreadContextKey) {
                return new GarbageFreeSortedArrayThreadContextMap();
            }
            return new CopyOnWriteSortedArrayThreadContextMap();
        }
        return new DefaultThreadContextMap(true);
    }

    static {
        ThreadContextMapFactory.initPrivate();
    }
}

