/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.apache.maven.api.xml;

import java.util.List;
import java.util.Map;
import shadow.org.apache.maven.api.annotations.Experimental;
import shadow.org.apache.maven.api.annotations.Immutable;
import shadow.org.apache.maven.api.annotations.Nonnull;
import shadow.org.apache.maven.api.annotations.Nullable;
import shadow.org.apache.maven.api.annotations.ThreadSafe;

@Experimental
@ThreadSafe
@Immutable
public interface XmlNode {
    public static final String CHILDREN_COMBINATION_MODE_ATTRIBUTE = "combine.children";
    public static final String CHILDREN_COMBINATION_MERGE = "merge";
    public static final String CHILDREN_COMBINATION_APPEND = "append";
    public static final String DEFAULT_CHILDREN_COMBINATION_MODE = "merge";
    public static final String SELF_COMBINATION_MODE_ATTRIBUTE = "combine.self";
    public static final String SELF_COMBINATION_OVERRIDE = "override";
    public static final String SELF_COMBINATION_MERGE = "merge";
    public static final String SELF_COMBINATION_REMOVE = "remove";
    public static final String ID_COMBINATION_MODE_ATTRIBUTE = "combine.id";
    public static final String KEYS_COMBINATION_MODE_ATTRIBUTE = "combine.keys";
    public static final String DEFAULT_SELF_COMBINATION_MODE = "merge";

    @Nonnull
    public String getName();

    @Nonnull
    public String getNamespaceUri();

    @Nonnull
    public String getPrefix();

    @Nullable
    public String getValue();

    @Nonnull
    public Map<String, String> getAttributes();

    @Nullable
    public String getAttribute(@Nonnull String var1);

    @Nonnull
    public List<XmlNode> getChildren();

    @Nullable
    public XmlNode getChild(String var1);

    @Nullable
    public Object getInputLocation();

    default public XmlNode merge(@Nullable XmlNode source) {
        return this.merge(source, null);
    }

    public XmlNode merge(@Nullable XmlNode var1, @Nullable Boolean var2);

    @Nullable
    public static XmlNode merge(@Nullable XmlNode dominant, @Nullable XmlNode recessive) {
        return XmlNode.merge(dominant, recessive, null);
    }

    @Nullable
    public static XmlNode merge(@Nullable XmlNode dominant, @Nullable XmlNode recessive, @Nullable Boolean childMergeOverride) {
        if (recessive == null) {
            return dominant;
        }
        if (dominant == null) {
            return recessive;
        }
        return dominant.merge(recessive, childMergeOverride);
    }
}

