/*
 * Decompiled with CFR 0.152.
 */
package com.github.jengelman.gradle.plugins.shadow.internal;

import com.github.jengelman.gradle.plugins.shadow.relocation.RelocationContextKt;
import com.github.jengelman.gradle.plugins.shadow.relocation.Relocator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.commons.Remapper;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016J\u000e\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\rR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/github/jengelman/gradle/plugins/shadow/internal/RelocatorRemapper;", "Lorg/objectweb/asm/commons/Remapper;", "relocators", "", "Lcom/github/jengelman/gradle/plugins/shadow/relocation/Relocator;", "<init>", "(Ljava/util/Set;)V", "classPattern", "Ljava/util/regex/Pattern;", "mapValue", "", "value", "map", "", "name", "mapPath", "path", "shadow"})
public final class RelocatorRemapper
extends Remapper {
    @NotNull
    private final Set<Relocator> relocators;
    @NotNull
    private final Pattern classPattern;

    public RelocatorRemapper(@NotNull Set<? extends Relocator> relocators) {
        Intrinsics.checkNotNullParameter(relocators, (String)"relocators");
        this.relocators = relocators;
        Pattern pattern = Pattern.compile("(\\[*)?L(.+)");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        this.classPattern = pattern;
    }

    @NotNull
    public Object mapValue(@NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Object object = value instanceof String ? this.map((String)value) : super.mapValue(value);
        Intrinsics.checkNotNull((Object)object);
        return object;
    }

    @NotNull
    public String map(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String newName = name;
        Object prefix = "";
        String suffix = "";
        Matcher matcher = this.classPattern.matcher(newName);
        if (matcher.matches()) {
            prefix = matcher.group(1) + "L";
            suffix = "";
            String string = matcher.group(2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
            newName = string;
        }
        for (Relocator relocator : this.relocators) {
            if (relocator.canRelocateClass(newName)) {
                return (String)prefix + RelocationContextKt.relocateClass(relocator, newName) + suffix;
            }
            if (!relocator.canRelocatePath(newName)) continue;
            return (String)prefix + RelocationContextKt.relocatePath(relocator, newName) + suffix;
        }
        return name;
    }

    @NotNull
    public final String mapPath(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String string = path.substring(0, StringsKt.indexOf$default((CharSequence)path, (char)'.', (int)0, (boolean)false, (int)6, null));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return this.map(string);
    }
}

