/*
 * Decompiled with CFR 0.152.
 */
package com.github.jengelman.gradle.plugins.shadow.transformers;

import com.github.jengelman.gradle.plugins.shadow.internal.UtilsKt;
import com.github.jengelman.gradle.plugins.shadow.tasks.ShadowCopyAction;
import com.github.jengelman.gradle.plugins.shadow.transformers.CacheableTransformer;
import com.github.jengelman.gradle.plugins.shadow.transformers.ResourceTransformer;
import com.github.jengelman.gradle.plugins.shadow.transformers.TransformerContext;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;
import org.gradle.api.file.FileTreeElement;
import org.jetbrains.annotations.NotNull;

@CacheableTransformer
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J,\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\f0\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0007H\u0016J\u0018\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0007H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/github/jengelman/gradle/plugins/shadow/transformers/GroovyExtensionModuleTransformer;", "Lcom/github/jengelman/gradle/plugins/shadow/transformers/ResourceTransformer;", "<init>", "()V", "module", "Ljava/util/Properties;", "legacy", "", "canTransformResource", "element", "Lorg/gradle/api/file/FileTreeElement;", "transform", "", "context", "Lcom/github/jengelman/gradle/plugins/shadow/transformers/TransformerContext;", "handle", "key", "", "value", "mergeValue", "Lkotlin/Function1;", "hasTransformedResource", "modifyOutputStream", "os", "Lorg/apache/tools/zip/ZipOutputStream;", "preserveFileTimestamps", "Companion", "shadow"})
@SourceDebugExtension(value={"SMAP\nGroovyExtensionModuleTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GroovyExtensionModuleTransformer.kt\ncom/github/jengelman/gradle/plugins/shadow/transformers/GroovyExtensionModuleTransformer\n+ 2 Utils.kt\ncom/github/jengelman/gradle/plugins/shadow/internal/UtilsKt\n+ 3 Utils.kt\ncom/github/jengelman/gradle/plugins/shadow/internal/UtilsKt$zipEntry$1\n*L\n1#1,101:1\n36#2,14:102\n50#2:117\n40#3:116\n*S KotlinDebug\n*F\n+ 1 GroovyExtensionModuleTransformer.kt\ncom/github/jengelman/gradle/plugins/shadow/transformers/GroovyExtensionModuleTransformer\n*L\n79#1:102,14\n79#1:117\n79#1:116\n*E\n"})
public class GroovyExtensionModuleTransformer
implements ResourceTransformer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Properties module = new Properties();
    private boolean legacy = true;
    @NotNull
    public static final String PATH_LEGACY_GROOVY_EXTENSION_MODULE_DESCRIPTOR = "META-INF/services/org.codehaus.groovy.runtime.ExtensionModule";
    @NotNull
    public static final String PATH_GROOVY_EXTENSION_MODULE_DESCRIPTOR = "META-INF/groovy/org.codehaus.groovy.runtime.ExtensionModule";
    @NotNull
    public static final String KEY_MODULE_NAME = "moduleName";
    @NotNull
    public static final String KEY_MODULE_VERSION = "moduleVersion";
    @NotNull
    public static final String KEY_EXTENSION_CLASSES = "extensionClasses";
    @NotNull
    public static final String KEY_STATIC_EXTENSION_CLASSES = "staticExtensionClasses";
    @NotNull
    public static final String MERGED_MODULE_NAME = "MergedByShadowJar";
    @NotNull
    public static final String MERGED_MODULE_VERSION = "1.0.0";

    @Override
    public boolean canTransformResource(@NotNull FileTreeElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        String path = element.getPath();
        if (Intrinsics.areEqual((Object)path, (Object)PATH_GROOVY_EXTENSION_MODULE_DESCRIPTOR)) {
            this.legacy = false;
            return true;
        }
        return Intrinsics.areEqual((Object)path, (Object)PATH_LEGACY_GROOVY_EXTENSION_MODULE_DESCRIPTOR);
    }

    @Override
    public void transform(@NotNull TransformerContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Properties props = new Properties();
        props.load(context.getInputStream());
        props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(arg_0, arg_1) -> GroovyExtensionModuleTransformer.transform$lambda$3(this, arg_0, arg_1)));
    }

    private final void handle(String key, String value, Function1<? super String, Unit> mergeValue) {
        String existingValue = this.module.getProperty(key);
        if (existingValue != null) {
            mergeValue.invoke((Object)existingValue);
        } else {
            this.module.setProperty(key, value);
        }
    }

    @Override
    public boolean hasTransformedResource() {
        return !((Map)this.module).isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modifyOutputStream(@NotNull ZipOutputStream os, boolean preserveFileTimestamps) {
        ZipEntry zipEntry2;
        Intrinsics.checkNotNullParameter((Object)os, (String)"os");
        String name = this.legacy ? PATH_LEGACY_GROOVY_EXTENSION_MODULE_DESCRIPTOR : PATH_GROOVY_EXTENSION_MODULE_DESCRIPTOR;
        long lastModified$iv = -1L;
        boolean $i$f$zipEntry = false;
        ZipEntry $this$zipEntry_u24lambda_u240$iv = zipEntry2 = new ZipEntry(name);
        boolean bl = false;
        if (preserveFileTimestamps) {
            if (lastModified$iv >= 0L) {
                $this$zipEntry_u24lambda_u240$iv.setTime(lastModified$iv);
            }
        } else {
            $this$zipEntry_u24lambda_u240$iv.setTime(ShadowCopyAction.Companion.getCONSTANT_TIME_FOR_ZIP_ENTRIES());
        }
        ZipEntry zipEntry3 = $this$zipEntry_u24lambda_u240$iv;
        ZipOutputStream zipOutputStream = os;
        boolean bl2 = false;
        ZipEntry zipEntry4 = zipEntry3;
        zipOutputStream.putNextEntry(zipEntry2);
        Closeable closeable = UtilsKt.inputStream$default(this.module, null, null, 3, null);
        Throwable throwable = null;
        try {
            ByteArrayInputStream it = (ByteArrayInputStream)closeable;
            boolean bl3 = false;
            long l = ByteStreamsKt.copyTo$default((InputStream)it, (OutputStream)((OutputStream)os), (int)0, (int)2, null);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        os.closeEntry();
    }

    private static final Unit transform$lambda$3$lambda$0(GroovyExtensionModuleTransformer this$0, Object $key, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.module.setProperty((String)$key, MERGED_MODULE_NAME);
        return Unit.INSTANCE;
    }

    private static final Unit transform$lambda$3$lambda$1(GroovyExtensionModuleTransformer this$0, Object $key, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.module.setProperty((String)$key, MERGED_MODULE_VERSION);
        return Unit.INSTANCE;
    }

    private static final Unit transform$lambda$3$lambda$2(GroovyExtensionModuleTransformer this$0, Object $key, Object $value, String existingValue) {
        Intrinsics.checkNotNullParameter((Object)existingValue, (String)"existingValue");
        this$0.module.setProperty((String)$key, existingValue + "," + $value);
        return Unit.INSTANCE;
    }

    private static final void transform$lambda$3(GroovyExtensionModuleTransformer this$0, Object key, Object value) {
        Intrinsics.checkNotNull((Object)key, (String)"null cannot be cast to non-null type kotlin.String");
        switch ((String)key) {
            case "moduleName": {
                String string = (String)key;
                Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.String");
                this$0.handle(string, (String)value, (Function1<? super String, Unit>)((Function1)arg_0 -> GroovyExtensionModuleTransformer.transform$lambda$3$lambda$0(this$0, key, arg_0)));
                break;
            }
            case "moduleVersion": {
                String string = (String)key;
                Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.String");
                this$0.handle(string, (String)value, (Function1<? super String, Unit>)((Function1)arg_0 -> GroovyExtensionModuleTransformer.transform$lambda$3$lambda$1(this$0, key, arg_0)));
                break;
            }
            case "staticExtensionClasses": 
            case "extensionClasses": {
                String string = (String)key;
                Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.String");
                this$0.handle(string, (String)value, (Function1<? super String, Unit>)((Function1)arg_0 -> GroovyExtensionModuleTransformer.transform$lambda$3$lambda$2(this$0, key, value, arg_0)));
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/github/jengelman/gradle/plugins/shadow/transformers/GroovyExtensionModuleTransformer$Companion;", "", "<init>", "()V", "PATH_LEGACY_GROOVY_EXTENSION_MODULE_DESCRIPTOR", "", "PATH_GROOVY_EXTENSION_MODULE_DESCRIPTOR", "KEY_MODULE_NAME", "KEY_MODULE_VERSION", "KEY_EXTENSION_CLASSES", "KEY_STATIC_EXTENSION_CLASSES", "MERGED_MODULE_NAME", "MERGED_MODULE_VERSION", "shadow"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

