/*
 * Decompiled with CFR 0.152.
 */
package com.github.jengelman.gradle.plugins.shadow.tasks;

import com.github.jengelman.gradle.plugins.shadow.internal.RelocatorRemapper;
import com.github.jengelman.gradle.plugins.shadow.relocation.Relocator;
import com.github.jengelman.gradle.plugins.shadow.transformers.ResourceTransformer;
import com.github.jengelman.gradle.plugins.shadow.transformers.TransformerContext;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.tools.zip.Zip64RequiredException;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;
import org.gradle.api.GradleException;
import org.gradle.api.file.FileCopyDetails;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.internal.file.CopyActionProcessingStreamAction;
import org.gradle.api.internal.file.copy.CopyAction;
import org.gradle.api.internal.file.copy.CopyActionProcessingStream;
import org.gradle.api.internal.file.copy.FileCopyDetailsInternal;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.WorkResults;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.commons.ClassRemapper;
import org.objectweb.asm.commons.Remapper;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 \u001f2\u00020\u0001:\u0002\u001e\u001fB_\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\b\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0006H\u0002J\u0010\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0006H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/github/jengelman/gradle/plugins/shadow/tasks/ShadowCopyAction;", "Lorg/gradle/api/internal/file/copy/CopyAction;", "zipFile", "Ljava/io/File;", "zosProvider", "Lkotlin/Function1;", "Lorg/apache/tools/zip/ZipOutputStream;", "transformers", "", "Lcom/github/jengelman/gradle/plugins/shadow/transformers/ResourceTransformer;", "relocators", "Lcom/github/jengelman/gradle/plugins/shadow/relocation/Relocator;", "unusedClasses", "", "preserveFileTimestamps", "", "encoding", "<init>", "(Ljava/io/File;Lkotlin/jvm/functions/Function1;Ljava/util/Set;Ljava/util/Set;Ljava/util/Set;ZLjava/lang/String;)V", "visitedDirs", "", "Lorg/gradle/api/file/FileCopyDetails;", "execute", "Lorg/gradle/api/tasks/WorkResult;", "stream", "Lorg/gradle/api/internal/file/copy/CopyActionProcessingStream;", "processTransformers", "", "zos", "addDirs", "StreamAction", "Companion", "shadow"})
@SourceDebugExtension(value={"SMAP\nShadowCopyAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShadowCopyAction.kt\ncom/github/jengelman/gradle/plugins/shadow/tasks/ShadowCopyAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Utils.kt\ncom/github/jengelman/gradle/plugins/shadow/internal/UtilsKt\n*L\n1#1,247:1\n1869#2,2:248\n1563#2:252\n1634#2,3:253\n1869#2,2:256\n1#3:250\n34#4:251\n41#4,10:258\n*S KotlinDebug\n*F\n+ 1 ShadowCopyAction.kt\ncom/github/jengelman/gradle/plugins/shadow/tasks/ShadowCopyAction\n*L\n83#1:248,2\n96#1:252\n96#1:253,3\n119#1:256,2\n96#1:251\n110#1:258,10\n*E\n"})
public class ShadowCopyAction
implements CopyAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File zipFile;
    @NotNull
    private final Function1<File, ZipOutputStream> zosProvider;
    @NotNull
    private final Set<ResourceTransformer> transformers;
    @NotNull
    private final Set<Relocator> relocators;
    @NotNull
    private final Set<String> unusedClasses;
    private final boolean preserveFileTimestamps;
    @Nullable
    private final String encoding;
    @NotNull
    private final Map<String, FileCopyDetails> visitedDirs;
    private static final Logger logger = Logging.getLogger(ShadowCopyAction.class);
    private static final long CONSTANT_TIME_FOR_ZIP_ENTRIES = new GregorianCalendar(1980, 1, 1, 0, 0, 0).getTimeInMillis();

    public ShadowCopyAction(@NotNull File zipFile, @NotNull Function1<? super File, ? extends ZipOutputStream> zosProvider, @NotNull Set<? extends ResourceTransformer> transformers, @NotNull Set<? extends Relocator> relocators, @NotNull Set<String> unusedClasses, boolean preserveFileTimestamps, @Nullable String encoding) {
        Intrinsics.checkNotNullParameter((Object)zipFile, (String)"zipFile");
        Intrinsics.checkNotNullParameter(zosProvider, (String)"zosProvider");
        Intrinsics.checkNotNullParameter(transformers, (String)"transformers");
        Intrinsics.checkNotNullParameter(relocators, (String)"relocators");
        Intrinsics.checkNotNullParameter(unusedClasses, (String)"unusedClasses");
        this.zipFile = zipFile;
        this.zosProvider = zosProvider;
        this.transformers = transformers;
        this.relocators = relocators;
        this.unusedClasses = unusedClasses;
        this.preserveFileTimestamps = preserveFileTimestamps;
        this.encoding = encoding;
        this.visitedDirs = new LinkedHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public WorkResult execute(@NotNull CopyActionProcessingStream stream) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        try {
            object = (ZipOutputStream)this.zosProvider.invoke((Object)this.zipFile);
        }
        catch (Exception e) {
            throw new GradleException("Could not create ZIP '" + this.zipFile + "'.", (Throwable)e);
        }
        ZipOutputStream zipOutStream = object;
        try {
            object = (Closeable)zipOutStream;
            Throwable e = null;
            try {
                Object zos = object;
                boolean bl = false;
                stream.process((CopyActionProcessingStreamAction)new StreamAction((ZipOutputStream)zos));
                this.processTransformers((ZipOutputStream)zos);
                this.addDirs((ZipOutputStream)zos);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                e = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)e);
            }
        }
        catch (Exception e) {
            if (e instanceof Zip64RequiredException || e.getCause() instanceof Zip64RequiredException) {
                String string;
                if (e instanceof Zip64RequiredException) {
                    string = e.getMessage();
                } else {
                    Throwable throwable = e.getCause();
                    string = throwable != null ? throwable.getMessage() : null;
                }
                String message = string;
                throw new Zip64RequiredException(StringsKt.trimIndent((String)("\n            " + message + "\n\n            To build this archive, please enable the zip64 extension. e.g.\n            ```kts\n            tasks.shadowJar {\n              isZip64 = true\n            }\n            ```\n            See: https://docs.gradle.org/current/dsl/org.gradle.api.tasks.bundling.Zip.html#org.gradle.api.tasks.bundling.Zip:zip64 for more details.\n          ")));
            }
            this.zipFile.delete();
            throw e;
        }
        WorkResult workResult = WorkResults.didWork((boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)workResult, (String)"didWork(...)");
        return workResult;
    }

    private final void processTransformers(ZipOutputStream zos) {
        Iterable $this$forEach$iv = this.transformers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ResourceTransformer transformer = (ResourceTransformer)element$iv;
            boolean bl = false;
            if (!transformer.hasTransformedResource()) continue;
            transformer.modifyOutputStream(zos, this.preserveFileTimestamps);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void addDirs(ZipOutputStream zos) {
        String it;
        void $this$mapTo$iv$iv;
        Field field;
        Field $this$addDirs_u24lambda_u242 = field = zos.getClass().getDeclaredField("entries");
        boolean $i$a$-apply-ShadowCopyAction$addDirs$entries$22 = false;
        $this$addDirs_u24lambda_u242.setAccessible(true);
        Object $this$cast$iv = field.get(zos);
        boolean $i$f$cast = false;
        Object object = $this$cast$iv;
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.List<org.apache.tools.zip.ZipEntry>");
        }
        Iterable $this$map$iv = (List)object;
        boolean $i$f$map = false;
        Iterable $i$a$-apply-ShadowCopyAction$addDirs$entries$22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ZipEntry zipEntry2 = (ZipEntry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        List entries = (List)destination$iv$iv;
        Set added = CollectionsKt.toMutableSet((Iterable)entries);
        long currentTimeMillis = System.currentTimeMillis();
        Iterable $this$forEach$iv = entries;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            ShadowCopyAction.addDirs$addParent(added, this, currentTimeMillis, zos, it);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void addDirs$addParent(Set<String> added, ShadowCopyAction this$0, long currentTimeMillis, ZipOutputStream $zos, String name) {
        String parent = StringsKt.substringBeforeLast((String)name, (char)'/', (String)"");
        String entryName = parent + "/";
        if (((CharSequence)parent).length() > 0 && added.add(entryName)) {
            void preserveLastModified$iv;
            void name$iv;
            ZipEntry zipEntry2;
            FileCopyDetails details = this$0.visitedDirs.get(parent);
            Pair pair = details == null ? TuplesKt.to((Object)currentTimeMillis, (Object)493) : TuplesKt.to((Object)details.getLastModified(), (Object)details.getPermissions().toUnixNumeric());
            long lastModified = ((Number)pair.component1()).longValue();
            int flag = ((Number)pair.component2()).intValue();
            String string = entryName;
            boolean bl = this$0.preserveFileTimestamps;
            long lastModified$iv = lastModified;
            boolean $i$f$zipEntry = false;
            ZipEntry $this$zipEntry_u24lambda_u240$iv = zipEntry2 = new ZipEntry((String)name$iv);
            boolean bl2 = false;
            if (preserveLastModified$iv != false) {
                if (lastModified$iv >= 0L) {
                    $this$zipEntry_u24lambda_u240$iv.setTime(lastModified$iv);
                }
            } else {
                $this$zipEntry_u24lambda_u240$iv.setTime(Companion.getCONSTANT_TIME_FOR_ZIP_ENTRIES());
            }
            ZipEntry $this$addDirs_u24addParent_u24lambda_u244 = $this$zipEntry_u24lambda_u240$iv;
            boolean bl3 = false;
            $this$addDirs_u24addParent_u24lambda_u244.setUnixMode(0x4000 | flag);
            ZipEntry entry = zipEntry2;
            $zos.putNextEntry(entry);
            $zos.closeEntry();
            ShadowCopyAction.addDirs$addParent(added, this$0, currentTimeMillis, $zos, parent);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/github/jengelman/gradle/plugins/shadow/tasks/ShadowCopyAction$Companion;", "", "<init>", "()V", "logger", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "CONSTANT_TIME_FOR_ZIP_ENTRIES", "", "getCONSTANT_TIME_FOR_ZIP_ENTRIES", "()J", "shadow"})
    public static final class Companion {
        private Companion() {
        }

        public final long getCONSTANT_TIME_FOR_ZIP_ENTRIES() {
            return CONSTANT_TIME_FOR_ZIP_ENTRIES;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\f\u0010\u0013\u001a\u00020\t*\u00020\u000eH\u0002J\u0018\u0010\u0014\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0012H\u0002J\u0014\u0010\u0016\u001a\u00020\t*\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/github/jengelman/gradle/plugins/shadow/tasks/ShadowCopyAction$StreamAction;", "Lorg/gradle/api/internal/file/CopyActionProcessingStreamAction;", "zipOutStr", "Lorg/apache/tools/zip/ZipOutputStream;", "<init>", "(Lcom/github/jengelman/gradle/plugins/shadow/tasks/ShadowCopyAction;Lorg/apache/tools/zip/ZipOutputStream;)V", "remapper", "Lcom/github/jengelman/gradle/plugins/shadow/internal/RelocatorRemapper;", "processFile", "", "details", "Lorg/gradle/api/internal/file/copy/FileCopyDetailsInternal;", "visitFile", "fileDetails", "Lorg/gradle/api/file/FileCopyDetails;", "isUnused", "", "classPath", "", "remapClass", "transform", "mapped", "writeToZip", "entryName", "shadow"})
    @SourceDebugExtension(value={"SMAP\nShadowCopyAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShadowCopyAction.kt\ncom/github/jengelman/gradle/plugins/shadow/tasks/ShadowCopyAction$StreamAction\n+ 2 Utils.kt\ncom/github/jengelman/gradle/plugins/shadow/internal/UtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,247:1\n41#2,10:248\n41#2,10:259\n1#3:258\n*S KotlinDebug\n*F\n+ 1 ShadowCopyAction.kt\ncom/github/jengelman/gradle/plugins/shadow/tasks/ShadowCopyAction$StreamAction\n*L\n200#1:248,10\n227#1:259,10\n*E\n"})
    private final class StreamAction
    implements CopyActionProcessingStreamAction {
        @NotNull
        private final ZipOutputStream zipOutStr;
        @NotNull
        private final RelocatorRemapper remapper;

        public StreamAction(ZipOutputStream zipOutStr) {
            Intrinsics.checkNotNullParameter((Object)zipOutStr, (String)"zipOutStr");
            this.zipOutStr = zipOutStr;
            this.remapper = new RelocatorRemapper(ShadowCopyAction.this.relocators);
            logger.info("Relocator count: " + ShadowCopyAction.this.relocators.size() + ".");
            if (ShadowCopyAction.this.encoding != null) {
                this.zipOutStr.setEncoding(ShadowCopyAction.this.encoding);
            }
        }

        public void processFile(@NotNull FileCopyDetailsInternal details) {
            Intrinsics.checkNotNullParameter((Object)details, (String)"details");
            try {
                if (details.isDirectory()) {
                    ShadowCopyAction.this.visitedDirs.put(details.getPath(), details);
                } else {
                    this.visitFile((FileCopyDetails)details);
                }
            }
            catch (Exception e) {
                throw new GradleException("Could not add " + details + " to ZIP '" + ShadowCopyAction.this.zipFile + "'.", (Throwable)e);
            }
        }

        private final void visitFile(FileCopyDetails fileDetails) {
            String path = fileDetails.getPath();
            Intrinsics.checkNotNull((Object)path);
            if (StringsKt.endsWith$default((String)path, (String)".class", (boolean)false, (int)2, null)) {
                if (this.isUnused(path)) {
                    return;
                }
                if (ShadowCopyAction.this.relocators.isEmpty()) {
                    this.writeToZip(fileDetails, path);
                    return;
                }
                this.remapClass(fileDetails);
            } else {
                String mapped = this.remapper.map(path);
                if (this.transform(fileDetails, mapped)) {
                    return;
                }
                this.writeToZip(fileDetails, mapped);
            }
        }

        private final boolean isUnused(String classPath) {
            boolean bl;
            String className = StringsKt.replace$default((String)StringsKt.substringBeforeLast$default((String)classPath, (String)".", null, (int)2, null), (char)'/', (char)'.', (boolean)false, (int)4, null);
            boolean it = bl = ShadowCopyAction.this.unusedClasses.contains(className);
            boolean bl2 = false;
            if (it) {
                logger.debug("Dropping unused class: " + className);
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private final void remapClass(FileCopyDetails $this$remapClass) {
            File file = $this$remapClass.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getFile(...)");
            Object object = file;
            object = new FileInputStream((File)object);
            ShadowCopyAction shadowCopyAction = ShadowCopyAction.this;
            Throwable throwable = null;
            try {
                FileInputStream inputStream = (FileInputStream)object;
                boolean bl = false;
                ClassWriter cw = new ClassWriter(0);
                ClassReader cr = new ClassReader((InputStream)inputStream);
                ClassRemapper cv = new ClassRemapper((ClassVisitor)cw, (Remapper)this.remapper);
                try {
                    cr.accept((ClassVisitor)cv, 8);
                }
                catch (Throwable t) {
                    throw new GradleException("Error in ASM processing class " + $this$remapClass.getPath(), t);
                }
                Regex regex = new Regex("^META-INF/versions/\\d+/");
                String string = $this$remapClass.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                MatchResult matchResult = Regex.find$default((Regex)regex, (CharSequence)string, (int)0, (int)2, null);
                String string2 = matchResult != null ? matchResult.getValue() : null;
                if (string2 == null) {
                    string2 = "";
                }
                String multiReleasePrefix = string2;
                String string3 = $this$remapClass.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getPath(...)");
                String newPath = StringsKt.replace$default((String)string3, (String)multiReleasePrefix, (String)"", (boolean)false, (int)4, null);
                String mappedName = multiReleasePrefix + this.remapper.mapPath(newPath);
                try {
                    void preserveLastModified$iv;
                    void name$iv;
                    ZipEntry zipEntry2;
                    String string4 = mappedName + ".class";
                    boolean bl2 = shadowCopyAction.preserveFileTimestamps;
                    long lastModified$iv = $this$remapClass.getLastModified();
                    boolean $i$f$zipEntry = false;
                    ZipEntry $this$zipEntry_u24lambda_u240$iv = zipEntry2 = new ZipEntry((String)name$iv);
                    boolean bl3 = false;
                    if (preserveLastModified$iv != false) {
                        if (lastModified$iv >= 0L) {
                            $this$zipEntry_u24lambda_u240$iv.setTime(lastModified$iv);
                        }
                    } else {
                        $this$zipEntry_u24lambda_u240$iv.setTime(Companion.getCONSTANT_TIME_FOR_ZIP_ENTRIES());
                    }
                    ZipEntry $this$remapClass_u24lambda_u242_u24lambda_u241 = $this$zipEntry_u24lambda_u240$iv;
                    boolean bl4 = false;
                    $this$remapClass_u24lambda_u242_u24lambda_u241.setUnixMode(0x8000 | $this$remapClass.getPermissions().toUnixNumeric());
                    ZipEntry entry = zipEntry2;
                    this.zipOutStr.putNextEntry(entry);
                    this.zipOutStr.write(cw.toByteArray());
                    this.zipOutStr.closeEntry();
                }
                catch (ZipException zipException) {
                    logger.warn("We have a duplicate " + mappedName + " in source project");
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final boolean transform(FileCopyDetails fileDetails, String mapped) {
            Object v0;
            Unit unit;
            Object object;
            block7: {
                object = ShadowCopyAction.this.transformers;
                unit = object.iterator();
                while (unit.hasNext()) {
                    Object t = unit.next();
                    ResourceTransformer it = (ResourceTransformer)t;
                    boolean bl = false;
                    if (!it.canTransformResource((FileTreeElement)fileDetails)) continue;
                    v0 = t;
                    break block7;
                }
                v0 = null;
            }
            ResourceTransformer resourceTransformer = v0;
            if (resourceTransformer == null) {
                return false;
            }
            ResourceTransformer transformer = resourceTransformer;
            File file = fileDetails.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getFile(...)");
            Object object2 = file;
            object2 = new FileInputStream((File)object2);
            ShadowCopyAction shadowCopyAction = ShadowCopyAction.this;
            object = null;
            try {
                FileInputStream inputStream = (FileInputStream)object2;
                boolean bl = false;
                transformer.transform(new TransformerContext(mapped, inputStream, shadowCopyAction.relocators));
                unit = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object2, (Throwable)object);
            }
            return true;
        }

        /*
         * WARNING - void declaration
         */
        private final void writeToZip(FileCopyDetails $this$writeToZip, String entryName) {
            void preserveLastModified$iv;
            void name$iv;
            ZipEntry zipEntry2;
            String string = entryName;
            boolean bl = ShadowCopyAction.this.preserveFileTimestamps;
            long lastModified$iv = $this$writeToZip.getLastModified();
            boolean $i$f$zipEntry = false;
            ZipEntry $this$zipEntry_u24lambda_u240$iv = zipEntry2 = new ZipEntry((String)name$iv);
            boolean bl2 = false;
            if (preserveLastModified$iv != false) {
                if (lastModified$iv >= 0L) {
                    $this$zipEntry_u24lambda_u240$iv.setTime(lastModified$iv);
                }
            } else {
                $this$zipEntry_u24lambda_u240$iv.setTime(Companion.getCONSTANT_TIME_FOR_ZIP_ENTRIES());
            }
            ZipEntry $this$writeToZip_u24lambda_u245 = $this$zipEntry_u24lambda_u240$iv;
            boolean bl3 = false;
            $this$writeToZip_u24lambda_u245.setUnixMode(0x8000 | $this$writeToZip.getPermissions().toUnixNumeric());
            ZipEntry entry = zipEntry2;
            this.zipOutStr.putNextEntry(entry);
            $this$writeToZip.copyTo((OutputStream)this.zipOutStr);
            this.zipOutStr.closeEntry();
        }
    }
}

