/*
 * Decompiled with CFR 0.152.
 */
package com.github.jengelman.gradle.plugins.shadow.relocation;

import com.github.jengelman.gradle.plugins.shadow.relocation.CacheableRelocator;
import com.github.jengelman.gradle.plugins.shadow.relocation.RelocateClassContext;
import com.github.jengelman.gradle.plugins.shadow.relocation.RelocatePathContext;
import com.github.jengelman.gradle.plugins.shadow.relocation.Relocator;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.codehaus.plexus.util.SelectorUtils;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@CacheableRelocator
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010#\n\u0002\b\u000b\n\u0002\u0010\"\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0017\u0018\u0000 02\u00020\u0001:\u00010BK\b\u0007\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0010\b\u0002\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0006\u0012\u0010\b\u0002\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010!\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\u0010\u0010\"\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\u0010\u0010#\u001a\u00020\t2\u0006\u0010$\u001a\u00020\u0003H\u0016J\u0010\u0010%\u001a\u00020\t2\u0006\u0010&\u001a\u00020\u0003H\u0016J\u0010\u0010'\u001a\u00020\u00032\u0006\u0010(\u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020\u00032\u0006\u0010(\u001a\u00020+H\u0016J\u0010\u0010,\u001a\u00020\u00032\u0006\u0010-\u001a\u00020\u0003H\u0016J\u0010\u0010.\u001a\u00020\t2\u0006\u0010$\u001a\u00020\u0003H\u0002J\u0010\u0010/\u001a\u00020\t2\u0006\u0010$\u001a\u00020\u0003H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u00038WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00038WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0014R\u0014\u0010\u0004\u001a\u00020\u00038WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0014R\u0014\u0010\u0018\u001a\u00020\u00038WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0014R\u0014\u0010\u001a\u001a\u00020\t8WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u001d8WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\u001d8WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u001f\u00a8\u00061"}, d2={"Lcom/github/jengelman/gradle/plugins/shadow/relocation/SimpleRelocator;", "Lcom/github/jengelman/gradle/plugins/shadow/relocation/Relocator;", "pattern", "", "shadedPattern", "includes", "", "excludes", "_rawString", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/util/List;Z)V", "_pattern", "_pathPattern", "_shadedPattern", "_shadedPathPattern", "_includes", "", "_excludes", "getPattern", "()Ljava/lang/String;", "pathPattern", "getPathPattern", "getShadedPattern", "shadedPathPattern", "getShadedPathPattern", "rawString", "getRawString", "()Z", "", "getIncludes", "()Ljava/util/Set;", "getExcludes", "include", "exclude", "canRelocatePath", "path", "canRelocateClass", "className", "relocatePath", "context", "Lcom/github/jengelman/gradle/plugins/shadow/relocation/RelocatePathContext;", "relocateClass", "Lcom/github/jengelman/gradle/plugins/shadow/relocation/RelocateClassContext;", "applyToSourceContent", "sourceContent", "isIncluded", "isExcluded", "Companion", "shadow"})
@SourceDebugExtension(value={"SMAP\nSimpleRelocator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimpleRelocator.kt\ncom/github/jengelman/gradle/plugins/shadow/relocation/SimpleRelocator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,160:1\n1755#2,3:161\n1755#2,3:164\n*S KotlinDebug\n*F\n+ 1 SimpleRelocator.kt\ncom/github/jengelman/gradle/plugins/shadow/relocation/SimpleRelocator\n*L\n132#1:161,3\n136#1:164,3\n*E\n"})
public class SimpleRelocator
implements Relocator {
    @NotNull
    private static final Companion Companion = new Companion(null);
    private final boolean _rawString;
    @NotNull
    private final String _pattern;
    @NotNull
    private final String _pathPattern;
    @NotNull
    private final String _shadedPattern;
    @NotNull
    private final String _shadedPathPattern;
    @NotNull
    private final Set<String> _includes;
    @NotNull
    private final Set<String> _excludes;

    @JvmOverloads
    public SimpleRelocator(@Nullable String pattern, @Nullable String shadedPattern, @Nullable List<String> includes, @Nullable List<String> excludes, boolean _rawString) {
        this._rawString = _rawString;
        this._includes = new LinkedHashSet();
        this._excludes = new LinkedHashSet();
        if (this._rawString) {
            String string;
            String string2 = pattern;
            if (string2 == null) {
                string2 = this._pathPattern = "";
            }
            if ((string = shadedPattern) == null) {
                string = "";
            }
            this._shadedPathPattern = string;
            this._pattern = "";
            this._shadedPattern = "";
        } else {
            if (pattern == null) {
                this._pattern = "";
                this._pathPattern = "";
            } else {
                this._pattern = StringsKt.replace$default((String)pattern, (char)'/', (char)'.', (boolean)false, (int)4, null);
                this._pathPattern = StringsKt.replace$default((String)pattern, (char)'.', (char)'/', (boolean)false, (int)4, null);
            }
            if (shadedPattern == null) {
                this._shadedPattern = "hidden." + this._pattern;
                this._shadedPathPattern = "hidden/" + this._pathPattern;
            } else {
                this._shadedPattern = StringsKt.replace$default((String)shadedPattern, (char)'/', (char)'.', (boolean)false, (int)4, null);
                this._shadedPathPattern = StringsKt.replace$default((String)shadedPattern, (char)'.', (char)'/', (boolean)false, (int)4, null);
            }
        }
        CollectionsKt.addAll((Collection)this._includes, (Iterable)Companion.normalizePatterns((Collection<String>)includes));
        CollectionsKt.addAll((Collection)this._excludes, (Iterable)Companion.normalizePatterns((Collection<String>)excludes));
    }

    public /* synthetic */ SimpleRelocator(String string, String string2, List list, List list2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            list = null;
        }
        if ((n & 8) != 0) {
            list2 = null;
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        this(string, string2, list, list2, bl);
    }

    @Input
    @Optional
    @NotNull
    public String getPattern() {
        return this._pattern;
    }

    @Input
    @NotNull
    public String getPathPattern() {
        return this._pathPattern;
    }

    @Input
    @Optional
    @NotNull
    public String getShadedPattern() {
        return this._shadedPattern;
    }

    @Input
    @NotNull
    public String getShadedPathPattern() {
        return this._shadedPathPattern;
    }

    @Input
    public boolean getRawString() {
        return this._rawString;
    }

    @Input
    @NotNull
    public Set<String> getIncludes() {
        return this._includes;
    }

    @Input
    @NotNull
    public Set<String> getExcludes() {
        return this._excludes;
    }

    @NotNull
    public SimpleRelocator include(@NotNull String pattern) {
        SimpleRelocator simpleRelocator;
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        SimpleRelocator $this$include_u24lambda_u240 = simpleRelocator = this;
        boolean bl = false;
        CollectionsKt.addAll((Collection)$this$include_u24lambda_u240._includes, (Iterable)Companion.normalizePatterns(CollectionsKt.listOf((Object)pattern)));
        return simpleRelocator;
    }

    @NotNull
    public SimpleRelocator exclude(@NotNull String pattern) {
        SimpleRelocator simpleRelocator;
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        SimpleRelocator $this$exclude_u24lambda_u241 = simpleRelocator = this;
        boolean bl = false;
        CollectionsKt.addAll((Collection)$this$exclude_u24lambda_u241._excludes, (Iterable)Companion.normalizePatterns(CollectionsKt.listOf((Object)pattern)));
        return simpleRelocator;
    }

    @Override
    public boolean canRelocatePath(@NotNull String path) {
        String string;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (this._rawString) {
            return Pattern.compile(this._pathPattern).matcher(path).find();
        }
        if (path.length() < this._pathPattern.length()) {
            return false;
        }
        if (StringsKt.endsWith$default((String)path, (String)".class", (boolean)false, (int)2, null)) {
            if (path.length() == 6) {
                return false;
            }
            string = StringsKt.dropLast((String)path, (int)6);
        } else {
            string = path;
        }
        String adjustedPath = string;
        int startIndex = StringsKt.startsWith$default((String)adjustedPath, (String)"/", (boolean)false, (int)2, null) ? 1 : 0;
        boolean pathStartsWithPattern = StringsKt.startsWith$default((String)adjustedPath, (String)this._pathPattern, (int)startIndex, (boolean)false, (int)4, null);
        return pathStartsWithPattern && this.isIncluded(adjustedPath) && !this.isExcluded(adjustedPath);
    }

    @Override
    public boolean canRelocateClass(@NotNull String className) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        return !this._rawString && !StringsKt.contains$default((CharSequence)className, (char)'/', (boolean)false, (int)2, null) && this.canRelocatePath(StringsKt.replace$default((String)className, (char)'.', (char)'/', (boolean)false, (int)4, null));
    }

    @Override
    @NotNull
    public String relocatePath(@NotNull RelocatePathContext context) {
        String string;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String path = context.getPath();
        context.getStats().relocate(this._pathPattern, this._shadedPathPattern);
        if (this._rawString) {
            CharSequence charSequence = path;
            Regex regex = new Regex(this._pathPattern);
            String string2 = this._shadedPathPattern;
            string = regex.replace(charSequence, string2);
        } else {
            string = StringsKt.replaceFirst$default((String)path, (String)this._pathPattern, (String)this._shadedPathPattern, (boolean)false, (int)4, null);
        }
        return string;
    }

    @Override
    @NotNull
    public String relocateClass(@NotNull RelocateClassContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        context.getStats().relocate(this._pathPattern, this._shadedPathPattern);
        return StringsKt.replaceFirst$default((String)context.getClassName(), (String)this._pattern, (String)this._shadedPattern, (boolean)false, (int)4, null);
    }

    @Override
    @NotNull
    public String applyToSourceContent(@NotNull String sourceContent) {
        String string;
        Intrinsics.checkNotNullParameter((Object)sourceContent, (String)"sourceContent");
        if (this._rawString) {
            string = sourceContent;
        } else {
            CharSequence charSequence = sourceContent;
            Regex regex = new Regex("\\b" + this._pattern);
            String string2 = this._shadedPattern;
            string = regex.replace(charSequence, string2);
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isIncluded(String path) {
        String it;
        if (this._includes.isEmpty()) return true;
        Iterable $this$any$iv = this._includes;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            it = (String)element$iv;
            boolean bl = false;
        } while (!SelectorUtils.matchPath((String)it, (String)path, (String)"/", (boolean)true));
        return true;
    }

    private final boolean isExcluded(String path) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this._excludes;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!SelectorUtils.matchPath((String)it, (String)path, (String)"/", (boolean)true)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @JvmOverloads
    public SimpleRelocator(@Nullable String pattern, @Nullable String shadedPattern, @Nullable List<String> includes, @Nullable List<String> excludes) {
        this(pattern, shadedPattern, includes, excludes, false, 16, null);
    }

    @JvmOverloads
    public SimpleRelocator(@Nullable String pattern, @Nullable String shadedPattern, @Nullable List<String> includes) {
        this(pattern, shadedPattern, includes, null, false, 24, null);
    }

    @JvmOverloads
    public SimpleRelocator(@Nullable String pattern, @Nullable String shadedPattern) {
        this(pattern, shadedPattern, null, null, false, 28, null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u000e\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\b\u00a8\u0006\t"}, d2={"Lcom/github/jengelman/gradle/plugins/shadow/relocation/SimpleRelocator$Companion;", "", "<init>", "()V", "normalizePatterns", "", "", "patterns", "", "shadow"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<String> normalizePatterns(@Nullable Collection<String> patterns) {
            Set set;
            Set $this$normalizePatterns_u24lambda_u240 = set = SetsKt.createSetBuilder();
            boolean bl = false;
            if (patterns != null) {
                for (String pattern : patterns) {
                    String packagePattern;
                    if (StringsKt.startsWith$default((String)pattern, (String)"%regex[", (boolean)false, (int)2, null)) {
                        $this$normalizePatterns_u24lambda_u240.add(pattern);
                        continue;
                    }
                    String classPattern = StringsKt.replace$default((String)pattern, (char)'.', (char)'/', (boolean)false, (int)4, null);
                    $this$normalizePatterns_u24lambda_u240.add(classPattern);
                    if (!StringsKt.endsWith$default((String)classPattern, (String)"/*", (boolean)false, (int)2, null)) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)classPattern.substring(0, StringsKt.lastIndexOf$default((CharSequence)classPattern, (char)'/', (int)0, (boolean)false, (int)6, null)), (String)"substring(...)");
                    $this$normalizePatterns_u24lambda_u240.add(packagePattern);
                }
            }
            return SetsKt.build((Set)set);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

