/*
 * Decompiled with CFR 0.152.
 */
package com.github.jengelman.gradle.plugins.shadow.transformers;

import com.github.jengelman.gradle.plugins.shadow.ShadowStats;
import com.github.jengelman.gradle.plugins.shadow.relocation.RelocateClassContext;
import com.github.jengelman.gradle.plugins.shadow.relocation.Relocator;
import com.github.jengelman.gradle.plugins.shadow.transformers.Transformer;
import com.github.jengelman.gradle.plugins.shadow.transformers.TransformerContext;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.XmlStreamWriter;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.Xpp3DomWriter;
import org.gradle.api.file.FileTreeElement;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0004\b\u0016\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\tH\u0016J\b\u0010\u0014\u001a\u00020\tH\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001a"}, d2={"Lcom/github/jengelman/gradle/plugins/shadow/transformers/ComponentsXmlResourceTransformer;", "Lcom/github/jengelman/gradle/plugins/shadow/transformers/Transformer;", "<init>", "()V", "components", "", "", "Lorg/codehaus/plexus/util/xml/Xpp3Dom;", "canTransformResource", "", "element", "Lorg/gradle/api/file/FileTreeElement;", "transform", "", "context", "Lcom/github/jengelman/gradle/plugins/shadow/transformers/TransformerContext;", "modifyOutputStream", "os", "Lorg/apache/tools/zip/ZipOutputStream;", "preserveFileTimestamps", "hasTransformedResource", "transformedResource", "", "getTransformedResource", "()[B", "Companion", "shadow"})
public class ComponentsXmlResourceTransformer
implements Transformer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, Xpp3Dom> components = new LinkedHashMap();
    @NotNull
    public static final String COMPONENTS_XML_PATH = "META-INF/plexus/components.xml";

    @Override
    public boolean canTransformResource(@NotNull FileTreeElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return Intrinsics.areEqual((Object)COMPONENTS_XML_PATH, (Object)element.getRelativePath().getPathString());
    }

    @Override
    public void transform(@NotNull TransformerContext context) {
        BufferedInputStream bis2;
        Object object;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            object = context.getInputStream();
            bis2 = new BufferedInputStream((InputStream)object){

                public void close() throws IOException {
                }
            };
            bis2 = Xpp3DomBuilder.build((Reader)((Reader)new XmlStreamReader((InputStream)bis2)));
        }
        catch (Exception e) {
            throw new IOException("Error parsing components.xml in " + context.getInputStream(), e);
        }
        BufferedInputStream newDom2 = bis2;
        if (newDom2.getChild("components") == null) {
            return;
        }
        Object[] children = newDom2.getChild("components").getChildren("component");
        object = ArrayIteratorKt.iterator((Object[])children);
        while (object.hasNext()) {
            Xpp3Dom component = (Xpp3Dom)object.next();
            Intrinsics.checkNotNull((Object)component);
            String role = ComponentsXmlResourceTransformer.Companion.getValue(component, "role");
            role = ComponentsXmlResourceTransformer.Companion.getRelocatedClass(role, context);
            ComponentsXmlResourceTransformer.Companion.setValue(component, "role", role);
            String roleHint = ComponentsXmlResourceTransformer.Companion.getValue(component, "role-hint");
            String impl = ComponentsXmlResourceTransformer.Companion.getValue(component, "implementation");
            impl = ComponentsXmlResourceTransformer.Companion.getRelocatedClass(impl, context);
            ComponentsXmlResourceTransformer.Companion.setValue(component, "implementation", impl);
            String key = role + ':' + roleHint;
            Xpp3Dom xpp3Dom = this.components.get(key);
            if (xpp3Dom != null && (xpp3Dom = xpp3Dom.getChild("configuration")) != null) {
                Xpp3Dom it = xpp3Dom;
                boolean bl = false;
                component.addChild(it);
            }
            Xpp3Dom requirements = component.getChild("requirements");
            if (requirements != null && requirements.getChildCount() > 0) {
                for (int r = requirements.getChildCount() - 1; -1 < r; --r) {
                    Xpp3Dom requirement = requirements.getChild(r);
                    Intrinsics.checkNotNull((Object)requirement);
                    String requiredRole = ComponentsXmlResourceTransformer.Companion.getValue(requirement, "role");
                    requiredRole = ComponentsXmlResourceTransformer.Companion.getRelocatedClass(requiredRole, context);
                    ComponentsXmlResourceTransformer.Companion.setValue(requirement, "role", requiredRole);
                }
            }
            this.components.put(key, component);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modifyOutputStream(@NotNull ZipOutputStream os, boolean preserveFileTimestamps) {
        Intrinsics.checkNotNullParameter((Object)os, (String)"os");
        ZipEntry entry = new ZipEntry(COMPONENTS_XML_PATH);
        entry.setTime(TransformerContext.Companion.getEntryTimestamp(preserveFileTimestamps, entry.getTime()));
        os.putNextEntry(entry);
        Closeable closeable = new ByteArrayInputStream(this.getTransformedResource());
        Throwable throwable = null;
        try {
            ByteArrayInputStream it = (ByteArrayInputStream)closeable;
            boolean bl = false;
            long l = ByteStreamsKt.copyTo$default((InputStream)it, (OutputStream)((OutputStream)os), (int)0, (int)2, null);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        this.components.clear();
    }

    @Override
    public boolean hasTransformedResource() {
        return !this.components.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final byte[] getTransformedResource() throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream(4096);
        Closeable closeable = (Closeable)new XmlStreamWriter((OutputStream)os);
        Throwable throwable = null;
        try {
            XmlStreamWriter writer = (XmlStreamWriter)closeable;
            boolean bl = false;
            Xpp3Dom dom = new Xpp3Dom("component-set");
            Xpp3Dom componentDom = new Xpp3Dom("components");
            dom.addChild(componentDom);
            for (Xpp3Dom component : this.components.values()) {
                componentDom.addChild(component);
            }
            Xpp3DomWriter.write((Writer)((Writer)writer), (Xpp3Dom)dom);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        byte[] byArray = os.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        return byArray;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0005H\u0002J\"\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00052\b\u0010\u0010\u001a\u0004\u0018\u00010\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/github/jengelman/gradle/plugins/shadow/transformers/ComponentsXmlResourceTransformer$Companion;", "", "<init>", "()V", "COMPONENTS_XML_PATH", "", "getRelocatedClass", "className", "context", "Lcom/github/jengelman/gradle/plugins/shadow/transformers/TransformerContext;", "getValue", "dom", "Lorg/codehaus/plexus/util/xml/Xpp3Dom;", "element", "setValue", "", "value", "shadow"})
    public static final class Companion {
        private Companion() {
        }

        private final String getRelocatedClass(String className, TransformerContext context) {
            ShadowStats stats = context.getStats();
            CharSequence charSequence = className;
            if (!(charSequence == null || charSequence.length() == 0)) {
                for (Relocator relocator : context.getRelocators()) {
                    if (!relocator.canRelocateClass(className)) continue;
                    RelocateClassContext relocateClassContext = new RelocateClassContext(className, stats);
                    return relocator.relocateClass(relocateClassContext);
                }
            }
            return className;
        }

        private final String getValue(Xpp3Dom dom, String element) {
            String string = dom.getChild(element).getValue();
            if (string == null) {
                string = "";
            }
            return string;
        }

        private final void setValue(Xpp3Dom dom, String element, String value) {
            CharSequence charSequence;
            Xpp3Dom child = dom.getChild(element);
            if (child == null || (charSequence = (CharSequence)value) == null || charSequence.length() == 0) {
                return;
            }
            child.setValue(value);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

