/*
 * Decompiled with CFR 0.152.
 */
package com.github.jengelman.gradle.plugins.shadow.transformers;

import com.github.jengelman.gradle.plugins.shadow.transformers.CacheableTransformer;
import com.github.jengelman.gradle.plugins.shadow.transformers.Transformer;
import com.github.jengelman.gradle.plugins.shadow.transformers.TransformerContext;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;
import org.gradle.api.file.FileTreeElement;
import org.jetbrains.annotations.NotNull;

@CacheableTransformer
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J,\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\f0\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0007H\u0016J\u0018\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0007H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/github/jengelman/gradle/plugins/shadow/transformers/GroovyExtensionModuleTransformer;", "Lcom/github/jengelman/gradle/plugins/shadow/transformers/Transformer;", "<init>", "()V", "module", "Ljava/util/Properties;", "legacy", "", "canTransformResource", "element", "Lorg/gradle/api/file/FileTreeElement;", "transform", "", "context", "Lcom/github/jengelman/gradle/plugins/shadow/transformers/TransformerContext;", "handle", "key", "", "value", "mergeValue", "Lkotlin/Function1;", "hasTransformedResource", "modifyOutputStream", "os", "Lorg/apache/tools/zip/ZipOutputStream;", "preserveFileTimestamps", "Companion", "shadow"})
public class GroovyExtensionModuleTransformer
implements Transformer {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Properties module = new Properties();
    private boolean legacy = true;
    @NotNull
    private static final String GROOVY_LEGACY_EXTENSION_MODULE_DESCRIPTOR_PATH = "META-INF/services/org.codehaus.groovy.runtime.ExtensionModule";
    @NotNull
    private static final String GROOVY_EXTENSION_MODULE_DESCRIPTOR_PATH = "META-INF/groovy/org.codehaus.groovy.runtime.ExtensionModule";
    @NotNull
    private static final String MODULE_NAME_KEY = "moduleName";
    @NotNull
    private static final String MODULE_VERSION_KEY = "moduleVersion";
    @NotNull
    private static final String EXTENSION_CLASSES_KEY = "extensionClasses";
    @NotNull
    private static final String STATIC_EXTENSION_CLASSES_KEY = "staticExtensionClasses";
    @NotNull
    private static final String MERGED_MODULE_NAME = "MergedByShadowJar";
    @NotNull
    private static final String MERGED_MODULE_VERSION = "1.0.0";

    @Override
    public boolean canTransformResource(@NotNull FileTreeElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        String path = element.getRelativePath().getPathString();
        if (Intrinsics.areEqual((Object)path, (Object)GROOVY_EXTENSION_MODULE_DESCRIPTOR_PATH)) {
            this.legacy = false;
            return true;
        }
        return Intrinsics.areEqual((Object)path, (Object)GROOVY_LEGACY_EXTENSION_MODULE_DESCRIPTOR_PATH);
    }

    @Override
    public void transform(@NotNull TransformerContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Properties props = new Properties();
        props.load(context.getInputStream());
        props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(arg_0, arg_1) -> GroovyExtensionModuleTransformer.transform$lambda$3(this, arg_0, arg_1)));
    }

    private final void handle(String key, String value, Function1<? super String, Unit> mergeValue) {
        String existingValue = this.module.getProperty(key);
        if (existingValue != null) {
            mergeValue.invoke((Object)existingValue);
        } else {
            this.module.setProperty(key, value);
        }
    }

    @Override
    public boolean hasTransformedResource() {
        return !((Map)this.module).isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modifyOutputStream(@NotNull ZipOutputStream os, boolean preserveFileTimestamps) {
        Intrinsics.checkNotNullParameter((Object)os, (String)"os");
        String name = this.legacy ? GROOVY_LEGACY_EXTENSION_MODULE_DESCRIPTOR_PATH : GROOVY_EXTENSION_MODULE_DESCRIPTOR_PATH;
        ZipEntry entry = new ZipEntry(name);
        entry.setTime(TransformerContext.Companion.getEntryTimestamp(preserveFileTimestamps, entry.getTime()));
        os.putNextEntry(entry);
        Closeable closeable = GroovyExtensionModuleTransformer.Companion.inputStream(this.module);
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl = false;
            long l = ByteStreamsKt.copyTo$default((InputStream)it, (OutputStream)((OutputStream)os), (int)0, (int)2, null);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        os.closeEntry();
    }

    private static final Unit transform$lambda$3$lambda$0(GroovyExtensionModuleTransformer this$0, Object $key, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.module.setProperty((String)$key, MERGED_MODULE_NAME);
        return Unit.INSTANCE;
    }

    private static final Unit transform$lambda$3$lambda$1(GroovyExtensionModuleTransformer this$0, Object $key, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.module.setProperty((String)$key, MERGED_MODULE_VERSION);
        return Unit.INSTANCE;
    }

    private static final Unit transform$lambda$3$lambda$2(GroovyExtensionModuleTransformer this$0, Object $key, Object $value, String existingValue) {
        Intrinsics.checkNotNullParameter((Object)existingValue, (String)"existingValue");
        this$0.module.setProperty((String)$key, existingValue + ',' + (String)$value);
        return Unit.INSTANCE;
    }

    private static final void transform$lambda$3(GroovyExtensionModuleTransformer this$0, Object key, Object value) {
        Intrinsics.checkNotNull((Object)key, (String)"null cannot be cast to non-null type kotlin.String");
        switch ((String)key) {
            case "moduleName": {
                String string = (String)key;
                Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.String");
                this$0.handle(string, (String)value, (Function1<? super String, Unit>)((Function1)arg_0 -> GroovyExtensionModuleTransformer.transform$lambda$3$lambda$0(this$0, key, arg_0)));
                break;
            }
            case "moduleVersion": {
                String string = (String)key;
                Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.String");
                this$0.handle(string, (String)value, (Function1<? super String, Unit>)((Function1)arg_0 -> GroovyExtensionModuleTransformer.transform$lambda$3$lambda$1(this$0, key, arg_0)));
                break;
            }
            case "staticExtensionClasses": 
            case "extensionClasses": {
                String string = (String)key;
                Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.String");
                this$0.handle(string, (String)value, (Function1<? super String, Unit>)((Function1)arg_0 -> GroovyExtensionModuleTransformer.transform$lambda$3$lambda$2(this$0, key, value, arg_0)));
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\u00020\u0005*\u00020\u0006H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/github/jengelman/gradle/plugins/shadow/transformers/GroovyExtensionModuleTransformer$Companion;", "", "<init>", "()V", "inputStream", "Ljava/io/InputStream;", "Ljava/util/Properties;", "GROOVY_LEGACY_EXTENSION_MODULE_DESCRIPTOR_PATH", "", "GROOVY_EXTENSION_MODULE_DESCRIPTOR_PATH", "MODULE_NAME_KEY", "MODULE_VERSION_KEY", "EXTENSION_CLASSES_KEY", "STATIC_EXTENSION_CLASSES_KEY", "MERGED_MODULE_NAME", "MERGED_MODULE_VERSION", "shadow"})
    private static final class Companion {
        private Companion() {
        }

        private final InputStream inputStream(Properties $this$inputStream) {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            $this$inputStream.store(os, null);
            return new ByteArrayInputStream(os.toByteArray());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

