/*
 * Decompiled with CFR 0.152.
 */
package com.github.jengelman.gradle.plugins.shadow;

import com.github.jengelman.gradle.plugins.shadow.internal.UtilsKt;
import com.github.jengelman.gradle.plugins.shadow.tasks.JavaJarExec;
import com.github.jengelman.gradle.plugins.shadow.tasks.ShadowJar;
import java.io.File;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.distribution.Distribution;
import org.gradle.api.distribution.DistributionContainer;
import org.gradle.api.file.ConfigurableFilePermissions;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileCopyDetails;
import org.gradle.api.file.RegularFile;
import org.gradle.api.internal.TaskInputsInternal;
import org.gradle.api.java.archives.Attributes;
import org.gradle.api.plugins.JavaApplication;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Sync;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.application.CreateStartScripts;
import org.gradle.jvm.application.scripts.ScriptGenerator;
import org.gradle.jvm.application.scripts.TemplateBasedScriptGenerator;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.gradle.jvm.toolchain.JavaToolchainSpec;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 \u00142\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0002H\u0016J\b\u0010\n\u001a\u00020\tH\u0014J\b\u0010\u000b\u001a\u00020\tH\u0014J\b\u0010\f\u001a\u00020\tH\u0014J\b\u0010\r\u001a\u00020\tH\u0014J\b\u0010\u000e\u001a\u00020\tH\u0014R\u000e\u0010\u0005\u001a\u00020\u0002X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00108DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0015"}, d2={"Lcom/github/jengelman/gradle/plugins/shadow/ShadowApplicationPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "<init>", "()V", "project", "javaApplication", "Lorg/gradle/api/plugins/JavaApplication;", "apply", "", "configureJarMainClass", "addRunTask", "addCreateScriptsTask", "configureInstallTask", "configureDistSpec", "shadowJar", "Lorg/gradle/api/tasks/TaskProvider;", "Lcom/github/jengelman/gradle/plugins/shadow/tasks/ShadowJar;", "getShadowJar", "()Lorg/gradle/api/tasks/TaskProvider;", "Companion", "shadow"})
public abstract class ShadowApplicationPlugin
implements Plugin<Project> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private Project project;
    private JavaApplication javaApplication;
    @NotNull
    public static final String SHADOW_RUN_TASK_NAME = "runShadow";
    @NotNull
    public static final String SHADOW_SCRIPTS_TASK_NAME = "startShadowScripts";
    @NotNull
    public static final String SHADOW_INSTALL_TASK_NAME = "installShadowDist";

    public void apply(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.javaApplication = (JavaApplication)project.getExtensions().getByType(JavaApplication.class);
        this.addRunTask();
        this.addCreateScriptsTask();
        this.configureDistSpec();
        this.configureJarMainClass();
        this.configureInstallTask();
    }

    protected void configureJarMainClass() {
        JavaApplication javaApplication = this.javaApplication;
        if (javaApplication == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"javaApplication");
            javaApplication = null;
        }
        Property classNameProvider = javaApplication.getMainClass();
        this.getShadowJar().configure(arg_0 -> ShadowApplicationPlugin.configureJarMainClass$lambda$3(arg_0 -> ShadowApplicationPlugin.configureJarMainClass$lambda$2(classNameProvider, arg_0), arg_0));
    }

    protected void addRunTask() {
        Project project = this.project;
        if (project == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"project");
            project = null;
        }
        project.getTasks().register(SHADOW_RUN_TASK_NAME, JavaJarExec.class, arg_0 -> ShadowApplicationPlugin.addRunTask$lambda$8(arg_0 -> ShadowApplicationPlugin.addRunTask$lambda$7(this, arg_0), arg_0));
    }

    protected void addCreateScriptsTask() {
        Project project = this.project;
        if (project == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"project");
            project = null;
        }
        project.getTasks().register(SHADOW_SCRIPTS_TASK_NAME, CreateStartScripts.class, arg_0 -> ShadowApplicationPlugin.addCreateScriptsTask$lambda$13(arg_0 -> ShadowApplicationPlugin.addCreateScriptsTask$lambda$12(this, arg_0), arg_0));
    }

    protected void configureInstallTask() {
        Project project = this.project;
        if (project == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"project");
            project = null;
        }
        project.getTasks().named(SHADOW_INSTALL_TASK_NAME, Sync.class).configure(arg_0 -> ShadowApplicationPlugin.configureInstallTask$lambda$24(arg_0 -> ShadowApplicationPlugin.configureInstallTask$lambda$23(this, arg_0), arg_0));
    }

    protected void configureDistSpec() {
        Project project = this.project;
        if (project == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"project");
            project = null;
        }
        ((DistributionContainer)project.getExtensions().getByType(DistributionContainer.class)).register("shadow", arg_0 -> ShadowApplicationPlugin.configureDistSpec$lambda$34(arg_0 -> ShadowApplicationPlugin.configureDistSpec$lambda$33(this, arg_0), arg_0));
    }

    @NotNull
    protected final TaskProvider<ShadowJar> getShadowJar() {
        Project project = this.project;
        if (project == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"project");
            project = null;
        }
        TaskProvider taskProvider = project.getTasks().named("shadowJar", ShadowJar.class);
        Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"named(...)");
        return taskProvider;
    }

    private static final Unit configureJarMainClass$lambda$2$lambda$0(ShadowJar $jar, Property $classNameProvider, Task it) {
        Attributes attributes = $jar.getManifest().getAttributes();
        Intrinsics.checkNotNullExpressionValue((Object)attributes, (String)"getAttributes(...)");
        Map map = (Map)attributes;
        String string = "Main-Class";
        Object object = $classNameProvider.get();
        map.put(string, object);
        return Unit.INSTANCE;
    }

    private static final void configureJarMainClass$lambda$2$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit configureJarMainClass$lambda$2(Property $classNameProvider, ShadowJar jar) {
        jar.getInputs().property("mainClassName", (Object)$classNameProvider);
        jar.doFirst(arg_0 -> ShadowApplicationPlugin.configureJarMainClass$lambda$2$lambda$1(arg_0 -> ShadowApplicationPlugin.configureJarMainClass$lambda$2$lambda$0(jar, $classNameProvider, arg_0), arg_0));
        return Unit.INSTANCE;
    }

    private static final void configureJarMainClass$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Object addRunTask$lambda$7$lambda$4(ShadowApplicationPlugin this$0) {
        JavaApplication javaApplication = this$0.javaApplication;
        if (javaApplication == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"javaApplication");
            javaApplication = null;
        }
        return javaApplication.getApplicationDefaultJvmArgs();
    }

    private static final File addRunTask$lambda$7$lambda$5(ShadowApplicationPlugin this$0, Sync i, ShadowJar s) {
        Project project = this$0.project;
        if (project == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"project");
            project = null;
        }
        return project.file((Object)(i.getDestinationDir().getPath() + "/lib/" + ((RegularFile)s.getArchiveFile().get()).getAsFile().getName()));
    }

    private static final File addRunTask$lambda$7$lambda$6(Function2 $tmp0, Object p0, Object p1) {
        return (File)$tmp0.invoke(p0, p1);
    }

    private static final Unit addRunTask$lambda$7(ShadowApplicationPlugin this$0, JavaJarExec it) {
        Project project = this$0.project;
        if (project == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"project");
            project = null;
        }
        TaskProvider install = project.getTasks().named(SHADOW_INSTALL_TASK_NAME, Sync.class);
        Object[] objectArray = new Object[]{install};
        it.dependsOn(objectArray);
        it.getMainClass().set((Object)"-jar");
        it.setDescription("Runs this project as a JVM application using the shadow jar");
        it.setGroup("application");
        it.getConventionMapping().map("jvmArgs", () -> ShadowApplicationPlugin.addRunTask$lambda$7$lambda$4(this$0));
        it.getJarFile().fileProvider(install.zip((Provider)this$0.getShadowJar(), (arg_0, arg_1) -> ShadowApplicationPlugin.addRunTask$lambda$7$lambda$6((arg_0, arg_1) -> ShadowApplicationPlugin.addRunTask$lambda$7$lambda$5(this$0, arg_0, arg_1), arg_0, arg_1)));
        Project project2 = this$0.project;
        if (project2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"project");
            project2 = null;
        }
        JavaToolchainSpec toolchain = ((JavaPluginExtension)project2.getExtensions().getByType(JavaPluginExtension.class)).getToolchain();
        Project project3 = this$0.project;
        if (project3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"project");
            project3 = null;
        }
        Provider defaultLauncher = ((JavaToolchainService)project3.getExtensions().getByType(JavaToolchainService.class)).launcherFor(toolchain);
        it.getJavaLauncher().set(defaultLauncher);
        return Unit.INSTANCE;
    }

    private static final void addRunTask$lambda$8(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Object addCreateScriptsTask$lambda$12$lambda$9(ShadowApplicationPlugin this$0) {
        JavaApplication javaApplication = this$0.javaApplication;
        if (javaApplication == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"javaApplication");
            javaApplication = null;
        }
        return javaApplication.getApplicationName();
    }

    private static final Object addCreateScriptsTask$lambda$12$lambda$10(ShadowApplicationPlugin this$0) {
        Project project = this$0.project;
        if (project == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"project");
            project = null;
        }
        return ((Directory)project.getLayout().getBuildDirectory().dir("scriptsShadow").get()).getAsFile();
    }

    private static final Object addCreateScriptsTask$lambda$12$lambda$11(ShadowApplicationPlugin this$0) {
        JavaApplication javaApplication = this$0.javaApplication;
        if (javaApplication == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"javaApplication");
            javaApplication = null;
        }
        return javaApplication.getApplicationDefaultJvmArgs();
    }

    private static final Unit addCreateScriptsTask$lambda$12(ShadowApplicationPlugin this$0, CreateStartScripts it) {
        ScriptGenerator scriptGenerator = it.getUnixStartScriptGenerator();
        Intrinsics.checkNotNull((Object)scriptGenerator, (String)"null cannot be cast to non-null type org.gradle.jvm.application.scripts.TemplateBasedScriptGenerator");
        TemplateBasedScriptGenerator templateBasedScriptGenerator = (TemplateBasedScriptGenerator)scriptGenerator;
        Project project = this$0.project;
        if (project == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"project");
            project = null;
        }
        templateBasedScriptGenerator.setTemplate(project.getResources().getText().fromString(UtilsKt.requireResourceAsText(this$0.getClass(), "internal/unixStartScript.txt")));
        ScriptGenerator scriptGenerator2 = it.getWindowsStartScriptGenerator();
        Intrinsics.checkNotNull((Object)scriptGenerator2, (String)"null cannot be cast to non-null type org.gradle.jvm.application.scripts.TemplateBasedScriptGenerator");
        TemplateBasedScriptGenerator templateBasedScriptGenerator2 = (TemplateBasedScriptGenerator)scriptGenerator2;
        Project project2 = this$0.project;
        if (project2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"project");
            project2 = null;
        }
        templateBasedScriptGenerator2.setTemplate(project2.getResources().getText().fromString(UtilsKt.requireResourceAsText(this$0.getClass(), "internal/windowsStartScript.txt")));
        it.setDescription("Creates OS specific scripts to run the project as a JVM application using the shadow jar");
        it.setGroup("application");
        Project project3 = this$0.project;
        if (project3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"project");
            project3 = null;
        }
        Object[] objectArray = new Object[]{this$0.getShadowJar()};
        it.setClasspath((FileCollection)project3.files(objectArray));
        Property property = it.getMainClass();
        JavaApplication javaApplication = this$0.javaApplication;
        if (javaApplication == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"javaApplication");
            javaApplication = null;
        }
        property.set((Provider)javaApplication.getMainClass());
        it.getConventionMapping().map("applicationName", () -> ShadowApplicationPlugin.addCreateScriptsTask$lambda$12$lambda$9(this$0));
        it.getConventionMapping().map("outputDir", () -> ShadowApplicationPlugin.addCreateScriptsTask$lambda$12$lambda$10(this$0));
        it.getConventionMapping().map("defaultJvmOpts", () -> ShadowApplicationPlugin.addCreateScriptsTask$lambda$12$lambda$11(this$0));
        TaskInputsInternal taskInputsInternal = it.getInputs();
        objectArray = new Object[1];
        Project project4 = this$0.project;
        if (project4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"project");
            project4 = null;
        }
        Object[] objectArray2 = new Object[]{this$0.getShadowJar()};
        objectArray[0] = project4.files(objectArray2);
        taskInputsInternal.files(objectArray);
        return Unit.INSTANCE;
    }

    private static final void addCreateScriptsTask$lambda$13(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final String configureInstallTask$lambda$23$lambda$14(ShadowApplicationPlugin this$0) {
        JavaApplication javaApplication = this$0.javaApplication;
        if (javaApplication == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"javaApplication");
            javaApplication = null;
        }
        return javaApplication.getApplicationName();
    }

    private static final Unit configureInstallTask$lambda$23$lambda$15(Sync $task, Provider $applicationName, Task it) {
        block2: {
            block3: {
                File[] fileArray = $task.getDestinationDir().listFiles();
                if (fileArray == null || fileArray.length == 0) break block2;
                File file = $task.getDestinationDir();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getDestinationDir(...)");
                if (!FilesKt.resolve((File)file, (String)"lib").isDirectory()) break block3;
                File file2 = $task.getDestinationDir();
                Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"getDestinationDir(...)");
                if (FilesKt.resolve((File)file2, (String)"bin").isDirectory()) break block2;
            }
            throw new GradleException("The specified installation directory '" + $task.getDestinationDir() + "' is neither empty nor does it contain an installation for '" + (String)$applicationName.get() + "'.\nIf you really want to install to this directory, delete it and run the install task again.\nAlternatively, choose a different installation directory.");
        }
        return Unit.INSTANCE;
    }

    private static final void configureInstallTask$lambda$23$lambda$16(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit configureInstallTask$lambda$23$lambda$21$lambda$19$lambda$17(ConfigurableFilePermissions permissions) {
        permissions.unix(755);
        return Unit.INSTANCE;
    }

    private static final void configureInstallTask$lambda$23$lambda$21$lambda$19$lambda$18(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit configureInstallTask$lambda$23$lambda$21$lambda$19(Provider $applicationName, FileCopyDetails it) {
        if (Intrinsics.areEqual((Object)it.getPath(), (Object)("bin/" + (String)$applicationName.get()))) {
            it.permissions(arg_0 -> ShadowApplicationPlugin.configureInstallTask$lambda$23$lambda$21$lambda$19$lambda$18(ShadowApplicationPlugin::configureInstallTask$lambda$23$lambda$21$lambda$19$lambda$17, arg_0));
        }
        return Unit.INSTANCE;
    }

    private static final void configureInstallTask$lambda$23$lambda$21$lambda$20(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit configureInstallTask$lambda$23$lambda$21(Sync $task, Provider $applicationName, Task it) {
        $task.eachFile(arg_0 -> ShadowApplicationPlugin.configureInstallTask$lambda$23$lambda$21$lambda$20(arg_0 -> ShadowApplicationPlugin.configureInstallTask$lambda$23$lambda$21$lambda$19($applicationName, arg_0), arg_0));
        return Unit.INSTANCE;
    }

    private static final void configureInstallTask$lambda$23$lambda$22(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit configureInstallTask$lambda$23(ShadowApplicationPlugin this$0, Sync task) {
        Project project = this$0.project;
        if (project == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"project");
            project = null;
        }
        Provider applicationName = project.getProviders().provider(() -> ShadowApplicationPlugin.configureInstallTask$lambda$23$lambda$14(this$0));
        task.doFirst(arg_0 -> ShadowApplicationPlugin.configureInstallTask$lambda$23$lambda$16(arg_0 -> ShadowApplicationPlugin.configureInstallTask$lambda$23$lambda$15(task, applicationName, arg_0), arg_0));
        task.doLast(arg_0 -> ShadowApplicationPlugin.configureInstallTask$lambda$23$lambda$22(arg_0 -> ShadowApplicationPlugin.configureInstallTask$lambda$23$lambda$21(task, applicationName, arg_0), arg_0));
        return Unit.INSTANCE;
    }

    private static final void configureInstallTask$lambda$24(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit configureDistSpec$lambda$33$lambda$31$lambda$25(ShadowApplicationPlugin this$0, CopySpec lib) {
        Object[] objectArray = new Object[]{this$0.getShadowJar()};
        lib.from(objectArray);
        objectArray = new Object[1];
        Project project = this$0.project;
        if (project == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"project");
            project = null;
        }
        objectArray[0] = project.getConfigurations().named("shadow");
        lib.from(objectArray);
        return Unit.INSTANCE;
    }

    private static final void configureDistSpec$lambda$33$lambda$31$lambda$26(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit configureDistSpec$lambda$33$lambda$31$lambda$29$lambda$27(ConfigurableFilePermissions it) {
        it.unix(493);
        return Unit.INSTANCE;
    }

    private static final void configureDistSpec$lambda$33$lambda$31$lambda$29$lambda$28(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit configureDistSpec$lambda$33$lambda$31$lambda$29(ShadowApplicationPlugin this$0, CopySpec bin) {
        Object[] objectArray = new Object[1];
        Project project = this$0.project;
        if (project == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"project");
            project = null;
        }
        objectArray[0] = project.getTasks().named(SHADOW_SCRIPTS_TASK_NAME);
        bin.from(objectArray);
        bin.filePermissions(arg_0 -> ShadowApplicationPlugin.configureDistSpec$lambda$33$lambda$31$lambda$29$lambda$28(ShadowApplicationPlugin::configureDistSpec$lambda$33$lambda$31$lambda$29$lambda$27, arg_0));
        return Unit.INSTANCE;
    }

    private static final void configureDistSpec$lambda$33$lambda$31$lambda$30(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit configureDistSpec$lambda$33$lambda$31(ShadowApplicationPlugin this$0, CopySpec contents) {
        Object[] objectArray = new Object[1];
        Project project = this$0.project;
        if (project == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"project");
            project = null;
        }
        objectArray[0] = project.file((Object)"src/dist");
        contents.from(objectArray);
        contents.into((Object)"lib", arg_0 -> ShadowApplicationPlugin.configureDistSpec$lambda$33$lambda$31$lambda$26(arg_0 -> ShadowApplicationPlugin.configureDistSpec$lambda$33$lambda$31$lambda$25(this$0, arg_0), arg_0));
        contents.into((Object)"bin", arg_0 -> ShadowApplicationPlugin.configureDistSpec$lambda$33$lambda$31$lambda$30(arg_0 -> ShadowApplicationPlugin.configureDistSpec$lambda$33$lambda$31$lambda$29(this$0, arg_0), arg_0));
        return Unit.INSTANCE;
    }

    private static final void configureDistSpec$lambda$33$lambda$32(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit configureDistSpec$lambda$33(ShadowApplicationPlugin this$0, Distribution distributions) {
        distributions.contents(arg_0 -> ShadowApplicationPlugin.configureDistSpec$lambda$33$lambda$32(arg_0 -> ShadowApplicationPlugin.configureDistSpec$lambda$33$lambda$31(this$0, arg_0), arg_0));
        return Unit.INSTANCE;
    }

    private static final void configureDistSpec$lambda$34(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/github/jengelman/gradle/plugins/shadow/ShadowApplicationPlugin$Companion;", "", "<init>", "()V", "SHADOW_RUN_TASK_NAME", "", "SHADOW_SCRIPTS_TASK_NAME", "SHADOW_INSTALL_TASK_NAME", "shadow"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

