/*
 * Decompiled with CFR 0.152.
 */
package com.github.jengelman.gradle.plugins.shadow.relocation;

import com.github.jengelman.gradle.plugins.shadow.relocation.CacheableRelocator;
import com.github.jengelman.gradle.plugins.shadow.relocation.RelocateClassContext;
import com.github.jengelman.gradle.plugins.shadow.relocation.RelocatePathContext;
import com.github.jengelman.gradle.plugins.shadow.relocation.Relocator;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.codehaus.plexus.util.SelectorUtils;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.tasks.Input;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@CacheableRelocator
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0017\u0018\u0000 #2\u00020\u0001:\u0001#BW\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\u0010\b\u0002\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\b\u0012\u0010\b\u0002\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\b\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0005H\u0016J\u0010\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u0005H\u0016J\u0010\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u0005H\u0016J\u0010\u0010!\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0005H\u0002J\u0010\u0010\"\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0005H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\u00108G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0019\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\u00108G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012\u00a8\u0006$"}, d2={"Lcom/github/jengelman/gradle/plugins/shadow/relocation/SimpleRelocator;", "Lcom/github/jengelman/gradle/plugins/shadow/relocation/Relocator;", "objectFactory", "Lorg/gradle/api/model/ObjectFactory;", "pattern", "", "shadedPattern", "includes", "", "excludes", "rawString", "", "<init>", "(Lorg/gradle/api/model/ObjectFactory;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/util/List;Z)V", "pathPattern", "shadedPathPattern", "Lorg/gradle/api/provider/SetProperty;", "getIncludes", "()Lorg/gradle/api/provider/SetProperty;", "getExcludes", "include", "exclude", "canRelocatePath", "path", "canRelocateClass", "className", "relocatePath", "context", "Lcom/github/jengelman/gradle/plugins/shadow/relocation/RelocatePathContext;", "relocateClass", "Lcom/github/jengelman/gradle/plugins/shadow/relocation/RelocateClassContext;", "applyToSourceContent", "sourceContent", "isIncluded", "isExcluded", "Companion", "shadow"})
@SourceDebugExtension(value={"SMAP\nSimpleRelocator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimpleRelocator.kt\ncom/github/jengelman/gradle/plugins/shadow/relocation/SimpleRelocator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,143:1\n1755#2,3:144\n1755#2,3:147\n*S KotlinDebug\n*F\n+ 1 SimpleRelocator.kt\ncom/github/jengelman/gradle/plugins/shadow/relocation/SimpleRelocator\n*L\n115#1:144,3\n119#1:147,3\n*E\n"})
public class SimpleRelocator
implements Relocator {
    @NotNull
    private static final Companion Companion = new Companion(null);
    private final boolean rawString;
    @NotNull
    private final String pattern;
    @NotNull
    private final String pathPattern;
    @NotNull
    private final String shadedPattern;
    @NotNull
    private final String shadedPathPattern;
    @NotNull
    private final SetProperty<String> includes;
    @NotNull
    private final SetProperty<String> excludes;

    @JvmOverloads
    public SimpleRelocator(@NotNull ObjectFactory objectFactory, @Nullable String pattern, @Nullable String shadedPattern, @Nullable List<String> includes, @Nullable List<String> excludes, boolean rawString) {
        Intrinsics.checkNotNullParameter((Object)objectFactory, (String)"objectFactory");
        this.rawString = rawString;
        SetProperty setProperty = objectFactory.setProperty(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)setProperty, (String)"setProperty(...)");
        this.includes = setProperty;
        SetProperty setProperty2 = objectFactory.setProperty(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)setProperty2, (String)"setProperty(...)");
        this.excludes = setProperty2;
        if (this.rawString) {
            String string;
            String string2 = pattern;
            if (string2 == null) {
                string2 = this.pathPattern = "";
            }
            if ((string = shadedPattern) == null) {
                string = "";
            }
            this.shadedPathPattern = string;
            this.pattern = "";
            this.shadedPattern = "";
        } else {
            if (pattern == null) {
                this.pattern = "";
                this.pathPattern = "";
            } else {
                this.pattern = StringsKt.replace$default((String)pattern, (char)'/', (char)'.', (boolean)false, (int)4, null);
                this.pathPattern = StringsKt.replace$default((String)pattern, (char)'.', (char)'/', (boolean)false, (int)4, null);
            }
            if (shadedPattern == null) {
                this.shadedPattern = "hidden." + this.pattern;
                this.shadedPathPattern = "hidden/" + this.pathPattern;
            } else {
                this.shadedPattern = StringsKt.replace$default((String)shadedPattern, (char)'/', (char)'.', (boolean)false, (int)4, null);
                this.shadedPathPattern = StringsKt.replace$default((String)shadedPattern, (char)'.', (char)'/', (boolean)false, (int)4, null);
            }
        }
        this.includes.addAll((Iterable)Companion.normalizePatterns((Collection<String>)includes));
        this.excludes.addAll((Iterable)Companion.normalizePatterns((Collection<String>)excludes));
    }

    public /* synthetic */ SimpleRelocator(ObjectFactory objectFactory, String string, String string2, List list, List list2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            string2 = null;
        }
        if ((n & 8) != 0) {
            list = null;
        }
        if ((n & 0x10) != 0) {
            list2 = null;
        }
        if ((n & 0x20) != 0) {
            bl = false;
        }
        this(objectFactory, string, string2, list, list2, bl);
    }

    @Input
    @NotNull
    public final SetProperty<String> getIncludes() {
        return this.includes;
    }

    @Input
    @NotNull
    public final SetProperty<String> getExcludes() {
        return this.excludes;
    }

    @NotNull
    public SimpleRelocator include(@NotNull String pattern) {
        SimpleRelocator simpleRelocator;
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        SimpleRelocator $this$include_u24lambda_u240 = simpleRelocator = this;
        boolean bl = false;
        $this$include_u24lambda_u240.includes.addAll((Iterable)Companion.normalizePatterns(CollectionsKt.listOf((Object)pattern)));
        return simpleRelocator;
    }

    @NotNull
    public SimpleRelocator exclude(@NotNull String pattern) {
        SimpleRelocator simpleRelocator;
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        SimpleRelocator $this$exclude_u24lambda_u241 = simpleRelocator = this;
        boolean bl = false;
        $this$exclude_u24lambda_u241.excludes.addAll((Iterable)Companion.normalizePatterns(CollectionsKt.listOf((Object)pattern)));
        return simpleRelocator;
    }

    @Override
    public boolean canRelocatePath(@NotNull String path) {
        String string;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (this.rawString) {
            return Pattern.compile(this.pathPattern).matcher(path).find();
        }
        if (path.length() < this.pathPattern.length()) {
            return false;
        }
        if (StringsKt.endsWith$default((String)path, (String)".class", (boolean)false, (int)2, null)) {
            if (path.length() == 6) {
                return false;
            }
            string = StringsKt.dropLast((String)path, (int)6);
        } else {
            string = path;
        }
        String adjustedPath = string;
        int startIndex = StringsKt.startsWith$default((String)adjustedPath, (String)"/", (boolean)false, (int)2, null) ? 1 : 0;
        boolean pathStartsWithPattern = StringsKt.startsWith$default((String)adjustedPath, (String)this.pathPattern, (int)startIndex, (boolean)false, (int)4, null);
        return pathStartsWithPattern && this.isIncluded(adjustedPath) && !this.isExcluded(adjustedPath);
    }

    @Override
    public boolean canRelocateClass(@NotNull String className) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        return !this.rawString && !StringsKt.contains$default((CharSequence)className, (char)'/', (boolean)false, (int)2, null) && this.canRelocatePath(StringsKt.replace$default((String)className, (char)'.', (char)'/', (boolean)false, (int)4, null));
    }

    @Override
    @NotNull
    public String relocatePath(@NotNull RelocatePathContext context) {
        String string;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String path = context.getPath();
        context.getStats().relocate(this.pathPattern, this.shadedPathPattern);
        if (this.rawString) {
            CharSequence charSequence = path;
            Regex regex = new Regex(this.pathPattern);
            String string2 = this.shadedPathPattern;
            string = regex.replace(charSequence, string2);
        } else {
            string = StringsKt.replaceFirst$default((String)path, (String)this.pathPattern, (String)this.shadedPathPattern, (boolean)false, (int)4, null);
        }
        return string;
    }

    @Override
    @NotNull
    public String relocateClass(@NotNull RelocateClassContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        context.getStats().relocate(this.pathPattern, this.shadedPathPattern);
        return StringsKt.replaceFirst$default((String)context.getClassName(), (String)this.pattern, (String)this.shadedPattern, (boolean)false, (int)4, null);
    }

    @Override
    @NotNull
    public String applyToSourceContent(@NotNull String sourceContent) {
        String string;
        Intrinsics.checkNotNullParameter((Object)sourceContent, (String)"sourceContent");
        if (this.rawString) {
            string = sourceContent;
        } else {
            CharSequence charSequence = sourceContent;
            Regex regex = new Regex("\\b" + this.pattern);
            String string2 = this.shadedPattern;
            string = regex.replace(charSequence, string2);
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isIncluded(String path) {
        String it;
        if (((Set)this.includes.get()).isEmpty()) return true;
        Object object = this.includes.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        Iterable $this$any$iv = (Iterable)object;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            it = (String)element$iv;
            boolean bl = false;
        } while (!SelectorUtils.matchPath((String)it, (String)path, (String)"/", (boolean)true));
        return true;
    }

    private final boolean isExcluded(String path) {
        boolean bl;
        block3: {
            Object object = this.excludes.get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            Iterable $this$any$iv = (Iterable)object;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!SelectorUtils.matchPath((String)it, (String)path, (String)"/", (boolean)true)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @JvmOverloads
    public SimpleRelocator(@NotNull ObjectFactory objectFactory, @Nullable String pattern, @Nullable String shadedPattern, @Nullable List<String> includes, @Nullable List<String> excludes) {
        Intrinsics.checkNotNullParameter((Object)objectFactory, (String)"objectFactory");
        this(objectFactory, pattern, shadedPattern, includes, excludes, false, 32, null);
    }

    @JvmOverloads
    public SimpleRelocator(@NotNull ObjectFactory objectFactory, @Nullable String pattern, @Nullable String shadedPattern, @Nullable List<String> includes) {
        Intrinsics.checkNotNullParameter((Object)objectFactory, (String)"objectFactory");
        this(objectFactory, pattern, shadedPattern, includes, null, false, 48, null);
    }

    @JvmOverloads
    public SimpleRelocator(@NotNull ObjectFactory objectFactory, @Nullable String pattern, @Nullable String shadedPattern) {
        Intrinsics.checkNotNullParameter((Object)objectFactory, (String)"objectFactory");
        this(objectFactory, pattern, shadedPattern, null, null, false, 56, null);
    }

    @JvmOverloads
    public SimpleRelocator(@NotNull ObjectFactory objectFactory, @Nullable String pattern) {
        Intrinsics.checkNotNullParameter((Object)objectFactory, (String)"objectFactory");
        this(objectFactory, pattern, null, null, null, false, 60, null);
    }

    @JvmOverloads
    public SimpleRelocator(@NotNull ObjectFactory objectFactory) {
        Intrinsics.checkNotNullParameter((Object)objectFactory, (String)"objectFactory");
        this(objectFactory, null, null, null, null, false, 62, null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u000e\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\b\u00a8\u0006\t"}, d2={"Lcom/github/jengelman/gradle/plugins/shadow/relocation/SimpleRelocator$Companion;", "", "<init>", "()V", "normalizePatterns", "", "", "patterns", "", "shadow"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<String> normalizePatterns(@Nullable Collection<String> patterns) {
            Set set;
            Set $this$normalizePatterns_u24lambda_u240 = set = SetsKt.createSetBuilder();
            boolean bl = false;
            if (patterns != null) {
                for (String pattern : patterns) {
                    String packagePattern;
                    if (StringsKt.startsWith$default((String)pattern, (String)"%regex[", (boolean)false, (int)2, null)) {
                        $this$normalizePatterns_u24lambda_u240.add(pattern);
                        continue;
                    }
                    String classPattern = StringsKt.replace$default((String)pattern, (char)'.', (char)'/', (boolean)false, (int)4, null);
                    $this$normalizePatterns_u24lambda_u240.add(classPattern);
                    if (!StringsKt.endsWith$default((String)classPattern, (String)"/*", (boolean)false, (int)2, null)) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)classPattern.substring(0, StringsKt.lastIndexOf$default((CharSequence)classPattern, (char)'/', (int)0, (boolean)false, (int)6, null)), (String)"substring(...)");
                    $this$normalizePatterns_u24lambda_u240.add(packagePattern);
                }
            }
            return SetsKt.build((Set)set);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

