/*
 * Decompiled with CFR 0.152.
 */
package com.github.jengelman.gradle.plugins.shadow.tasks;

import com.github.jengelman.gradle.plugins.shadow.ShadowStats;
import com.github.jengelman.gradle.plugins.shadow.impl.RelocatorRemapper;
import com.github.jengelman.gradle.plugins.shadow.internal.UnusedTracker;
import com.github.jengelman.gradle.plugins.shadow.internal.UtilsKt;
import com.github.jengelman.gradle.plugins.shadow.internal.ZipCompressor;
import com.github.jengelman.gradle.plugins.shadow.relocation.Relocator;
import com.github.jengelman.gradle.plugins.shadow.transformers.Transformer;
import com.github.jengelman.gradle.plugins.shadow.transformers.TransformerContext;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipException;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.tools.zip.Zip64RequiredException;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.apache.tools.zip.ZipOutputStream;
import org.gradle.api.GradleException;
import org.gradle.api.file.FileCopyDetails;
import org.gradle.api.file.FilePermissions;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.file.CopyActionProcessingStreamAction;
import org.gradle.api.internal.file.DefaultFilePermissions;
import org.gradle.api.internal.file.copy.CopyAction;
import org.gradle.api.internal.file.copy.CopyActionProcessingStream;
import org.gradle.api.internal.file.copy.FileCopyDetailsInternal;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.WorkResults;
import org.gradle.api.tasks.bundling.Zip;
import org.gradle.api.tasks.util.PatternSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.commons.ClassRemapper;
import org.objectweb.asm.commons.Remapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u0000 ,2\u00020\u0001:\u0005()*+,Bq\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000b\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\u0006\u0010\u0015\u001a\u00020\u0014\u0012\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017\u00a2\u0006\u0004\b\u0018\u0010\u0019Bg\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000b\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\u0006\u0010\u0015\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0018\u0010\u001aJ\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#H\u0002J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020&H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/github/jengelman/gradle/plugins/shadow/tasks/ShadowCopyAction;", "Lorg/gradle/api/internal/file/copy/CopyAction;", "zipFile", "Ljava/io/File;", "compressor", "Lcom/github/jengelman/gradle/plugins/shadow/internal/ZipCompressor;", "documentationRegistry", "Lorg/gradle/api/internal/DocumentationRegistry;", "encoding", "", "transformers", "", "Lcom/github/jengelman/gradle/plugins/shadow/transformers/Transformer;", "relocators", "Lcom/github/jengelman/gradle/plugins/shadow/relocation/Relocator;", "patternSet", "Lorg/gradle/api/tasks/util/PatternSet;", "stats", "Lcom/github/jengelman/gradle/plugins/shadow/ShadowStats;", "preserveFileTimestamps", "", "minimizeJar", "unusedTracker", "Lcom/github/jengelman/gradle/plugins/shadow/internal/UnusedTracker;", "<init>", "(Ljava/io/File;Lcom/github/jengelman/gradle/plugins/shadow/internal/ZipCompressor;Lorg/gradle/api/internal/DocumentationRegistry;Ljava/lang/String;Ljava/util/List;Ljava/util/List;Lorg/gradle/api/tasks/util/PatternSet;Lcom/github/jengelman/gradle/plugins/shadow/ShadowStats;ZZLcom/github/jengelman/gradle/plugins/shadow/internal/UnusedTracker;)V", "(Ljava/io/File;Lcom/github/jengelman/gradle/plugins/shadow/internal/ZipCompressor;Lorg/gradle/api/internal/DocumentationRegistry;Ljava/lang/String;Ljava/util/List;Ljava/util/List;Lorg/gradle/api/tasks/util/PatternSet;Lcom/github/jengelman/gradle/plugins/shadow/ShadowStats;ZZ)V", "execute", "Lorg/gradle/api/tasks/WorkResult;", "stream", "Lorg/gradle/api/internal/file/copy/CopyActionProcessingStream;", "processTransformers", "", "Lorg/apache/tools/zip/ZipOutputStream;", "getArchiveTimeFor", "", "timestamp", "setArchiveTimes", "Lorg/apache/tools/zip/ZipEntry;", "zipEntry", "BaseStreamAction", "StreamAction", "RelativeArchivePath", "ArchiveFileTreeElement", "Companion", "shadow"})
@SourceDebugExtension(value={"SMAP\nShadowCopyAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShadowCopyAction.kt\ncom/github/jengelman/gradle/plugins/shadow/tasks/ShadowCopyAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,449:1\n1863#2,2:450\n*S KotlinDebug\n*F\n+ 1 ShadowCopyAction.kt\ncom/github/jengelman/gradle/plugins/shadow/tasks/ShadowCopyAction\n*L\n130#1:450,2\n*E\n"})
public class ShadowCopyAction
implements CopyAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File zipFile;
    @NotNull
    private final ZipCompressor compressor;
    @NotNull
    private final DocumentationRegistry documentationRegistry;
    @Nullable
    private final String encoding;
    @NotNull
    private final List<Transformer> transformers;
    @NotNull
    private final List<Relocator> relocators;
    @NotNull
    private final PatternSet patternSet;
    @NotNull
    private final ShadowStats stats;
    private final boolean preserveFileTimestamps;
    private final boolean minimizeJar;
    @Nullable
    private final UnusedTracker unusedTracker;
    private static final Logger logger = LoggerFactory.getLogger(ShadowCopyAction.class);
    private static final long CONSTANT_TIME_FOR_ZIP_ENTRIES = new GregorianCalendar(1980, 1, 1, 0, 0, 0).getTimeInMillis();

    public ShadowCopyAction(@NotNull File zipFile, @NotNull ZipCompressor compressor, @NotNull DocumentationRegistry documentationRegistry, @Nullable String encoding, @NotNull List<? extends Transformer> transformers, @NotNull List<? extends Relocator> relocators, @NotNull PatternSet patternSet, @NotNull ShadowStats stats, boolean preserveFileTimestamps, boolean minimizeJar, @Nullable UnusedTracker unusedTracker) {
        Intrinsics.checkNotNullParameter((Object)zipFile, (String)"zipFile");
        Intrinsics.checkNotNullParameter((Object)compressor, (String)"compressor");
        Intrinsics.checkNotNullParameter((Object)documentationRegistry, (String)"documentationRegistry");
        Intrinsics.checkNotNullParameter(transformers, (String)"transformers");
        Intrinsics.checkNotNullParameter(relocators, (String)"relocators");
        Intrinsics.checkNotNullParameter((Object)patternSet, (String)"patternSet");
        Intrinsics.checkNotNullParameter((Object)stats, (String)"stats");
        this.zipFile = zipFile;
        this.compressor = compressor;
        this.documentationRegistry = documentationRegistry;
        this.encoding = encoding;
        this.transformers = transformers;
        this.relocators = relocators;
        this.patternSet = patternSet;
        this.stats = stats;
        this.preserveFileTimestamps = preserveFileTimestamps;
        this.minimizeJar = minimizeJar;
        this.unusedTracker = unusedTracker;
    }

    public ShadowCopyAction(@NotNull File zipFile, @NotNull ZipCompressor compressor, @NotNull DocumentationRegistry documentationRegistry, @Nullable String encoding, @NotNull List<? extends Transformer> transformers, @NotNull List<? extends Relocator> relocators, @NotNull PatternSet patternSet, @NotNull ShadowStats stats, boolean preserveFileTimestamps, boolean minimizeJar) {
        Intrinsics.checkNotNullParameter((Object)zipFile, (String)"zipFile");
        Intrinsics.checkNotNullParameter((Object)compressor, (String)"compressor");
        Intrinsics.checkNotNullParameter((Object)documentationRegistry, (String)"documentationRegistry");
        Intrinsics.checkNotNullParameter(transformers, (String)"transformers");
        Intrinsics.checkNotNullParameter(relocators, (String)"relocators");
        Intrinsics.checkNotNullParameter((Object)patternSet, (String)"patternSet");
        Intrinsics.checkNotNullParameter((Object)stats, (String)"stats");
        this(zipFile, compressor, documentationRegistry, encoding, transformers, relocators, patternSet, stats, preserveFileTimestamps, minimizeJar, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public WorkResult execute(@NotNull CopyActionProcessingStream stream) {
        Object object;
        Set<String> set;
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        if (this.minimizeJar && this.unusedTracker != null) {
            stream.process((CopyActionProcessingStreamAction)new BaseStreamAction(this){
                final /* synthetic */ ShadowCopyAction this$0;
                {
                    this.this$0 = $receiver;
                }

                protected void visitFile(FileCopyDetails fileDetails) {
                    Intrinsics.checkNotNullParameter((Object)fileDetails, (String)"fileDetails");
                    if (this.isArchive(fileDetails)) {
                        UnusedTracker unusedTracker = ShadowCopyAction.access$getUnusedTracker$p(this.this$0);
                        File file = fileDetails.getFile();
                        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getFile(...)");
                        unusedTracker.addDependency(file);
                    }
                }
            });
            set = this.unusedTracker.findUnused();
        } else {
            set = SetsKt.emptySet();
        }
        Set<String> unusedClasses2 = set;
        try {
            OutputStream outputStream = this.compressor.createArchiveOutputStream(this.zipFile);
            Intrinsics.checkNotNull((Object)outputStream, (String)"null cannot be cast to non-null type org.apache.tools.zip.ZipOutputStream");
            object = (ZipOutputStream)outputStream;
        }
        catch (Exception e) {
            throw new GradleException("Could not create ZIP '" + this.zipFile + '\'', (Throwable)e);
        }
        ZipOutputStream zipOutStream = object;
        try {
            object = (Closeable)zipOutStream;
            Throwable throwable = null;
            try {
                Object outputStream = object;
                boolean bl = false;
                stream.process((CopyActionProcessingStreamAction)new StreamAction((ZipOutputStream)outputStream, this.encoding, (List<? extends Transformer>)this.transformers, (List<? extends Relocator>)this.relocators, this.patternSet, unusedClasses2, this.stats));
                this.processTransformers((ZipOutputStream)outputStream);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
        }
        catch (IOException e) {
            Throwable throwable = e.getCause();
            throw new Zip64RequiredException((throwable != null ? throwable.getMessage() : null) + "\n\nTo build this archive, please enable the zip64 extension.\nSee: " + this.documentationRegistry.getDslRefForProperty(Zip.class, "zip64"));
        }
        WorkResult workResult = WorkResults.didWork((boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)workResult, (String)"didWork(...)");
        return workResult;
    }

    private final void processTransformers(ZipOutputStream stream) {
        Iterable $this$forEach$iv = this.transformers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Transformer transformer = (Transformer)element$iv;
            boolean bl = false;
            if (!transformer.hasTransformedResource()) continue;
            transformer.modifyOutputStream(stream, this.preserveFileTimestamps);
        }
    }

    private final long getArchiveTimeFor(long timestamp) {
        return this.preserveFileTimestamps ? timestamp : CONSTANT_TIME_FOR_ZIP_ENTRIES;
    }

    private final ZipEntry setArchiveTimes(ZipEntry zipEntry) {
        if (!this.preserveFileTimestamps) {
            zipEntry.setTime(CONSTANT_TIME_FOR_ZIP_ENTRIES);
        }
        return zipEntry;
    }

    public static final /* synthetic */ UnusedTracker access$getUnusedTracker$p(ShadowCopyAction $this) {
        return $this.unusedTracker;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0013\u0012\n\u0010\u0002\u001a\u00060\u0003R\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\n\u001a\u00020\bH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u000fH\u0016J\f\u0010\u0011\u001a\u00060\u0003R\u00020\u0004H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0017J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0001H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\u0018H\u0016R\u0012\u0010\u0002\u001a\u00060\u0003R\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\t\u00a8\u0006 "}, d2={"Lcom/github/jengelman/gradle/plugins/shadow/tasks/ShadowCopyAction$ArchiveFileTreeElement;", "Lorg/gradle/api/file/FileTreeElement;", "archivePath", "Lcom/github/jengelman/gradle/plugins/shadow/tasks/ShadowCopyAction$RelativeArchivePath;", "Lcom/github/jengelman/gradle/plugins/shadow/tasks/ShadowCopyAction;", "<init>", "(Lcom/github/jengelman/gradle/plugins/shadow/tasks/ShadowCopyAction$RelativeArchivePath;)V", "isClassFile", "", "()Z", "isDirectory", "getLastModified", "", "getSize", "getName", "", "getPath", "getRelativePath", "getMode", "", "getPermissions", "Lorg/gradle/api/file/FilePermissions;", "asFileTreeElement", "getFile", "Ljava/io/File;", "open", "Ljava/io/InputStream;", "copyTo", "", "outputStream", "Ljava/io/OutputStream;", "file", "shadow"})
    public static class ArchiveFileTreeElement
    implements FileTreeElement {
        @NotNull
        private final RelativeArchivePath archivePath;

        public ArchiveFileTreeElement(@NotNull RelativeArchivePath archivePath) {
            Intrinsics.checkNotNullParameter((Object)((Object)archivePath), (String)"archivePath");
            this.archivePath = archivePath;
        }

        public boolean isClassFile() {
            return this.archivePath.isClassFile();
        }

        public boolean isDirectory() {
            return this.archivePath.getEntry().isDirectory();
        }

        public long getLastModified() {
            return this.archivePath.getEntry().getLastModifiedDate().getTime();
        }

        public long getSize() {
            return this.archivePath.getEntry().getSize();
        }

        @NotNull
        public String getName() {
            String string = this.archivePath.getPathString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPathString(...)");
            return string;
        }

        @NotNull
        public String getPath() {
            String string = this.archivePath.getLastName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLastName(...)");
            return string;
        }

        @NotNull
        public RelativeArchivePath getRelativePath() {
            return this.archivePath;
        }

        @Deprecated(message="Deprecated in Java")
        public int getMode() {
            return this.archivePath.getEntry().getUnixMode();
        }

        @NotNull
        public FilePermissions getPermissions() {
            return (FilePermissions)new DefaultFilePermissions(this.getMode());
        }

        @NotNull
        public FileTreeElement asFileTreeElement() {
            String[] stringArray = this.archivePath.getSegments();
            return (FileTreeElement)UtilsKt.createDefaultFileTreeElement$default(null, new RelativePath(!this.isDirectory(), Arrays.copyOf(stringArray, stringArray.length)), null, null, 13, null);
        }

        @NotNull
        public File getFile() {
            throw new UnsupportedOperationException();
        }

        @NotNull
        public InputStream open() {
            throw new UnsupportedOperationException();
        }

        public void copyTo(@NotNull OutputStream outputStream) {
            Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
            throw new UnsupportedOperationException();
        }

        public boolean copyTo(@NotNull File file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            throw new UnsupportedOperationException();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0004J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u0007H\u0014J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0007H$\u00a8\u0006\u0010"}, d2={"Lcom/github/jengelman/gradle/plugins/shadow/tasks/ShadowCopyAction$BaseStreamAction;", "Lorg/gradle/api/internal/file/CopyActionProcessingStreamAction;", "<init>", "()V", "isArchive", "", "fileDetails", "Lorg/gradle/api/file/FileCopyDetails;", "isClass", "processFile", "", "details", "Lorg/gradle/api/internal/file/copy/FileCopyDetailsInternal;", "visitDir", "dirDetails", "visitFile", "shadow"})
    public static abstract class BaseStreamAction
    implements CopyActionProcessingStreamAction {
        protected final boolean isArchive(@NotNull FileCopyDetails fileDetails) {
            Intrinsics.checkNotNullParameter((Object)fileDetails, (String)"fileDetails");
            String string = fileDetails.getRelativePath().getPathString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPathString(...)");
            return StringsKt.endsWith$default((String)string, (String)".jar", (boolean)false, (int)2, null);
        }

        protected final boolean isClass(@NotNull FileCopyDetails fileDetails) {
            Intrinsics.checkNotNullParameter((Object)fileDetails, (String)"fileDetails");
            String string = fileDetails.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            return StringsKt.endsWith$default((String)string, (String)".class", (boolean)false, (int)2, null);
        }

        public void processFile(@NotNull FileCopyDetailsInternal details) {
            Intrinsics.checkNotNullParameter((Object)details, (String)"details");
            if (details.isDirectory()) {
                this.visitDir((FileCopyDetails)details);
            } else {
                this.visitFile((FileCopyDetails)details);
            }
        }

        protected void visitDir(@NotNull FileCopyDetails dirDetails) {
            Intrinsics.checkNotNullParameter((Object)dirDetails, (String)"dirDetails");
        }

        protected abstract void visitFile(@NotNull FileCopyDetails var1);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/github/jengelman/gradle/plugins/shadow/tasks/ShadowCopyAction$Companion;", "", "<init>", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "CONSTANT_TIME_FOR_ZIP_ENTRIES", "", "getCONSTANT_TIME_FOR_ZIP_ENTRIES", "()J", "shadow"})
    public static final class Companion {
        private Companion() {
        }

        public final long getCONSTANT_TIME_FOR_ZIP_ENTRIES() {
            return CONSTANT_TIME_FOR_ZIP_ENTRIES;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0096\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u000b\u001a\b\u0018\u00010\u0000R\u00020\fH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\n\u00a8\u0006\r"}, d2={"Lcom/github/jengelman/gradle/plugins/shadow/tasks/ShadowCopyAction$RelativeArchivePath;", "Lorg/gradle/api/file/RelativePath;", "entry", "Lorg/apache/tools/zip/ZipEntry;", "<init>", "(Lcom/github/jengelman/gradle/plugins/shadow/tasks/ShadowCopyAction;Lorg/apache/tools/zip/ZipEntry;)V", "getEntry", "()Lorg/apache/tools/zip/ZipEntry;", "isClassFile", "", "()Z", "getParent", "Lcom/github/jengelman/gradle/plugins/shadow/tasks/ShadowCopyAction;", "shadow"})
    @SourceDebugExtension(value={"SMAP\nShadowCopyAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShadowCopyAction.kt\ncom/github/jengelman/gradle/plugins/shadow/tasks/ShadowCopyAction$RelativeArchivePath\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,449:1\n774#2:450\n865#2,2:451\n37#3,2:453\n*S KotlinDebug\n*F\n+ 1 ShadowCopyAction.kt\ncom/github/jengelman/gradle/plugins/shadow/tasks/ShadowCopyAction$RelativeArchivePath\n*L\n393#1:450\n393#1:451,2\n393#1:453,2\n*E\n"})
    public class RelativeArchivePath
    extends RelativePath {
        @NotNull
        private final ZipEntry entry;

        /*
         * WARNING - void declaration
         */
        public RelativeArchivePath(ZipEntry entry) {
            void $this$toTypedArray$iv;
            void $this$filterTo$iv$iv;
            Collection $this$filter$iv;
            Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
            boolean bl = !entry.isDirectory();
            String string = entry.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            Object object = new char[]{'/'};
            object = StringsKt.split$default((CharSequence)string, (char[])object, (boolean)false, (int)0, (int)6, null);
            boolean bl2 = bl;
            RelativeArchivePath relativeArchivePath = this;
            boolean $i$f$filter = false;
            void var6_7 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                CharSequence p0 = (CharSequence)element$iv$iv;
                boolean bl3 = false;
                boolean bl4 = p0.length() > 0;
                if (!bl4) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List list = (List)destination$iv$iv;
            $this$filter$iv = list;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            super(bl2, Arrays.copyOf(stringArray, stringArray.length));
            this.entry = entry;
        }

        @NotNull
        public ZipEntry getEntry() {
            return this.entry;
        }

        public boolean isClassFile() {
            String string = this.getLastName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLastName(...)");
            return StringsKt.endsWith$default((String)string, (String)".class", (boolean)false, (int)2, null);
        }

        @Nullable
        public RelativeArchivePath getParent() {
            RelativeArchivePath relativeArchivePath;
            if (this.getSegments().length <= 1) {
                relativeArchivePath = null;
            } else {
                StringBuilder stringBuilder = new StringBuilder();
                String[] stringArray = this.getSegments();
                Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getSegments(...)");
                String parentPath = stringBuilder.append(CollectionsKt.joinToString$default((Iterable)ArraysKt.dropLast((Object[])stringArray, (int)1), (CharSequence)"/", null, null, (int)0, null, null, (int)62, null)).append('/').toString();
                ZipEntry entry = ShadowCopyAction.this.setArchiveTimes(new ZipEntry(parentPath));
                relativeArchivePath = new RelativeArchivePath(entry);
            }
            return relativeArchivePath;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001BS\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0014\u0010 \u001a\u00020\u00182\n\u0010!\u001a\u00060\"R\u00020#H\u0002J\u0018\u0010$\u001a\u00020\u00182\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002J\u0016\u0010)\u001a\u00020\u00182\f\u0010*\u001a\b\u0018\u00010\"R\u00020#H\u0002J\u0010\u0010+\u001a\u00020\u001c2\u0006\u0010,\u001a\u00020\u0005H\u0002J\u001c\u0010-\u001a\u00020\u00182\n\u0010*\u001a\u00060\"R\u00020#2\u0006\u0010'\u001a\u00020(H\u0002J\u0010\u0010-\u001a\u00020\u00182\u0006\u0010.\u001a\u00020\u001aH\u0002J \u0010-\u001a\u00020\u00182\u0006\u0010/\u001a\u0002002\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u00101\u001a\u000202H\u0002J\u001c\u00103\u001a\u00020\u00182\n\u0010%\u001a\u00060\"R\u00020#2\u0006\u0010'\u001a\u00020(H\u0002J\u0010\u00104\u001a\u00020\u00182\u0006\u00105\u001a\u00020\u001aH\u0014J\u0018\u00106\u001a\u00020\u00182\u0006\u00107\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002J\u0010\u00106\u001a\u00020\u00182\u0006\u00108\u001a\u00020\u001aH\u0002J\u0018\u00109\u001a\u00020\u00182\u0006\u00107\u001a\u00020:2\u0006\u0010;\u001a\u000200H\u0002J\u0010\u0010<\u001a\u00020\u001c2\u0006\u00107\u001a\u00020:H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lcom/github/jengelman/gradle/plugins/shadow/tasks/ShadowCopyAction$StreamAction;", "Lcom/github/jengelman/gradle/plugins/shadow/tasks/ShadowCopyAction$BaseStreamAction;", "zipOutStr", "Lorg/apache/tools/zip/ZipOutputStream;", "encoding", "", "transformers", "", "Lcom/github/jengelman/gradle/plugins/shadow/transformers/Transformer;", "relocators", "Lcom/github/jengelman/gradle/plugins/shadow/relocation/Relocator;", "patternSet", "Lorg/gradle/api/tasks/util/PatternSet;", "unused", "", "stats", "Lcom/github/jengelman/gradle/plugins/shadow/ShadowStats;", "<init>", "(Lcom/github/jengelman/gradle/plugins/shadow/tasks/ShadowCopyAction;Lorg/apache/tools/zip/ZipOutputStream;Ljava/lang/String;Ljava/util/List;Ljava/util/List;Lorg/gradle/api/tasks/util/PatternSet;Ljava/util/Set;Lcom/github/jengelman/gradle/plugins/shadow/ShadowStats;)V", "remapper", "Lcom/github/jengelman/gradle/plugins/shadow/impl/RelocatorRemapper;", "visitedFiles", "", "visitFile", "", "fileDetails", "Lorg/gradle/api/file/FileCopyDetails;", "recordVisit", "", "path", "Lorg/gradle/api/file/RelativePath;", "processArchive", "visitArchiveDirectory", "archiveDir", "Lcom/github/jengelman/gradle/plugins/shadow/tasks/ShadowCopyAction$RelativeArchivePath;", "Lcom/github/jengelman/gradle/plugins/shadow/tasks/ShadowCopyAction;", "visitArchiveFile", "archiveFile", "Lcom/github/jengelman/gradle/plugins/shadow/tasks/ShadowCopyAction$ArchiveFileTreeElement;", "archive", "Lorg/apache/tools/zip/ZipFile;", "addParentDirectories", "file", "isUnused", "classPath", "remapClass", "fileCopyDetails", "classInputStream", "Ljava/io/InputStream;", "lastModified", "", "copyArchiveEntry", "visitDir", "dirDetails", "transform", "element", "details", "transformAndClose", "Lorg/gradle/api/file/FileTreeElement;", "inputStream", "isTransformable", "shadow"})
    @SourceDebugExtension(value={"SMAP\nShadowCopyAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShadowCopyAction.kt\ncom/github/jengelman/gradle/plugins/shadow/tasks/ShadowCopyAction$StreamAction\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,449:1\n1317#2,2:450\n1755#3,3:452\n*S KotlinDebug\n*F\n+ 1 ShadowCopyAction.kt\ncom/github/jengelman/gradle/plugins/shadow/tasks/ShadowCopyAction$StreamAction\n*L\n225#1:450,2\n384#1:452,3\n*E\n"})
    private final class StreamAction
    extends BaseStreamAction {
        @NotNull
        private final ZipOutputStream zipOutStr;
        @NotNull
        private final List<Transformer> transformers;
        @NotNull
        private final List<Relocator> relocators;
        @NotNull
        private final PatternSet patternSet;
        @NotNull
        private final Set<String> unused;
        @NotNull
        private final ShadowStats stats;
        @NotNull
        private final RelocatorRemapper remapper;
        @NotNull
        private final Set<String> visitedFiles;

        public StreamAction(@Nullable ZipOutputStream zipOutStr, @NotNull String encoding, @NotNull List<? extends Transformer> transformers, @NotNull List<? extends Relocator> relocators, @NotNull PatternSet patternSet, @NotNull Set<String> unused, ShadowStats stats) {
            Intrinsics.checkNotNullParameter((Object)zipOutStr, (String)"zipOutStr");
            Intrinsics.checkNotNullParameter(transformers, (String)"transformers");
            Intrinsics.checkNotNullParameter(relocators, (String)"relocators");
            Intrinsics.checkNotNullParameter((Object)patternSet, (String)"patternSet");
            Intrinsics.checkNotNullParameter(unused, (String)"unused");
            Intrinsics.checkNotNullParameter((Object)stats, (String)"stats");
            this.zipOutStr = zipOutStr;
            this.transformers = transformers;
            this.relocators = relocators;
            this.patternSet = patternSet;
            this.unused = unused;
            this.stats = stats;
            this.remapper = new RelocatorRemapper(this.relocators, this.stats);
            this.visitedFiles = new LinkedHashSet();
            if (encoding != null) {
                this.zipOutStr.setEncoding(encoding);
            }
        }

        @Override
        protected void visitFile(@NotNull FileCopyDetails fileDetails) {
            Intrinsics.checkNotNullParameter((Object)fileDetails, (String)"fileDetails");
            if (!this.isArchive(fileDetails)) {
                try {
                    boolean isClass = this.isClass(fileDetails);
                    if (!this.remapper.hasRelocators() || !isClass) {
                        if (!this.isTransformable((FileTreeElement)fileDetails)) {
                            String string = fileDetails.getRelativePath().getPathString();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPathString(...)");
                            String mappedPath = this.remapper.map(string);
                            ZipEntry archiveEntry = new ZipEntry(mappedPath);
                            archiveEntry.setTime(ShadowCopyAction.this.getArchiveTimeFor(fileDetails.getLastModified()));
                            archiveEntry.setUnixMode(0x8000 | fileDetails.getPermissions().toUnixNumeric());
                            this.zipOutStr.putNextEntry(archiveEntry);
                            fileDetails.copyTo((OutputStream)this.zipOutStr);
                            this.zipOutStr.closeEntry();
                        } else {
                            this.transform(fileDetails);
                        }
                    } else if (isClass) {
                        String string = fileDetails.getPath();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                        if (!this.isUnused(string)) {
                            this.remapClass(fileDetails);
                        }
                    }
                    RelativePath relativePath = fileDetails.getRelativePath();
                    Intrinsics.checkNotNullExpressionValue((Object)relativePath, (String)"getRelativePath(...)");
                    boolean bl = this.recordVisit(relativePath);
                }
                catch (Exception e) {
                    throw new GradleException("Could not add " + fileDetails + " to ZIP '" + ShadowCopyAction.this.zipFile + "'.", (Throwable)e);
                }
            } else {
                this.processArchive(fileDetails);
            }
        }

        private final boolean recordVisit(RelativePath path) {
            String string = path.getPathString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPathString(...)");
            return this.visitedFiles.add(string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private final void processArchive(FileCopyDetails fileDetails) {
            this.stats.startJar();
            Closeable closeable = (Closeable)new ZipFile(fileDetails.getFile());
            ShadowCopyAction shadowCopyAction = ShadowCopyAction.this;
            Throwable throwable = null;
            try {
                void $this$forEach$iv;
                ZipFile archive = (ZipFile)closeable;
                boolean bl = false;
                Enumeration enumeration = archive.getEntries();
                Intrinsics.checkNotNullExpressionValue((Object)enumeration, (String)"getEntries(...)");
                Sequence sequence = SequencesKt.filter((Sequence)SequencesKt.map((Sequence)SequencesKt.asSequence((Iterator)CollectionsKt.iterator((Enumeration)enumeration)), arg_0 -> StreamAction.processArchive$lambda$3$lambda$0(shadowCopyAction, arg_0)), arg_0 -> StreamAction.processArchive$lambda$3$lambda$1(this, arg_0));
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ArchiveFileTreeElement archiveElement = (ArchiveFileTreeElement)element$iv;
                    boolean bl2 = false;
                    if (!archiveElement.getRelativePath().isFile()) continue;
                    this.visitArchiveFile(archiveElement, archive);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            this.stats.finishJar();
        }

        private final void visitArchiveDirectory(RelativeArchivePath archiveDir) {
            if (this.recordVisit(archiveDir)) {
                this.zipOutStr.putNextEntry(archiveDir.getEntry());
                this.zipOutStr.closeEntry();
            }
        }

        private final void visitArchiveFile(ArchiveFileTreeElement archiveFile, ZipFile archive) {
            RelativeArchivePath archiveFilePath = archiveFile.getRelativePath();
            if (archiveFile.isClassFile() || !this.isTransformable(archiveFile)) {
                if (this.recordVisit(archiveFilePath)) {
                    String string = archiveFilePath.getEntry().getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    if (!this.isUnused(string)) {
                        if (!this.remapper.hasRelocators() || !archiveFile.isClassFile()) {
                            this.copyArchiveEntry(archiveFilePath, archive);
                        } else {
                            this.remapClass(archiveFilePath, archive);
                        }
                    }
                }
            } else {
                this.transform(archiveFile, archive);
            }
        }

        private final void addParentDirectories(RelativeArchivePath file) {
            block1: {
                RelativeArchivePath relativeArchivePath = file;
                if (relativeArchivePath == null) break block1;
                RelativeArchivePath it = relativeArchivePath;
                boolean bl = false;
                this.addParentDirectories(it.getParent());
                if (!it.isFile()) {
                    this.visitArchiveDirectory(it);
                }
            }
        }

        private final boolean isUnused(String classPath) {
            String classPathWithoutExtension = StringsKt.substringBeforeLast$default((String)classPath, (String)".", null, (int)2, null);
            String className = StringsKt.replace$default((String)classPathWithoutExtension, (char)'/', (char)'.', (boolean)false, (int)4, null);
            boolean result = this.unused.contains(className);
            if (result) {
                logger.debug("Dropping unused class: " + className);
            }
            return result;
        }

        private final void remapClass(RelativeArchivePath file, ZipFile archive) {
            if (file.isClassFile()) {
                ZipEntry zipEntry = ShadowCopyAction.this.setArchiveTimes(new ZipEntry(this.remapper.mapPath(file) + ".class"));
                this.addParentDirectories(new RelativeArchivePath(zipEntry));
                InputStream inputStream = archive.getInputStream(file.getEntry());
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
                String string = file.getPathString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPathString(...)");
                this.remapClass(inputStream, string, file.getEntry().getTime());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void remapClass(FileCopyDetails fileCopyDetails) {
            String string = fileCopyDetails.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            if (StringsKt.endsWith$default((String)string, (String)".class", (boolean)false, (int)2, null)) {
                File file = fileCopyDetails.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getFile(...)");
                Object object = file;
                object = new FileInputStream((File)object);
                Throwable throwable = null;
                try {
                    FileInputStream it = (FileInputStream)object;
                    boolean bl = false;
                    InputStream inputStream = it;
                    String string2 = fileCopyDetails.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
                    this.remapClass(inputStream, string2, fileCopyDetails.getLastModified());
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void remapClass(InputStream classInputStream, String path, long lastModified) {
            ClassWriter cw = new ClassWriter(0);
            ClassReader cr = new ClassReader(classInputStream);
            ClassRemapper cv = new ClassRemapper((ClassVisitor)cw, (Remapper)this.remapper);
            try {
                cr.accept((ClassVisitor)cv, 8);
            }
            catch (Throwable t) {
                throw new GradleException("Error in ASM processing class " + path, t);
            }
            byte[] renamedClass = cw.toByteArray();
            MatchResult matchResult = Regex.find$default((Regex)new Regex("^META-INF/versions/\\d+/"), (CharSequence)path, (int)0, (int)2, null);
            String string = matchResult != null ? matchResult.getValue() : null;
            if (string == null) {
                string = "";
            }
            String multiReleasePrefix = string;
            String newPath = StringsKt.replace$default((String)path, (String)multiReleasePrefix, (String)"", (boolean)false, (int)4, null);
            String mappedName = multiReleasePrefix + this.remapper.mapPath(newPath);
            try {
                ZipEntry archiveEntry = new ZipEntry(mappedName + ".class");
                archiveEntry.setTime(ShadowCopyAction.this.getArchiveTimeFor(lastModified));
                this.zipOutStr.putNextEntry(archiveEntry);
                Intrinsics.checkNotNull((Object)renamedClass);
                Closeable closeable = new ByteArrayInputStream(renamedClass);
                Throwable throwable = null;
                try {
                    ByteArrayInputStream it = (ByteArrayInputStream)closeable;
                    boolean bl = false;
                    long l = ByteStreamsKt.copyTo$default((InputStream)it, (OutputStream)((OutputStream)this.zipOutStr), (int)0, (int)2, null);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                this.zipOutStr.closeEntry();
            }
            catch (ZipException ignored) {
                logger.warn("We have a duplicate " + mappedName + " in source project");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void copyArchiveEntry(RelativeArchivePath archiveFile, ZipFile archive) {
            String string = archiveFile.getEntry().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            String mappedPath = this.remapper.map(string);
            ZipEntry entry = new ZipEntry(mappedPath);
            entry.setTime(ShadowCopyAction.this.getArchiveTimeFor(archiveFile.getEntry().getTime()));
            RelativeArchivePath mappedFile = new RelativeArchivePath(entry);
            this.addParentDirectories(mappedFile);
            this.zipOutStr.putNextEntry(mappedFile.getEntry());
            Closeable closeable = archive.getInputStream(archiveFile.getEntry());
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                long l = ByteStreamsKt.copyTo$default((InputStream)it, (OutputStream)((OutputStream)this.zipOutStr), (int)0, (int)2, null);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            this.zipOutStr.closeEntry();
        }

        @Override
        protected void visitDir(@NotNull FileCopyDetails dirDetails) {
            Intrinsics.checkNotNullParameter((Object)dirDetails, (String)"dirDetails");
            try {
                String path = dirDetails.getRelativePath().getPathString() + '/';
                ZipEntry archiveEntry = new ZipEntry(path);
                archiveEntry.setTime(ShadowCopyAction.this.getArchiveTimeFor(dirDetails.getLastModified()));
                archiveEntry.setUnixMode(0x4000 | dirDetails.getPermissions().toUnixNumeric());
                this.zipOutStr.putNextEntry(archiveEntry);
                this.zipOutStr.closeEntry();
                RelativePath relativePath = dirDetails.getRelativePath();
                Intrinsics.checkNotNullExpressionValue((Object)relativePath, (String)"getRelativePath(...)");
                this.recordVisit(relativePath);
            }
            catch (Exception e) {
                throw new GradleException("Could not add " + dirDetails + " to ZIP '" + ShadowCopyAction.this.zipFile + "'.", (Throwable)e);
            }
        }

        private final void transform(ArchiveFileTreeElement element, ZipFile archive) {
            FileTreeElement fileTreeElement = element;
            InputStream inputStream = archive.getInputStream(element.getRelativePath().getEntry());
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
            this.transformAndClose(fileTreeElement, inputStream);
        }

        private final void transform(FileCopyDetails details) {
            FileTreeElement fileTreeElement = (FileTreeElement)details;
            File file = details.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getFile(...)");
            File file2 = file;
            this.transformAndClose(fileTreeElement, new FileInputStream(file2));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void transformAndClose(FileTreeElement element, InputStream inputStream) {
            Closeable closeable = inputStream;
            Throwable throwable = null;
            try {
                Unit unit;
                Object v1;
                String mappedPath;
                InputStream steam;
                block8: {
                    steam = (InputStream)closeable;
                    boolean bl = false;
                    String string = element.getRelativePath().getPathString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPathString(...)");
                    mappedPath = this.remapper.map(string);
                    Iterable iterable = this.transformers;
                    for (Object t : iterable) {
                        Transformer it = (Transformer)t;
                        boolean bl2 = false;
                        if (!it.canTransformResource(element)) continue;
                        v1 = t;
                        break block8;
                    }
                    v1 = null;
                }
                Transformer transformer = v1;
                if (transformer != null) {
                    transformer.transform(TransformerContext.Companion.builder().path(mappedPath).inputStream(steam).relocators(this.relocators).stats(this.stats).build());
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                Unit unit2 = unit;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }

        private final boolean isTransformable(FileTreeElement element) {
            boolean bl;
            block3: {
                Iterable $this$any$iv = this.transformers;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Transformer it = (Transformer)element$iv;
                        boolean bl2 = false;
                        if (!it.canTransformResource(element)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        private static final ArchiveFileTreeElement processArchive$lambda$3$lambda$0(ShadowCopyAction this$0, ZipEntry it) {
            Intrinsics.checkNotNull((Object)it);
            return new ArchiveFileTreeElement(this$0.new RelativeArchivePath(it));
        }

        private static final boolean processArchive$lambda$3$lambda$1(StreamAction this$0, ArchiveFileTreeElement it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return this$0.patternSet.getAsSpec().isSatisfiedBy((Object)it.asFileTreeElement());
        }
    }
}

