/*
 * Decompiled with CFR 0.152.
 */
package com.github.jengelman.gradle.plugins.shadow;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.GradleException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u001e2\u0006\u00104\u001a\u00020\u001eH\u0016J\b\u00105\u001a\u000202H\u0016J\b\u00106\u001a\u000202H\u0016J\b\u00107\u001a\u000202H\u0016J\b\u00108\u001a\u00020\u001eH\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u001a\u0010\r\u001a\u00020\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0007\"\u0004\b\u000f\u0010\tR\u001a\u0010\u0010\u001a\u00020\u0011X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0017X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR \u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001e0\u001dX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0014\u0010$\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u0007R\u0014\u0010&\u001a\u00020'8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u0014\u0010*\u001a\u00020'8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010)R\u0014\u0010,\u001a\u00020'8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010)R \u0010.\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001e0/8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u0010 \u00a8\u00069"}, d2={"Lcom/github/jengelman/gradle/plugins/shadow/ShadowStats;", "", "<init>", "()V", "totalTime", "", "getTotalTime", "()J", "setTotalTime", "(J)V", "jarStartTime", "getJarStartTime", "setJarStartTime", "jarEndTime", "getJarEndTime", "setJarEndTime", "jarCount", "", "getJarCount", "()I", "setJarCount", "(I)V", "processingJar", "", "getProcessingJar", "()Z", "setProcessingJar", "(Z)V", "relocations", "", "", "getRelocations", "()Ljava/util/Map;", "relocationString", "getRelocationString", "()Ljava/lang/String;", "jarTiming", "getJarTiming", "totalTimeSecs", "", "getTotalTimeSecs", "()D", "averageTimePerJar", "getAverageTimePerJar", "averageTimeSecsPerJar", "getAverageTimeSecsPerJar", "buildScanData", "", "getBuildScanData", "relocate", "", "src", "dst", "startJar", "finishJar", "printStats", "toString", "shadow"})
@SourceDebugExtension(value={"SMAP\nShadowStats.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShadowStats.kt\ncom/github/jengelman/gradle/plugins/shadow/ShadowStats\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,73:1\n126#2:74\n153#2,3:75\n*S KotlinDebug\n*F\n+ 1 ShadowStats.kt\ncom/github/jengelman/gradle/plugins/shadow/ShadowStats\n*L\n15#1:74\n15#1:75,3\n*E\n"})
public class ShadowStats {
    private long totalTime;
    private long jarStartTime;
    private long jarEndTime;
    private int jarCount = 1;
    private boolean processingJar;
    @NotNull
    private final Map<String, String> relocations = new LinkedHashMap();

    public long getTotalTime() {
        return this.totalTime;
    }

    public void setTotalTime(long l) {
        this.totalTime = l;
    }

    public long getJarStartTime() {
        return this.jarStartTime;
    }

    public void setJarStartTime(long l) {
        this.jarStartTime = l;
    }

    public long getJarEndTime() {
        return this.jarEndTime;
    }

    public void setJarEndTime(long l) {
        this.jarEndTime = l;
    }

    public int getJarCount() {
        return this.jarCount;
    }

    public void setJarCount(int n) {
        this.jarCount = n;
    }

    public boolean getProcessingJar() {
        return this.processingJar;
    }

    public void setProcessingJar(boolean bl) {
        this.processingJar = bl;
    }

    @NotNull
    public Map<String, String> getRelocations() {
        return this.relocations;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String getRelocationString() {
        void $this$mapTo$iv$iv;
        Map<String, String> $this$map$iv = this.getRelocations();
        boolean $i$f$map = false;
        Map<String, String> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String k = (String)entry.getKey();
            String v = (String)entry.getValue();
            collection.add(k + " \u2192 " + v);
        }
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)((List)destination$iv$iv)), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }

    public long getJarTiming() {
        return this.getJarEndTime() - this.getJarStartTime();
    }

    public double getTotalTimeSecs() {
        return (double)this.getTotalTime() / 1000.0;
    }

    public double getAverageTimePerJar() {
        return (double)this.getTotalTime() / (double)this.getJarCount();
    }

    public double getAverageTimeSecsPerJar() {
        return this.getAverageTimePerJar() / 1000.0;
    }

    @NotNull
    public Map<String, String> getBuildScanData() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"dependencies", (Object)String.valueOf(this.getJarCount())), TuplesKt.to((Object)"relocations", (Object)this.getRelocationString())};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    public void relocate(@NotNull String src, @NotNull String dst) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        this.getRelocations().put(src, dst);
    }

    public void startJar() {
        if (this.getProcessingJar()) {
            throw new GradleException("Can only time one entry at a time");
        }
        this.setProcessingJar(true);
        this.setJarStartTime(System.currentTimeMillis());
    }

    public void finishJar() {
        if (this.getProcessingJar()) {
            this.setJarEndTime(System.currentTimeMillis());
            int n = this.getJarCount();
            this.setJarCount(n + 1);
            this.setTotalTime(this.getTotalTime() + this.getJarTiming());
            this.setProcessingJar(false);
        }
    }

    public void printStats() {
        System.out.println(this);
    }

    @NotNull
    public String toString() {
        return StringsKt.trimIndent((String)("\n      *******************\n      GRADLE SHADOW STATS\n\n      Total Jars: " + this.getJarCount() + " (includes project)\n      Total Time: " + this.getTotalTimeSecs() + "s [" + this.getTotalTime() + "ms]\n      Average Time/Jar: " + this.getAverageTimeSecsPerJar() + "s [" + this.getAverageTimePerJar() + "ms]\n      *******************\n    "));
    }
}

