/*
 * Decompiled with CFR 0.152.
 */
package com.github.jengelman.gradle.plugins.shadow.relocation;

import com.github.jengelman.gradle.plugins.shadow.relocation.CacheableRelocator;
import com.github.jengelman.gradle.plugins.shadow.relocation.RelocateClassContext;
import com.github.jengelman.gradle.plugins.shadow.relocation.RelocatePathContext;
import com.github.jengelman.gradle.plugins.shadow.relocation.Relocator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.codehaus.plexus.util.SelectorUtils;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.tasks.Input;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@CacheableRelocator
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0017\u0018\u0000 &2\u00020\u0001:\u0001&BW\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\u0010\b\u0002\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\b\u0012\u0010\b\u0002\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\b\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u0005H\u0016J\u0010\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u0005H\u0016J\u0010\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u00052\u0006\u0010#\u001a\u00020\u0005H\u0016J\u0010\u0010$\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u0005H\u0002J\u0010\u0010%\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u0005H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\u00138G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0019\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\u00138G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015\u00a8\u0006'"}, d2={"Lcom/github/jengelman/gradle/plugins/shadow/relocation/SimpleRelocator;", "Lcom/github/jengelman/gradle/plugins/shadow/relocation/Relocator;", "objectFactory", "Lorg/gradle/api/model/ObjectFactory;", "pattern", "", "shadedPattern", "includes", "", "excludes", "rawString", "", "<init>", "(Lorg/gradle/api/model/ObjectFactory;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/util/List;Z)V", "pathPattern", "shadedPathPattern", "sourcePackageExcludes", "", "sourcePathExcludes", "Lorg/gradle/api/provider/SetProperty;", "getIncludes", "()Lorg/gradle/api/provider/SetProperty;", "getExcludes", "include", "exclude", "canRelocatePath", "path", "canRelocateClass", "className", "relocatePath", "context", "Lcom/github/jengelman/gradle/plugins/shadow/relocation/RelocatePathContext;", "relocateClass", "Lcom/github/jengelman/gradle/plugins/shadow/relocation/RelocateClassContext;", "applyToSourceContent", "sourceContent", "isIncluded", "isExcluded", "Companion", "shadow"})
@SourceDebugExtension(value={"SMAP\nSimpleRelocator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimpleRelocator.kt\ncom/github/jengelman/gradle/plugins/shadow/relocation/SimpleRelocator\n+ 2 GradleCompat.kt\ncom/github/jengelman/gradle/plugins/shadow/internal/GradleCompatKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,229:1\n62#2,11:230\n62#2,11:241\n1755#3,3:252\n1755#3,3:255\n*S KotlinDebug\n*F\n+ 1 SimpleRelocator.kt\ncom/github/jengelman/gradle/plugins/shadow/relocation/SimpleRelocator\n*L\n34#1:230,11\n37#1:241,11\n142#1:252,3\n146#1:255,3\n*E\n"})
public class SimpleRelocator
implements Relocator {
    @NotNull
    private static final Companion Companion = new Companion(null);
    private final boolean rawString;
    @NotNull
    private final String pattern;
    @NotNull
    private final String pathPattern;
    @NotNull
    private final String shadedPattern;
    @NotNull
    private final String shadedPathPattern;
    @NotNull
    private final Set<String> sourcePackageExcludes;
    @NotNull
    private final Set<String> sourcePathExcludes;
    @NotNull
    private final SetProperty<String> includes;
    @NotNull
    private final SetProperty<String> excludes;
    @NotNull
    private static final Pattern RX_ENDS_WITH_DOT_SLASH_SPACE;
    @NotNull
    private static final Pattern RX_ENDS_WITH_JAVA_KEYWORD;

    @JvmOverloads
    public SimpleRelocator(@NotNull ObjectFactory objectFactory, @Nullable String pattern, @Nullable String shadedPattern, @Nullable List<String> includes, @Nullable List<String> excludes, boolean rawString) {
        SetProperty setProperty;
        Intrinsics.checkNotNullParameter((Object)objectFactory, (String)"objectFactory");
        this.rawString = rawString;
        this.sourcePackageExcludes = new LinkedHashSet();
        this.sourcePathExcludes = new LinkedHashSet();
        ObjectFactory $this$setProperty_u24default$iv = objectFactory;
        Object defaultValue$iv = null;
        boolean $i$f$setProperty = false;
        SetProperty $this$setProperty_u24lambda_u241$iv = setProperty = $this$setProperty_u24default$iv.setProperty(String.class);
        boolean bl = false;
        SetProperty setProperty2 = setProperty;
        Intrinsics.checkNotNullExpressionValue((Object)setProperty2, (String)"apply(...)");
        this.includes = setProperty2;
        $this$setProperty_u24default$iv = objectFactory;
        defaultValue$iv = null;
        $i$f$setProperty = false;
        $this$setProperty_u24lambda_u241$iv = setProperty = $this$setProperty_u24default$iv.setProperty(String.class);
        bl = false;
        SetProperty setProperty3 = setProperty;
        Intrinsics.checkNotNullExpressionValue((Object)setProperty3, (String)"apply(...)");
        this.excludes = setProperty3;
        if (this.rawString) {
            String string;
            String string2 = pattern;
            if (string2 == null) {
                string2 = this.pathPattern = "";
            }
            if ((string = shadedPattern) == null) {
                string = "";
            }
            this.shadedPathPattern = string;
            this.pattern = "";
            this.shadedPattern = "";
        } else {
            if (pattern == null) {
                this.pattern = "";
                this.pathPattern = "";
            } else {
                this.pattern = StringsKt.replace$default((String)pattern, (char)'/', (char)'.', (boolean)false, (int)4, null);
                this.pathPattern = StringsKt.replace$default((String)pattern, (char)'.', (char)'/', (boolean)false, (int)4, null);
            }
            if (shadedPattern != null) {
                this.shadedPattern = StringsKt.replace$default((String)shadedPattern, (char)'/', (char)'.', (boolean)false, (int)4, null);
                this.shadedPathPattern = StringsKt.replace$default((String)shadedPattern, (char)'.', (char)'/', (boolean)false, (int)4, null);
            } else {
                this.shadedPattern = "hidden." + this.pattern;
                this.shadedPathPattern = "hidden/" + this.pathPattern;
            }
        }
        this.includes.addAll((Iterable)Companion.normalizePatterns((Collection<String>)includes));
        this.excludes.addAll((Iterable)Companion.normalizePatterns((Collection<String>)excludes));
        Object object = includes;
        if (!(object == null || object.isEmpty())) {
            this.includes.addAll((Iterable)includes);
        }
        if (!((object = (Collection)excludes) == null || object.isEmpty())) {
            this.excludes.addAll((Iterable)excludes);
        }
        if (!this.rawString) {
            for (String exclude : (Set)this.excludes.get()) {
                String string;
                Intrinsics.checkNotNull((Object)exclude);
                if (StringsKt.startsWith$default((String)exclude, (String)this.pattern, (boolean)false, (int)2, null)) {
                    String string3 = exclude.substring(this.pattern.length());
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                    CharSequence charSequence = string3;
                    setProperty = new Regex("[.][*]$");
                    string = "";
                    this.sourcePackageExcludes.add(setProperty.replaceFirst(charSequence, string));
                }
                if (!StringsKt.startsWith$default((String)exclude, (String)this.pathPattern, (boolean)false, (int)2, null)) continue;
                String string4 = exclude.substring(this.pathPattern.length());
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                CharSequence charSequence = string4;
                setProperty = new Regex("/[*]$");
                string = "";
                this.sourcePathExcludes.add(setProperty.replaceFirst(charSequence, string));
            }
        }
    }

    public /* synthetic */ SimpleRelocator(ObjectFactory objectFactory, String string, String string2, List list, List list2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            string2 = null;
        }
        if ((n & 8) != 0) {
            list = null;
        }
        if ((n & 0x10) != 0) {
            list2 = null;
        }
        if ((n & 0x20) != 0) {
            bl = false;
        }
        this(objectFactory, string, string2, list, list2, bl);
    }

    @Input
    @NotNull
    public final SetProperty<String> getIncludes() {
        return this.includes;
    }

    @Input
    @NotNull
    public final SetProperty<String> getExcludes() {
        return this.excludes;
    }

    @NotNull
    public SimpleRelocator include(@NotNull String pattern) {
        SimpleRelocator simpleRelocator;
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        SimpleRelocator $this$include_u24lambda_u240 = simpleRelocator = this;
        boolean bl = false;
        $this$include_u24lambda_u240.includes.addAll((Iterable)Companion.normalizePatterns(CollectionsKt.listOf((Object)pattern)));
        return simpleRelocator;
    }

    @NotNull
    public SimpleRelocator exclude(@NotNull String pattern) {
        SimpleRelocator simpleRelocator;
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        SimpleRelocator $this$exclude_u24lambda_u241 = simpleRelocator = this;
        boolean bl = false;
        $this$exclude_u24lambda_u241.excludes.addAll((Iterable)Companion.normalizePatterns(CollectionsKt.listOf((Object)pattern)));
        return simpleRelocator;
    }

    @Override
    public boolean canRelocatePath(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (this.rawString) {
            return Pattern.compile(this.pathPattern).matcher(path).find();
        }
        if (path.length() < this.pathPattern.length()) {
            return false;
        }
        String adjustedPath = StringsKt.removeSuffix((String)path, (CharSequence)".class");
        if (((CharSequence)adjustedPath).length() == 0) {
            return false;
        }
        return this.isIncluded(adjustedPath = StringsKt.removePrefix((String)adjustedPath, (CharSequence)"/")) && !this.isExcluded(adjustedPath) && StringsKt.startsWith$default((String)adjustedPath, (String)this.pathPattern, (boolean)false, (int)2, null);
    }

    @Override
    public boolean canRelocateClass(@NotNull String className) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        return !this.rawString && !StringsKt.contains$default((CharSequence)className, (char)'/', (boolean)false, (int)2, null) && this.canRelocatePath(StringsKt.replace$default((String)className, (char)'.', (char)'/', (boolean)false, (int)4, null));
    }

    @Override
    @NotNull
    public String relocatePath(@NotNull RelocatePathContext context) {
        String string;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String path = context.getPath();
        context.getStats().relocate(this.pathPattern, this.shadedPathPattern);
        if (this.rawString) {
            CharSequence charSequence = path;
            Regex regex = new Regex(this.pathPattern);
            String string2 = this.shadedPathPattern;
            string = regex.replace(charSequence, string2);
        } else {
            CharSequence charSequence = path;
            Regex regex = new Regex(this.pathPattern);
            String string3 = this.shadedPathPattern;
            string = regex.replaceFirst(charSequence, string3);
        }
        return string;
    }

    @Override
    @NotNull
    public String relocateClass(@NotNull RelocateClassContext context) {
        String string;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        context.getStats().relocate(this.pathPattern, this.shadedPathPattern);
        String clazz = context.getClassName();
        if (this.rawString) {
            string = clazz;
        } else {
            CharSequence charSequence = clazz;
            Regex regex = new Regex(this.pattern);
            String string2 = this.shadedPattern;
            string = regex.replaceFirst(charSequence, string2);
        }
        return string;
    }

    @Override
    @NotNull
    public String applyToSourceContent(@NotNull String sourceContent) {
        Intrinsics.checkNotNullParameter((Object)sourceContent, (String)"sourceContent");
        if (this.rawString) {
            return sourceContent;
        }
        String content = Companion.shadeSourceWithExcludes(sourceContent, this.pattern, this.shadedPattern, this.sourcePackageExcludes);
        return Companion.shadeSourceWithExcludes(content, this.pathPattern, this.shadedPathPattern, this.sourcePathExcludes);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isIncluded(String path) {
        String it;
        if (((Set)this.includes.get()).isEmpty()) return true;
        Object object = this.includes.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        Iterable $this$any$iv = (Iterable)object;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            it = (String)element$iv;
            boolean bl = false;
        } while (!SelectorUtils.matchPath((String)it, (String)path, (String)"/", (boolean)true));
        return true;
    }

    private final boolean isExcluded(String path) {
        boolean bl;
        block3: {
            Object object = this.excludes.get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            Iterable $this$any$iv = (Iterable)object;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!SelectorUtils.matchPath((String)it, (String)path, (String)"/", (boolean)true)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @JvmOverloads
    public SimpleRelocator(@NotNull ObjectFactory objectFactory, @Nullable String pattern, @Nullable String shadedPattern, @Nullable List<String> includes, @Nullable List<String> excludes) {
        Intrinsics.checkNotNullParameter((Object)objectFactory, (String)"objectFactory");
        this(objectFactory, pattern, shadedPattern, includes, excludes, false, 32, null);
    }

    @JvmOverloads
    public SimpleRelocator(@NotNull ObjectFactory objectFactory, @Nullable String pattern, @Nullable String shadedPattern, @Nullable List<String> includes) {
        Intrinsics.checkNotNullParameter((Object)objectFactory, (String)"objectFactory");
        this(objectFactory, pattern, shadedPattern, includes, null, false, 48, null);
    }

    @JvmOverloads
    public SimpleRelocator(@NotNull ObjectFactory objectFactory, @Nullable String pattern, @Nullable String shadedPattern) {
        Intrinsics.checkNotNullParameter((Object)objectFactory, (String)"objectFactory");
        this(objectFactory, pattern, shadedPattern, null, null, false, 56, null);
    }

    @JvmOverloads
    public SimpleRelocator(@NotNull ObjectFactory objectFactory, @Nullable String pattern) {
        Intrinsics.checkNotNullParameter((Object)objectFactory, (String)"objectFactory");
        this(objectFactory, pattern, null, null, null, false, 60, null);
    }

    @JvmOverloads
    public SimpleRelocator(@NotNull ObjectFactory objectFactory) {
        Intrinsics.checkNotNullParameter((Object)objectFactory, (String)"objectFactory");
        this(objectFactory, null, null, null, null, false, 62, null);
    }

    static {
        Pattern pattern = Pattern.compile("[./ ]$");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        RX_ENDS_WITH_DOT_SLASH_SPACE = pattern;
        Pattern pattern2 = Pattern.compile("\\b(import|package|public|protected|private|static|final|synchronized|abstract|volatile|extends|implements|throws) $|\\{@link( \\*)* $|([{}(=;,]|\\*/) $");
        Intrinsics.checkNotNullExpressionValue((Object)pattern2, (String)"compile(...)");
        RX_ENDS_WITH_JAVA_KEYWORD = pattern2;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0006\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000eJ,\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\f0\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lcom/github/jengelman/gradle/plugins/shadow/relocation/SimpleRelocator$Companion;", "", "<init>", "()V", "RX_ENDS_WITH_DOT_SLASH_SPACE", "Ljava/util/regex/Pattern;", "getRX_ENDS_WITH_DOT_SLASH_SPACE", "()Ljava/util/regex/Pattern;", "RX_ENDS_WITH_JAVA_KEYWORD", "getRX_ENDS_WITH_JAVA_KEYWORD", "normalizePatterns", "", "", "patterns", "", "shadeSourceWithExcludes", "sourceContent", "patternFrom", "patternTo", "excludedPatterns", "shadow"})
    @SourceDebugExtension(value={"SMAP\nSimpleRelocator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimpleRelocator.kt\ncom/github/jengelman/gradle/plugins/shadow/relocation/SimpleRelocator$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,229:1\n774#2:230\n865#2,2:231\n1872#2,3:233\n*S KotlinDebug\n*F\n+ 1 SimpleRelocator.kt\ncom/github/jengelman/gradle/plugins/shadow/relocation/SimpleRelocator$Companion\n*L\n202#1:230\n202#1:231,2\n203#1:233,3\n*E\n"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Pattern getRX_ENDS_WITH_DOT_SLASH_SPACE() {
            return RX_ENDS_WITH_DOT_SLASH_SPACE;
        }

        @NotNull
        public final Pattern getRX_ENDS_WITH_JAVA_KEYWORD() {
            return RX_ENDS_WITH_JAVA_KEYWORD;
        }

        @NotNull
        public final Set<String> normalizePatterns(@Nullable Collection<String> patterns) {
            Set set;
            Set $this$normalizePatterns_u24lambda_u240 = set = SetsKt.createSetBuilder();
            boolean bl = false;
            if (patterns != null) {
                for (String pattern : patterns) {
                    String packagePattern;
                    if (StringsKt.startsWith$default((String)pattern, (String)"%regex[", (boolean)false, (int)2, null)) {
                        $this$normalizePatterns_u24lambda_u240.add(pattern);
                        continue;
                    }
                    String classPattern = StringsKt.replace$default((String)pattern, (char)'.', (char)'/', (boolean)false, (int)4, null);
                    $this$normalizePatterns_u24lambda_u240.add(classPattern);
                    if (!StringsKt.endsWith$default((String)classPattern, (String)"/*", (boolean)false, (int)2, null) && !StringsKt.endsWith$default((String)classPattern, (String)"/**", (boolean)false, (int)2, null)) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)classPattern.substring(0, StringsKt.lastIndexOf$default((CharSequence)classPattern, (char)'/', (int)0, (boolean)false, (int)6, null)), (String)"substring(...)");
                    $this$normalizePatterns_u24lambda_u240.add(packagePattern);
                }
            }
            return SetsKt.build((Set)set);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final String shadeSourceWithExcludes(@NotNull String sourceContent, @NotNull String patternFrom, @NotNull String patternTo, @NotNull Set<String> excludedPatterns) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Intrinsics.checkNotNullParameter((Object)sourceContent, (String)"sourceContent");
            Intrinsics.checkNotNullParameter((Object)patternFrom, (String)"patternFrom");
            Intrinsics.checkNotNullParameter((Object)patternTo, (String)"patternTo");
            Intrinsics.checkNotNullParameter(excludedPatterns, (String)"excludedPatterns");
            StringBuilder shadedSourceContent = new StringBuilder(sourceContent.length() * 11 / 10);
            Object object = sourceContent;
            Regex regex = new Regex("\\b" + StringsKt.replace$default((String)patternFrom, (String)".", (String)"[.]", (boolean)false, (int)4, null) + "\\b");
            int n = 0;
            object = regex.split((CharSequence)object, n);
            boolean $i$f$filter = false;
            void var9_10 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                CharSequence p0 = (CharSequence)element$iv$iv;
                boolean bl = false;
                boolean bl2 = p0.length() > 0;
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List snippets = (List)destination$iv$iv;
            Iterable $this$forEachIndexed$iv = snippets;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                StringBuilder stringBuilder;
                void snippet;
                CharSequence excludedPattern2;
                int n2;
                Object element$iv$iv;
                if ((n2 = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                element$iv$iv = (String)item$iv;
                int i = n2;
                boolean bl = false;
                boolean isFirstSnippet = i == 0;
                String previousSnippet = isFirstSnippet ? "" : (String)snippets.get(i - 1);
                boolean doExclude = false;
                for (CharSequence excludedPattern2 : excludedPatterns) {
                    if (!StringsKt.startsWith$default((String)snippet, (String)excludedPattern2, (boolean)false, (int)2, null)) continue;
                    doExclude = true;
                    break;
                }
                if (isFirstSnippet) {
                    stringBuilder = shadedSourceContent.append((String)snippet);
                    continue;
                }
                excludedPattern2 = previousSnippet;
                Regex regex2 = new Regex("\\s+");
                String string = " ";
                String previousSnippetOneLine = regex2.replace(excludedPattern2, string);
                boolean afterDotSlashSpace = Companion.getRX_ENDS_WITH_DOT_SLASH_SPACE().matcher(previousSnippetOneLine).find();
                boolean afterJavaKeyWord = Companion.getRX_ENDS_WITH_JAVA_KEYWORD().matcher(previousSnippetOneLine).find();
                boolean shouldExclude = doExclude || afterDotSlashSpace && !afterJavaKeyWord;
                stringBuilder = shadedSourceContent.append(shouldExclude ? patternFrom : patternTo).append((String)snippet);
            }
            String string = shadedSourceContent.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

