/*
 * Decompiled with CFR 0.152.
 */
package com.github.jengelman.gradle.plugins.shadow.transformers;

import com.github.jengelman.gradle.plugins.shadow.ShadowStats;
import com.github.jengelman.gradle.plugins.shadow.relocation.RelocateClassContext;
import com.github.jengelman.gradle.plugins.shadow.relocation.Relocator;
import com.github.jengelman.gradle.plugins.shadow.transformers.CacheableTransformer;
import com.github.jengelman.gradle.plugins.shadow.transformers.Transformer;
import com.github.jengelman.gradle.plugins.shadow.transformers.TransformerContext;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.commons.io.output.CloseShieldOutputStream;
import org.apache.logging.log4j.core.config.plugins.processor.PluginCache;
import org.apache.logging.log4j.core.config.plugins.processor.PluginEntry;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;
import org.gradle.api.file.FileTreeElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@CacheableTransformer
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\fH\u0016J\u0018\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\fH\u0016J\u0015\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001aH\u0000\u00a2\u0006\u0002\b\u001bJ\b\u0010\u001c\u001a\u00020\u0010H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!\u00a8\u0006\""}, d2={"Lcom/github/jengelman/gradle/plugins/shadow/transformers/Log4j2PluginsCacheFileTransformer;", "Lcom/github/jengelman/gradle/plugins/shadow/transformers/Transformer;", "<init>", "()V", "tempFiles", "", "Ljava/nio/file/Path;", "tempRelocators", "Lcom/github/jengelman/gradle/plugins/shadow/relocation/Relocator;", "stats", "Lcom/github/jengelman/gradle/plugins/shadow/ShadowStats;", "canTransformResource", "", "element", "Lorg/gradle/api/file/FileTreeElement;", "transform", "", "context", "Lcom/github/jengelman/gradle/plugins/shadow/transformers/TransformerContext;", "hasTransformedResource", "modifyOutputStream", "os", "Lorg/apache/tools/zip/ZipOutputStream;", "preserveFileTimestamps", "relocatePlugins", "pluginCache", "Lorg/apache/logging/log4j/core/config/plugins/processor/PluginCache;", "relocatePlugins$shadow", "deleteTempFiles", "urlEnumeration", "Ljava/util/Enumeration;", "Ljava/net/URL;", "getUrlEnumeration", "()Ljava/util/Enumeration;", "shadow"})
@SourceDebugExtension(value={"SMAP\nLog4j2PluginsCacheFileTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Log4j2PluginsCacheFileTransformer.kt\ncom/github/jengelman/gradle/plugins/shadow/transformers/Log4j2PluginsCacheFileTransformer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,109:1\n1863#2:110\n1863#2:111\n295#2,2:112\n1864#2:114\n1864#2:115\n1557#2:116\n1628#2,3:117\n*S KotlinDebug\n*F\n+ 1 Log4j2PluginsCacheFileTransformer.kt\ncom/github/jengelman/gradle/plugins/shadow/transformers/Log4j2PluginsCacheFileTransformer\n*L\n82#1:110\n83#1:111\n86#1:112,2\n83#1:114\n82#1:115\n105#1:116\n105#1:117,3\n*E\n"})
public class Log4j2PluginsCacheFileTransformer
implements Transformer {
    @NotNull
    private final List<Path> tempFiles = new ArrayList();
    @NotNull
    private final List<Relocator> tempRelocators = new ArrayList();
    @Nullable
    private ShadowStats stats;

    @Override
    public boolean canTransformResource(@NotNull FileTreeElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return Intrinsics.areEqual((Object)"META-INF/org/apache/logging/log4j/core/config/plugins/Log4j2Plugins.dat", (Object)element.getRelativePath().getPathString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transform(@NotNull TransformerContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Path path = Files.createTempFile("Log4j2Plugins", ".dat", Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"createTempFile(...)");
        Path temporaryFile = path;
        this.tempFiles.add(temporaryFile);
        OpenOption[] openOptionArray = new OpenOption[]{};
        OutputStream outputStream = Files.newOutputStream(temporaryFile, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
        OutputStream fos = outputStream;
        Closeable closeable = context.getInputStream();
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl = false;
            long l = ByteStreamsKt.copyTo$default((InputStream)it, (OutputStream)fos, (int)0, (int)2, null);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        this.tempRelocators.addAll((Collection<Relocator>)context.getRelocators());
        if (this.stats == null) {
            this.stats = context.getStats();
        }
    }

    @Override
    public boolean hasTransformedResource() {
        return !((Collection)this.tempFiles).isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modifyOutputStream(@NotNull ZipOutputStream os, boolean preserveFileTimestamps) {
        Intrinsics.checkNotNullParameter((Object)os, (String)"os");
        try {
            PluginCache aggregator = new PluginCache();
            aggregator.loadCacheFiles(this.getUrlEnumeration());
            this.relocatePlugins$shadow(aggregator);
            ZipEntry entry = new ZipEntry("META-INF/org/apache/logging/log4j/core/config/plugins/Log4j2Plugins.dat");
            entry.setTime(TransformerContext.Companion.getEntryTimestamp(preserveFileTimestamps, entry.getTime()));
            os.putNextEntry(entry);
            aggregator.writeCache((OutputStream)CloseShieldOutputStream.wrap((OutputStream)((OutputStream)os)));
        }
        finally {
            this.deleteTempFiles();
        }
    }

    public final void relocatePlugins$shadow(@NotNull PluginCache pluginCache) {
        Intrinsics.checkNotNullParameter((Object)pluginCache, (String)"pluginCache");
        Iterable $this$forEach$iv = pluginCache.getAllCategories().values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map currentMap = (Map)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = currentMap.values();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Relocator relocator;
                Object v1;
                RelocateClassContext relocateClassContext;
                PluginEntry currentPluginEntry;
                block4: {
                    currentPluginEntry = (PluginEntry)element$iv2;
                    boolean bl2 = false;
                    String className = currentPluginEntry.getClassName();
                    Intrinsics.checkNotNull((Object)className);
                    ShadowStats shadowStats = this.stats;
                    if (shadowStats == null) {
                        String string = "Required value was null.";
                        throw new IllegalArgumentException(string.toString());
                    }
                    relocateClassContext = new RelocateClassContext(className, shadowStats);
                    Iterable $this$firstOrNull$iv = this.tempRelocators;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv3 : $this$firstOrNull$iv) {
                        Relocator it = (Relocator)element$iv3;
                        boolean bl3 = false;
                        if (!it.canRelocateClass(className)) continue;
                        v1 = element$iv3;
                        break block4;
                    }
                    v1 = null;
                }
                if ((Relocator)v1 == null) continue;
                boolean bl4 = false;
                currentPluginEntry.setClassName(relocator.relocateClass(relocateClassContext));
            }
        }
    }

    private final void deleteTempFiles() {
        ListIterator<Path> pathIterator = this.tempFiles.listIterator();
        while (pathIterator.hasNext()) {
            Path path = pathIterator.next();
            Files.deleteIfExists(path);
            pathIterator.remove();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Enumeration<URL> getUrlEnumeration() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.tempFiles;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Path path = (Path)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.toUri().toURL());
        }
        List urls = (List)destination$iv$iv;
        Enumeration<URL> enumeration = Collections.enumeration(urls);
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"enumeration(...)");
        return enumeration;
    }
}

